<?php

use Illuminate\Support\Facades\Route;
use App\User;
use Modules\Album\Entities\Album;
use Modules\Setting\Entities\Currency;
use App\Notifications\UserNotification;
use App\Http\Controllers\PWASettingController;
use App\Helpers\currencyRate;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/ 

Route::get('/changeCurrency/{id}', function($id){
    $currency = Currency::where('id',$id)->first();
    if(isset($currency)){
        session()->put('currency',[
            'code' => $currency->code,
            'symbol' => $currency->symbol
        ]);
    }
    
    $rate = currencyRate::fetchRate();
    return session()->get('currency');
});


Auth::routes(['login'=>false, 'register' => false]); 
Route::get('logout', 'Auth\LoginController@logout');
Route::post('login', 'Auth\LoginController@authenticated')->name('login.process');
Route::post('user/login/', 'AdminController@authenticated')->name('user.login'); // user login
Route::get('user_logout', 'AdminController@logout')->name('user.logout'); // user logout
Route::get('/home', 'HomeController@index')->name('home');
Route::post('/user_register', 'AdminController@register')->name('user_register');
Route::get('/socialLogin/{service}', 'AdminController@socialLogin')->name('socialLogin');
Route::get('/callback/{service}', 'AdminController@socialLoginRedirect')->name('socialLoginRedirect');

Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');

        Route::group(['middleware' => ['autheticated']], function(){
        Route::post('/paypal', 'transactionController@postPaymentWithpaypal')->name('paypal');
        Route::get('/paypal', 'transactionController@getPaymentStatus')->name('getPaymentStatus');
        Route::get('/checkout', 'transactionController@paypalCancelReturn');
    
        Route::get('/stripe', 'transactionController@stripe')->name('stripe');
        Route::post('/stripe/checkout', 'transactionController@stripePayment')->name('stripe.checkout');
    
        Route::get('razorpay/payments', 'transactionController@payWithRazorpay')->name('paywithrazorpay');
        Route::post('razorpay/payment', 'transactionController@payment')->name('razor.payment');
    
        Route::get('/braintree/accesstoken', 'transactionController@accesstoken')->name('bttoken');
        Route::get('/braintree', 'transactionController@braintree')->name('braintree');
        Route::get('/payment/make', 'transactionController@braintreePay')->name('payment.make');
        Route::post('/successBraintree', 'transactionController@successBraintree')->name('successBraintree');
    
        Route::get('instamojo', 'transactionController@instamojo');
        Route::post('paywithinstamojo', 'transactionController@payWithIM');
        Route::get('pay-success', 'transactionController@success')->name('instamojo.success');
    
        Route::get('/paystack', 'transactionController@paystack');
        Route::post('/paywithPaystack', 'transactionController@redirectToGateway')->name('paywithPaystack');
        Route::get('/paystack/callback', 'transactionController@handleGatewayCallback');
    
        Route::get('/payu', 'transactionController@payu');
        Route::get('/paywithpayu', 'transactionController@payWithPayu')->name('payWithPayu');
        Route::get('/payUstatus', 'transactionController@payUstatus')->name('payUstatus');
    
        Route::get('/paytm', 'transactionController@order')->name('paytm');
        Route::post('/payment/status', 'transactionController@paymentCallback');
    
        Route::post('/manual_pay', 'transactionController@payWithManualPay')->name('payWithManualPay');
       
        Route::post('/user/comment/{type}/{id}','HomeController@user_comment');
            
        Route::get('/user/profile','HomeController@user_profile');
        Route::post('/update_profile','HomeController@update_profile');
        Route::get('/download_audio','HomeController@downloadaudio');
         
        Route::post('/apply-coupon/{id}','TransactionController@applyCoupon')->name('applyCoupon');
        Route::post('/razorpay/proceed','TransactionController@razorpayFormRender')->name('razorpayFormRender');
        Route::post('/readNotification', 'HomeController@readNotification');
        Route::get('/payment-single/{id}','HomeController@paymentSingle');
    });
    Route::post('/add_to_favourite/{id}','HomeController@add_favourite_list')->name('album.add_favourite');
    Route::post('/like_dislike_audio','HomeController@like_dislike_audio');

    Route::get('/pricing-plan','HomeController@pricing_plan')->name('pricing-plan');

    Route::group(['middleware'=>['auth']],function (){
        Route::get('/admin','AdminController@index')->name('admin');
        
        Route::get('locale/{locale}', 'adminController@setLanguage');
        
        Route::post('/s3Audios','adminController@s3Audios')->name('s3Audios');
        Route::get('/getImage','adminController@getImage')->name('getImage');

        Route::get('user/invoice/{purchase_id}/{invoice_id}/{type}', 'AdminController@user_invoice')->name('user.invoice');
        Route::post('/payment_status', 'TransactionController@payment_status')->name('payment_status');

        Route::get('paymentNotification/{data}', 'TransactionController@paymentNotify');
    }); 

    //front url
    Route::get('/', 'HomeController@index');
    Route::post('/newsletter','HomeController@newsletter')->name('newsletter');
    Route::post('/song_detail', 'HomeController@get_song_list');
    Route::post('/songs', 'HomeController@play_single_music');
    Route::post('/filter_language','HomeController@filter_music_language')->name('audio.language');
    Route::get('/user/album','HomeController@album')->name('user.album');
    Route::get('/album/single/{id}/{slug}', 'HomeController@album_single'); 
    Route::get('/artist/single/{id}/{slug}', 'HomeController@artist_single')->name('artist.single');
    Route::get('/audio/single/{id}/{slug}', 'HomeController@audio_single')->name('audio.single');
    Route::get('/blog/single/{id}/{slug}', 'HomeController@blog_single')->name('blog.single');
    Route::get('/user/track','HomeController@audio')->name('user.audio');
    Route::get('/user/favourite','HomeController@favourite')->name('user.favourite');
    Route::get('/user/artist','HomeController@artist')->name('user.artist');
    Route::get('/user/genres','HomeController@genres')->name('user.genres');
    
    Route::get('/user/history','HomeController@history')->name('user.history');
    Route::get('/user/download','HomeController@download')->name('user.download');
    Route::get('/user/free-music','HomeController@free_music')->name('user.free_music');
    Route::get('/user/playlist','HomeController@playlist')->name('user.playlist');
    
    Route::post('/download_track','HomeController@download_track')->name('download_track');
    Route::post('/create_playlist','HomeController@create_playlist')->name('create_playlist');
    Route::post('/play_playlist_song','HomeController@play_playlist_song');
    Route::post('/add_in_playlist','HomeController@add_in_playlist');
    Route::post('/remove_playlist','HomeController@remove_playlist');
    Route::get('/playlist/single/{id}','HomeController@playlist_single');
    Route::post('/playlist/remove_track','HomeController@remove_music_from_playlist');
    Route::get('/user/radio_station','HomeController@radio_station')->name('user.radio_station');
    Route::get('/radio/single/{id}/{slug}','HomeController@radio_single')->name('radio.single');
    Route::get('/genre/single/{id}/{slug}','HomeController@genre_single')->name('genre.single');
    Route::post('/song_play/count','HomeController@playSongCount');
    Route::get('/set_top_detail','HomeController@top_detail_cron_job');
    
    Route::get('/search/{name}','HomeController@search');
    Route::get('/faqs','HomeController@faq');
    Route::get('/blogs','HomeController@blog');
    Route::get('/pages/{id}', 'HomeController@pages');
    
    Route::get('admin/pwasetting', [PWASettingController::class, 'show'])->name('pwa.show');
    Route::post('/pwa-setting', [PWASettingController::class, 'store'])->name('pwa.store');
    Route::get('/manifest.json', [PWASettingController::class, 'manifest'])->name('laravelpwa.manifest');

        /*---ChatgptController start--*/
        Route::post('/openai/text', 'ChatgptController@text');
        Route::post('/openai/image', 'ChatgptController@image');
        Route::get('/openai', 'ChatgptController@useropenai')->name('openai');
        Route::post('openai-bulk-delete', 'ChatgptController@bulk_delete')->name('openai.bulk.delete');
        Route::delete('openai/delete/{id}', 'ChatgptController@delete')->name('openai.delete');
        Route::get('/api-setting', 'ApiSettingController@apisetting')->name('api-setting.index');
        Route::post('openapikey/api-setting', 'ApiSettingController@openapikey')->name('openapikey.store');
        /*---ChatgptController end--*/
        
        // /*---Service Controller start--*/
        Route::get('services', 'ServiceController@index')->name('services.index');
        Route::post('services', 'AlbumController@albumData')->name('albumData');
        Route::post('services', 'ServiceController@store')->name('services.store');
        Route::get('services/{id}/edit', 'ServiceController@edit')->name('services.edit');
        Route::put('services/{id}', 'ServiceController@update')->name('services.update');
        Route::delete('services/{id}/delete', 'ServiceController@destroy')->name('services.destroy');
        Route::post('/services/bulk_delete', 'ServiceController@bulk_delete')->name('services.bulk_delete');
        Route::get('services/update-status', 'ServiceController@updateStatus');

// /*---Service Controller end--*/
