<!--
**********************************************************************************************************
    Copyright (c) 2024.
**********************************************************************************************************  -->
<!--
  Template Name: miraculous - Music Streaming Laravel Script
  Version: 1.4
  Author: Media City
-->
<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="description" content="{{ (isset($settings['meta_desc']) ? $settings['meta_desc'] : '') }}">
        <meta name="keywords" content="{{ (isset($settings['keywords']) ? $settings['keywords'] : '') }}">
        <meta name="author" content="{{ (isset($settings['author_name']) ? $settings['author_name'] : '' ) }}">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title> @yield('title') | {{ $title }} </title>
        @if(isset($settings['favicon']))
            <link href="{{ asset('images/sites/'.$settings['favicon']) }}" rel="shortcut icon" >
        @endif
        @yield('style')
        <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/css/icons.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/css/flag-icon.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/plugins/toastr/toastr.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/css/font-awesome.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/css/fonts.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('assets/plugins/nice_select/nice-select.css') }}" rel="stylesheet" type="text/css" >
        <link href="{{ asset('assets/plugins/scroll/jquery.mCustomScrollbar.css') }}" rel="stylesheet" type="text/css" >
        <link href="{{ asset('assets/plugins/swiper/css/swiper.min.css') }}" rel="stylesheet" type="text/css">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css" rel="stylesheet" type="text/css">
        @toastr_css
        <link href="{{ asset('assets/css/front/custom-style.css') }}" rel="stylesheet" type="text/css">
        <script>
            var baseURL = "{{url('/')}}";
            var checkUserId = '{{ isset(Auth::user()->id) ? Auth::user()->id : ''}}';
        </script>
        @if(isset($settings['google_analysis']) && $settings['google_analysis'] != '')
            <script async="" src="https://www.googletagmanager.com/gtag/js?id={{ $settings['google_analysis'] }}"></script>     
            <script>
                window.dataLayer = window.dataLayer || [];
                function gtag() {
                    dataLayer.push(arguments);
                }
                gtag('js', new Date());
                gtag('config', "{{ $settings['google_analysis'] }}");
            </script>   
        @endif 
        <script>
            var dynamicName = '<?php echo json_encode(['select_lang'=>__('frontWords.select_lang'),'something_wrong' => __('frontWords.something_wrong'), 'playlist_err' => __('frontWords.playlist_err'),'select_playlist' => __('frontWords.select_playlist'), 'no_song' => __('frontWords.no_song'), 'required_fields' => __('frontWords.required_fields'), 'pass_err' => __('frontWords.pass_err'), 'cnf_pass_err' => __('frontWords.cnf_pass_err'), 'cnf_mismatch' => __('frontWords.cnf_mismatch'), 'only_allowed' => __('frontWords.only_allowed'), 'files' => __('frontWords.files'), 'login_err' => __('frontWords.login_err'), 'coupon_err' => __('frontWords.coupon_err'), 'search_err' => __('frontWords.search_err'), 'are_u_sure' => __('frontWords.are_u_sure'), 'delete_records' => __('frontWords.delete_records'), 'delete_records' => __('adminWords.delete_records'), 'delete' => __('adminWords.delete') ]) ?>';
        </script>  
    </head>
        @inject('google_ad', 'Modules\Setting\Entities\GoogleAd')
        @inject('notifications', 'Modules\Setting\Entities\GoogleAd')
        @include('layouts.front.header')  
        @yield('content')
        @include('layouts.front.footer')
        
        <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js" ></script>
        <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/swiper/js/swiper.min.js') }}" type="text/javascript" ></script>
        <script src="{{ asset('assets/plugins/nice_select/jquery.nice-select.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('assets/plugins/scroll/jquery.mCustomScrollbar.js') }}" type="text/javascript"></script>
        {{-- @include('sweet::alert') --}}
        <script src="{{ asset('assets/js/player/jplayer.playlist.min.js') }}"></script>
        <script src="{{ asset('assets/js/player/jquery.jplayer.min.js') }}"></script>
        <script src="{{ asset('assets/js/audio-player.js') }}"></script>
        <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
        <script src="{{ asset('assets/js/jquery.slimscroll.js') }}"></script>
        <script src="{{ asset('assets/plugins/toastr/toastr.min.js') }}"></script> 
        <script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script> 
        <script src="{{ asset('assets/js/card.js') }}"></script>
        <script src="{{ asset('assets/js/valid.js') }}"></script> 
        <script src="{{ asset('assets/js/submit.js') }}"></script> 
        <script src="{{ asset('assets/js/front/ajax-custom.js?'.time()) }}"></script>
        <script src="{{ asset('assets/js/front/custom.js') }}"></script>
        @yield('script')
        <script>
            var isInspect = 0;
            var isRightClick = 0;
        </script>
        @php
            if(!empty($settings)){
                if(isset($settings['inspect']) && $settings['inspect'] == 0){
        @endphp
            <script>
                isInspect = 1;
            </script>
        @php
            }
            if(isset($settings['right_click']) && $settings['right_click'] == 0){  @endphp
                <script>
                    isRightClick = 1;
                </script>
        @php  
            }
        }
        @endphp
        @toastr_js
        @toastr_render
    </body>
</html>    
