<!--
**********************************************************************************************************
    Copyright (c) 2024.
**********************************************************************************************************  -->
<!--
  Template Name: miraculous - Multi-Vendor Music Streaming Laravel Script
  Version: 1.4.0
  Author: Media City
-->
<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="{{ isset($settings['meta_desc']) ? $settings['meta_desc'] : '' }}">
    <meta name="keywords" content="{{ isset($settings['keywords']) ? $settings['keywords'] : '' }}">
    <meta name="author" content="{{ isset($settings['author_name']) ? $settings['author_name'] : '' }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title> @yield('title') | {{ $title }} </title>
    @if (isset($settings['favicon']))
        <link rel="shortcut icon" href="{{ asset('images/sites/' . $settings['favicon']) }}">
    @endif

    <meta name="theme-color" content="#6777EF">
    <link href="{{ asset('logo.png') }}" rel="apple-touch-icon">
    <link href="{{ asset('/manifest.json') }}" rel="manifest">

    @yield('style')
    <link href="{{ asset('assets/css/icons.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/flag-icon.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/toastr/toastr.min.css') }}" rel="stylesheet" type="text/css">
    @if (isset($settings['google_analysis']) && $settings['google_analysis'] != '')
        <script async="" src="https://www.googletagmanager.com/gtag/js?id={{ $settings['google_analysis'] }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "{{ $settings['google_analysis'] }}");
        </script>
    @endif
</head>

<body class="vertical-layout">
    <div class="admin_loader_wrapper">
        <img src="{{ asset('assets/images/loader.svg') }}" class="img-fluid" alt="{{ __('Loading') }}" />
    </div>
    <div id="infobar-settings-sidebar" class="infobar-settings-sidebar">
        <div class="infobar-settings-sidebar-head d-flex w-100 justify-content-between">
            <h4>{{ __('adminWords.settings') }}</h4>
            <a href="javascript:void(0)" id="infobar-settings-close" class="infobar-settings-close" title="{{ __('Close Settings') }}">
                <img src="{{ asset('assets/images/svg-icon/close.svg') }}" class="img-fluid menu-hamburger-close" alt="{{ __('Close') }}">
            </a>
        </div>
    </div>
    
    <div class="infobar-settings-sidebar-overlay"></div>
    <div id="containerbar">
        @include('layouts.admin.leftbar')
        @include('layouts.admin.rightbar')
        @yield('content')
    </div>
    <script>
        var dynamicName = '<?php echo json_encode([
            'city' => __('adminWords.city'),
            'country' => __('adminWords.country'),
            'state' => __('adminWords.state'),
            'select' => __('adminWords.select'),
            'add' => __('adminWords.add'),
            'update' => __('adminWords.update'),
            'chooseImage' => __('adminWords.choose_image'),
            'imgExtErr' => __('adminWords.img_ext'),
            'fileType' => __('adminWords.file_type'),
            'dimensionErr' => __('adminWords.dimension_err'),
            'selectImgErr' => __('adminWords.select_image'),
            'pleaseChoose' => __('adminWords.choose'),
            'blogCat' => __('adminWords.blog_cat'),
            'audioGenre' => __('adminWords.audio_genre'),
            'artistGenre' => __('adminWords.artist_genres'),
            'notification' => __('adminWords.notification'),
            'language' => __('adminWords.language'),
            'delete_records' => __('adminWords.delete_records'),
            'cantUndone' => __('adminWords.cantUndone'),
            'delete' => __('adminWords.delete'),
            'currency' => __('adminWords.currency'),
            'ok' => __('adminWords.ok'),
            'update_rate_text' => __('adminWords.update_rate_text'),
            'are_u_sure' => __('adminWords.are_u_sure'),
            'make_default' => __('adminWords.make_default'),
            'default_curr' => __('adminWords.default_curr'),
        ]); ?>';
    </script>

    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/modernizr.min.js') }}"></script>
    <script src="{{ asset('assets/js/detect.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.slimscroll.js') }}"></script>
    <script src="{{ asset('assets/js/vertical-menu.js') }}"></script>
    <script src="{{ asset('assets/plugins/toastr/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/js/valid.js') }}"></script>
    <script src="{{ asset('assets/js/submit.js') }}"></script>
    @yield('script')
    <script src="{{ asset('assets/js/core.js') }}"></script>
    <script>
        var baseUrl = '{{ url('/') }}'
    </script>
    <script>
        var currentYear = new Date().getFullYear();
        document.getElementById("copyright").innerHTML = "© Copyright " + currentYear + ", All Rights Reserved Version " +
            "{{ config('app.version') }}";
    </script>

    <!-- Ai Script js start -->

<script>
    // offcanvas menu
    $(".menu-tigger").on("click", function() {
        $(".offcanvas-menu,.offcanvas-overly").addClass("active");
        return false;
    });
    $(".menu-close,.offcanvas-overly").on("click", function() {
        $(".offcanvas-menu,.offcanvas-overly").removeClass("active");
    });
</script>
<script>
    (function($) {
        $(document).ready(function() {
            $('a[data-toggle="pill"]').on('show.bs.tab', function(e) {
                localStorage.setItem('activeTab', $(e.target).attr('href'));
            });
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('#v-pills-tab a[href="' + activeTab + '"]').tab('show');
            }
        });
    })(jQuery);
</script>
<script>
    function readURL(input) {

        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#' + input.name).attr('src', e.target.result);
            }

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    $("#mytext").on('submit', function(e) {
        // alert('hello');
        console.log("data");
        e.preventDefault();
        $('.service_btn').text('Please Wait..');
        $('.service_btn').prop("disabled", true);
        var formData = new FormData();
        var a = formData.append('service', $("#service").val());
        var b = formData.append('language', $("#language").val());
        var c = formData.append('keyword', $("#keyword").val());
        var baseUrl = "{{ url('/') }}";
        var urlLike2 = baseUrl + '/openai/text';
        $.ajax({
            type: "post",
            url: urlLike2,
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            contentType: false,
            processData: false,
            success: function(data) {
                console.log(data.status);
                if (data.status == false) {
                    $('.service_btn').text(data.msg);
                } else if (data) {
                    console.log(data.html);
                    z = data.code;
                    $(".generator_sidebar_table").html(data.html);

                } else {
                    $('.service_btn').text('Generate');
                    toastr.error('Your words limit has been exceeded.');
                }
            },
            error: function(data) {
                // toastr.error('Error' + data.responseText);
                console.log(data);
                $('.service_btnn').prop("disabled", false);
                $('.service_btn').text('Generate');
            }
        });
    });

    function generatorFormImage(ev) {
        'use strict';
        ev?.preventDefault();
        ev?.stopPropagation();
        $('.generate-btn-text').text('Please Wait...');
        $('.generate-btn-text').prop("disabled", true);
        document.getElementById("image-generator").disabled = true;
        document.getElementById("image-generator").innerHTML = "Please Wait...";
        document.querySelector('#app-loading-indicator')?.classList?.remove('opacity-0');
        var formData = new FormData();
        formData.append('image_number_of_images', $("#image_number_of_images").val());
        formData.append('description', $("#description").val());
        formData.append('size', $("#size").val());
        var baseUrl = "{{ url('/') }}";
        var urlLike = baseUrl + '/admin/openai/image';
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            },
            type: "post",
            url: urlLike,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                console.log('img', data);
                if (data.status == false) {
                    //  alert(data.msg);
                    $('.generate-btn-text').text(data.msg);
                    // $('.service_btn').prop("disabled", true);
                } else if (data.status == 'True') {
                    setTimeout(function() {
                        $(".image-output").html(data.response);
                        document.getElementById("image-generator").disabled = false;
                        document.getElementById("image-generator").innerHTML = "Regenerate";
                        document.querySelector('#app-loading-indicator')?.classList?.add(
                            'opacity-0');
                        $('.generate-btn-text').text('Generate');
                    }, 750);
                } else {
                    $('.generate-btn-text').text('Generate');
                    // toastr.error('Your image limit has been exceeded.');
                }
            },
        });
        return false;
    }
</script>
<script>
    function copyText() {
        var copyText = document.getElementById("myInput");
        var range = document.createRange();
        range.selectNode(copyText);
        window.getSelection().removeAllRanges();
        window.getSelection().addRange(range);
        document.execCommand("copy");
        window.getSelection().removeAllRanges();
        alert("Text copied to clipboard!");
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.flash-message .close').forEach(function(button) {
            button.addEventListener('click', function() {
                this.parentElement.style.display = 'none';
            });
        });
    });
</script>
<!-- Ai Script js end -->

</body>

</html>
