@extends('layouts.front.main')
@section('title', __('frontWords.search'))
@section('search')
{{ $search }}
@endsection
@section('content')

<div class="ms_top_artist">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="ms_heading">
                    <h1>{{ __('frontWords.search') }}</h1>
                </div>
            </div>
            @php
                if(sizeof($radios) > 0){
                    foreach($radios as $radio){
                        $artist_name = get_artist_name(['radio_id'=>$radio->id]);
            @endphp
            <div class="col-lg-2 col-md-6">
                <div class="ms_rcnt_box marger_bottom30">
                    <div class="ms_rcnt_box_img">
                        @if($radio->image != '' && file_exists(public_path('images/radio/'.$radio->image)))
                            <img src="{{ asset('images/radio/'.$radio->image) }}" alt="{{$radio->radio_name}}" class="img-fluid">
                        @else
                            <img src="{{ dummyImage('radio') }}" alt="{{$radio->radio_name}}" class="img-fluid">
                        @endif                        
                        <div class="ms_main_overlay">
                            <div class="ms_box_overlay"></div>
                            <div class="ms_more_icon">
                                <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('More Image')}}">
                            </div>
                            <ul class="more_option">
                                <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $radio->id }}" data-type="radio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $radio->id }}" data-musictype="radio" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('images/radio/'.$radio->image) }}" data-sharename="{{ $radio->radio_name }} " title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                            </ul>
                            <div class="ms_play_icon play_btn play_music" data-musicid="{{ $radio->id }}" data-musictype="radio" data-url="{{ url('/songs') }}">
                                <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('Play Image')}}">
                            </div>
                        </div>
                    </div>
                    <div class="ms_rcnt_box_text">
                        <h3><a href="{{ url('radio/single/'.$radio->id.'/'.$radio->radio_slug) }}" title="{{ $radio->radio_name }}">{{ $radio->radio_name }}</a></h3>
                    </div>
                </div>
            </div>
            @php
                }
                    }else{
                        echo '<div class="col-lg-12"><div class="ms_empty_data">
                        <p>'.__("frontWords.no_radio").'</p>
                    </div></div>';
                    }
            @endphp
        </div>
    </div>
</div>


    <div class="ms_top_artist">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.album') }}</h1>
                    </div>
                </div>
                @php
                    if(sizeof($albums) > 0){
                        foreach($albums as $album){
                           $artist_name = get_artist_name(['album_id'=>$album->id]);
                            $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
                @endphp
                                <div class="col-lg-2 col-md-6">
                                    <div class="ms_rcnt_box marger_bottom30">
                                        <div class="ms_rcnt_box_img">
                                            @if($album->image != '' && file_exists(public_path('images/album/'.$album->image)))
                                                <img src="{{ asset('images/album/'.$album->image) }}" alt="{{$album->album_name}}" class="img-fluid">
                                            @else
                                                <img src="{{ dummyImage('album') }}" alt="{{$album->album_name}}" class="img-fluid">
                                            @endif                                            
                                            <div class="ms_main_overlay">
                                                <div class="ms_box_overlay"></div>
                                                <div class="ms_more_icon">
                                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('More Image')}}">
                                                </div>
                                                <ul class="more_option">
                                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $album->id }}" data-type="album" title="{{ __('frontWords.favourites') }}"
                                                        ><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $album->id }}" data-musictype="album"><span class="opt_icon" title="{{ __('frontWords.add_to_queue') }}"
                                                        ><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('images/album/'.$album->image) }}" data-sharename="{{ $album->album_name }} " title="{{ __('frontWords.share') }}"
                                                        ><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                                </ul>
                                                <div class="ms_play_icon play_btn play_music" data-musicid="{{ $album->id }}" data-musictype="album" data-url="{{ url('/songs') }}">
                                                    <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('Play Image')}}">
                                                </div>
                                            </div>
                                            
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3><a href="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" title="{{ $album->album_name }}">{{ $album->album_name }}</a></h3>
                                            <p>{{ ($artist_name != '' ? rtrim($artist_name,', ') : 'Unknown') }}</p>
                                        </div>
                                    </div>
                                </div>
                @php
                    }
                        }else{
                            echo '<div class="col-lg-12"><div class="ms_empty_data">
                            <p>'.__('frontWords.no_album_with_title').' "'.$search.'"</p>
                        </div></div>';
                        }
                @endphp
            </div>
        </div>
    </div>

    <div class="ms_top_artist">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.track') }}</h1>
                    </div>
                </div>
                @php
                    if(sizeof($audios) > 0){
                        foreach($audios as $audio){
                            $getArtist = json_decode($audio->artist_id);
                            $artist_name = '';
                            foreach($getArtist as $artistName){
                                $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                                if(count($artists) > 0){
                                    $artist_name .= $artists[0]->artist_name.', ';
                                }
                            }
                @endphp
                                <div class="col-lg-2 col-md-6">
                                    <div class="ms_rcnt_box marger_bottom30">
                                        <div class="ms_rcnt_box_img">
                                            @if($audio->image != '' && file_exists(public_path('images/audio/thumb/'.$audio->image)))
                                                <img src="{{ asset('images/audio/thumb/'.$audio->image) }}" alt="{{$audio->audio_title}}" class="img-fluid">
                                            @else
                                                <img src="{{ dummyImage('audio') }}" alt="{{$audio->audio_title}}" class="img-fluid">
                                            @endif
                                            
                                            <div class="ms_main_overlay">
                                                <div class="ms_box_overlay"></div>
                                                <div class="ms_more_icon">
                                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('More Image')}}">
                                                </div>
                                                <ul class="more_option">
                                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audio->id }}" data-type="audio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audio->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>

                                                    @php
                                                        if(!empty($userPlan) && $userPlan->is_download == 1){
                                                    @endphp
                                                        <li><a href="javascript:;" class="download_track" data-musicid="{{ $audio->id }}" title="{{ __('frontWords.download_now') }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>{{ __('frontWords.download_now') }}</a></li>
                                                    @php } @endphp

                                                    <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audio->id }}" title="{{ __('frontWords.add_to_playlist') }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>  

                                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('images/audio/thumb/'.$audio->image) }}" data-sharename="{{ $audio->audio_title }} "  title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                                </ul>
                                                <div class="ms_play_icon play_btn play_music" data-musicid="{{ $audio->id }}" data-musictype="audio" data-url="{{ url('/songs') }}">
                                                    <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('Play Image')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3><a href="{{ url('audio/single/'.$audio->id.'/'.$audio->audio_slug) }}" title="{{ $audio->audio_title }}">{{ $audio->audio_title }}</a></h3>
                                            <p>{{ ($artist_name != '' ? rtrim($artist_name,', ') : 'Unknown') }}</p>
                                        </div>
                                    </div>
                                </div>
                @php
                    }
                        }else{
                            echo '<div class="col-lg-12"><div class="ms_empty_data">
                            <p>'.__('frontWords.no_album_with_title').' "'.$search.'"</p>
                        </div></div>';
                        }
                @endphp
            </div>
        </div>
    </div>

    <div class="ms_top_artist">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.artist') }}</h1>
                    </div>
                </div>
                @php
                    if(sizeof($artistData) > 0){
                        foreach($artistData as $artist){
                @endphp
                    <div class="col-lg-2 col-md-6">
                        <div class="ms_rcnt_box marger_bottom30">
                            <div class="ms_rcnt_box_img">
                                @if($artist->image != '' && file_exists(public_path('images/artist/'.$artist->image)))
                                    <img src="{{ asset('images/artist/'.$artist->image) }}" alt="{{$artist->artist_name}}" class="img-fluid">
                                @else
                                    <img src="{{ dummyImage('artist') }}" alt="{{$artist->artist_name}}" class="img-fluid">
                                @endif                                
                                <div class="ms_main_overlay">
                                    <div class="ms_box_overlay"></div>
                                    <div class="ms_more_icon">
                                        <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('More Image')}}">
                                    </div>
                                    <ul class="more_option">
                                        <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $artist->id }}" data-type="artist" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                        <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $artist->id }}" data-musictype="artist" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                        <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('images/artist'.$artist->image) }}" data-sharename="{{ $artist->artist_name }} " title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                    </ul>
                                    <div class="ms_play_icon play_btn play_music" data-musicid="{{ $artist->id }}" data-musictype="artist" data-url="{{ url('/songs') }}">
                                        <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('Play Image')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="ms_rcnt_box_text">
                                <h3><a href="{{ url('artist/single/'.$artist->id.'/'.$artist->artist_slug) }}" title="{{ $artist->artist_name }}">{{ $artist->artist_name }}</a></h3>
                            </div>
                        </div>
                    </div>
                @php
                    }
                        }else{
                            echo '<div class="col-lg-12"><div class="ms_empty_data">
                            <p>'.__('frontWords.no_artist_with_title').' "'.$search.'".</p>
                        </div></div>';
                        }
                @endphp
            </div>
        </div>
    </div>
@endsection
