@extends('layouts.front.main')
@section('title', __('frontWords.profile'))
@section('content')

@php
    if(!empty($user)){
@endphp
<div class="ms_profile_wrapper">
    <h1>{{ __('frontWords.edit_profile') }}</h1>
    <div class="ms_profile_box ms_profile_page_dv">
        <form action="{{url('update_profile')}}" method="post" id="updateUserForm" enctype="multipart/form-data">
            <div class="ms_pro_img">
                <img src="{{ ($user->image != '' ? asset('images/user/'.$user->image) : asset('assets/images/users/profile.svg')) }}" alt="{{$user->user_name}}" id="showUserImage" class="img-fluid">
                <label class="pro_img_overlay">
        <input class="form-control" 
           name="user_image" 
           data-dimension="500x500" 
           data-ext="['jpg','jpeg','png']"  
           data-image="Image can not be blank." 
           type="file" 
           id="basicImage"
           placeholder="{{ __('Upload Image') }}">
           <i class="fa_icon edit_icon"></i>
         </label>

        </div>
            <div class="ms_pro_form">
                <div class="form-group">
                    <label>{{ __('adminWords.name') }}*</label>
                    <input type="text" placeholder="{{ __('adminWords.enter').' '.__('adminWords.name') }}" id="user_name" name="user_name" class="form-control" value="{{ $user->name }}">
                </div>
                <div class="form-group">
                    <label>{{ __('adminWords.email') }} *</label>
                    <input type="text" placeholder="{{ __('adminWords.enter').' '.__('adminWords.email') }}" id="user_email" class="form-control" value="{{ $user->email }}">
                </div>
                <div class="form-group text-center">
                    <a href="javascript:;" id="change_pass" class="ms_btn" title="{{ __('adminWords.change_pass') }}">{{ __('adminWords.change_pass') }}</a>
                </div>
                <div class="change_password_slide hide ">
                    <div class="form-group">
                        <label>{{ __('adminWords.new_pass') }} *</label>
                        <input type="password" placeholder="{{ __('******') }}" class="form-control" id="userPassword" name="user_password" length="6" data-length-error="{{ __('frontWords.pass_length') }}">
                    </div>
                    <div class="form-group">
                        <label>{{ __('adminWords.confirm_password') }} *</label>
                        <input type="password" placeholder="{{ __('******') }}" class="form-control" id="confirmPassword" name="confirm_password" data-match="userPassword" data-error="{{ __('adminWords.cnf_not_match') }}">
                    </div>
                </div>
                <p>{{ __('frontWords.bill_to') }}</p>
                <div class="form-group">
                    <label>{{ __('frontWords.bill_name') }}*</label>
                    <input type="text" placeholder="{{ __('adminWords.enter').' '.__('frontWords.bill_name') }}" name="billing_name" name="billing_name" class="form-control" value="">
                </div>
                <div class="form-group">
                    <label>{{ __('frontWords.bill_email') }} *</label>
                    <input type="text" placeholder="{{ __('adminWords.enter').' '.__('frontWords.bill_email') }}" name="billing_email" class="form-control" data-valid="email" data-error="{{ __('adminWords.invalid').' '.__('adminWords.email') }}">
                </div>
                <div class="form-group">
                    <label>{{ __('frontWords.bill_contact') }} *</label>
                    <input type="text" placeholder="{{ __('adminWords.enter').' '.__('frontWords.bill_contact') }}" name="billing_contact" class="form-control" data-valid="mobile" data-error="{{ __('adminWords.invalid').' '.__('adminWords.contact_number') }}">
                </div>
                <div class="form-group">
                    <label>{{ __('frontWords.bill_address') }} *</label>
                    <textarea placeholder="{{ __('adminWords.enter').' '.__('frontWords.bill_address') }}" name="billing_address" class="form-control"></textarea>
                </div>
                <div class="pro-form-btn text-center marger_top15">
                    <button type="button" class="ms_btn" data-action="submitThisForm" title="{{ __('adminWords.save') }}">{{ __('adminWords.save') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@php
    }
@endphp
@endsection 
