@extends('layouts.front.main')
@section('title', __('frontWords.pricing_plan'))
@section('style')
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('content')

    <div class="ms_account_wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h2>{{ __('frontWords.manage_acc') }}</h2>
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.pricing_plan') }}</h1>
                    </div>
                </div>
                @php
                    if(sizeof($plans) > 0){
                        foreach($plans as $plan){
                            if($plan->plan_amount != 0){
                @endphp
                <div class="col-lg-4">
                    <div class="ms_plan_box purchasingPlan">
                        <div class="ms_plan_header">
                            <div class="ms_plan_img">
                                @if($plan->image != '' && file_exists(public_path('images/plan/'.$plan->image)))
                                    <img src="{{ asset('images/plan/'.$plan->image) }}" alt="{{$plan->plan_name}}">
                                @else
                                    <img src="{{ dummyImage('plan') }}" alt="{{$plan->plan_name}}" class="img-fluid">
                                @endif
                            </div>
                        </div>

                        
                        <h3 class="plan_heading">{{ $plan->plan_name }}</h3>
                        <div class="plan_price">
                        <div class="plan_dolar">
                            <sup>{{ session()->get('currency')['symbol'] }}</sup> {{ $plan->plan_amount*$rate }}</div>
                        </div>
                        <ul>
                        <li>{{ __('adminWords.validity') }} - {{ $plan->validity.($plan->is_month_days == 1 ? ' Months' : ' Days')}}</li>
                        <li>{{ __('adminWords.is_download') }} - {{ ($plan->is_download == 1 ? 'Yes' : 'No') }}</li>
                        <li>{{ __('adminWords.show_adv') }} - {{ ($plan->show_advertisement == 1 ? 'Yes' : 'No') }}</li>
                        </ul>
                        
                        <div class="ms_plan_btn">
                            <a href="{{ url('payment-single/'.Crypt::encrypt($plan->id)) }}" target="_blank" class="ms_btn" title="{{ __('frontWords.buy_now') }}">{{ __('frontWords.buy_now') }}</a>
                        </div>
                        
                    </div>
                </div> 
                @php
                            }
                        }
                    }
                @endphp
            </div>
        </div> 
    </div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
@endsection
