@extends('layouts.front.main')
@section('title', __('frontWords.playlist'))
@section('content')
@php 
if(!isset(Auth::user()->id)){ @endphp
    <div class="ms_content_wrapper">
        <article id="post-31">
            <div class="ms_entry_content">   
                <div class="fw-page-builder-content">
                    <section class="fw-main-row ">
                        <div class="fw-container-fluid">
                            <div class="fw-row">
                                <div class="fw-col-xs-12">
                                    <div class="ms_needlogin">
                                        <div class="needlogin_img">
                                            <img src="{{ asset('assets/images/svg/headphones.svg') }}" alt="{{ __('Image')}}">
                                        </div>
                                        <h2>{{ __('frontWords.need_to_login') }}</h2>
                                        
                                        <a href="javascript:;" 
                                         class="ms_btn reg_btn" 
                                         data-toggle="modal" 
                                          data-target="#registerModal"
                                          title="{{ __('frontWords.register_login_title') }}">
                                         <span>{{ __('frontWords.register_login') }}</span>
                                        </a>

                                    </div>
                                </div>
                            </div>
                            <div class="fw-row">
                                <div class="fw-col-xs-12">
                                <div class="fw-divider-space padder_top80"></div>
                            </div>
                        </div>
                    </div>
                </section>
           		 </div>
            </div>
        </article>
    </div>
@php }
else{ @endphp
    <div class="ms_top_artist">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.your_playlist') }}</h1>
                    </div>
                </div>
                @php 
                    if(sizeof($playlist) > 0){
                        foreach($playlist as $list){ 
                            $img = asset('assets/images/playlist.jpg');
                            if(!empty($list->song_list) && $list->song_list != ''){
                                $songs = json_decode($list->song_list);
                                if(!empty($songs)){
                                    $img = audioDetail(['songid'=>$songs[0], 'image' => 1]);
                                }
                            }
                @endphp
                    <div class="col-lg-2 col-md-6">
                        <div class="ms_rcnt_box marger_bottom25">
                            <div class="ms_rcnt_box_img playlist-img">
                                <img src="{{ empty($img) || $img == '[]' ? asset('assets/images/playlist.jpg') : $img }}" alt="{{ __('Playlist Image') }}" class="img-fluid album-img">
                                <div class="ms_main_overlay">
                                    <div class="ms_box_overlay"></div>
                                    <div class="ms_more_icon">
                                        <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('More') }}">
                                    </div>
                                    <ul class="more_option open_option remove_playlist">
                                        <li><a href="javascript:;" class="ms_remove_user_playlist" data-list-id="{{ $list->id }}" title="{{ __('frontWords.remove_playlist') }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span> __('frontWords.remove_playlist') </a></li>
                                    </ul>
                                    <div class="ms_play_icon play_btn play_list_music play_icon_btn" data-musicid="{{$list->id }}">
                                        <img src="{{ asset('assets/images/svg/play.svg' ) }}" alt="{{ __('Play Image')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="ms_rcnt_box_text">
                                <h3><a href="{{ url('playlist/single/'.$list->id)}}" title="{{ $list->playlist_name}}"> {{ $list->playlist_name }}</a></h3>
                                <p>{{ !empty($list->song_list) ? count(json_decode($list->song_list)) : 0 }} {{ __('frontWords.track') }}</p>
                            </div>
                        </div>
                    </div>
                @php    }
                    }
                @endphp
                <div class="col-lg-2">
                    <div class="ms_rcnt_box marger_bottom25">
                        <div class="create_playlist">
                            <i class="ms_icon icon_playlist"></i>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="javascript:;" title="{{ __(' frontWords.create_playlist') }}">{{ __('frontWords.create_playlist') }}</a></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@php } @endphp
            
@endsection
