@extends('layouts.front.main')
@section('title', __('frontWords.playlist_single'))
@section('content')
<div class="fw-col-xs-12">
	<div class="ms_free_download ms_purchase_wrapper">
        <div class="ms_heading">
            <h1>{{ (!empty($getPlaylist) && $getPlaylist[0]->playlist_name != '' ? $getPlaylist[0]->playlist_name : '') }}</h1>
        </div>
        <div class="album_inner_list">
            <div class="album_list_wrapper">
                <ul class="album_list_name">
                    <li>#</li>
                    <li>{{ __('frontWords.track_title') }}</li>
                    <li>{{ __('frontWords.artist') }}</li>
                    <li class="text-center">{{ __('frontWords.duration') }}</li>
                    <li class="text-center">{{ __('frontWords.more') }}</li>
                    <li class="text-center">{{ __('frontWords.remove') }}</li>
                </ul>
                @php 
                    if(!empty($getPlaylist)){
                        $getSongId = json_decode($getPlaylist[0]->song_list);
                        if(!empty($getSongId)){
                            $audioArr = [];
                            $cnt=0;
                            foreach($getSongId as $songid){
                                $cnt++;
                                $getAudio = audioDetail(['songid' => $songid]);
                                if(!empty($getAudio)){
                                    foreach($getAudio as $audio){
                                        $getArtist = json_decode($audio->artist_id);
                                        $artist_name = '';
                                        foreach($getArtist as $artistName){
                                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                                            if(count($artists) > 0){
                                                $artist_name .= $artists[0]->artist_name.',';
                                            }
                                        }
                                        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audio->id]);
                                        
                        @endphp
                        <ul class="ms_list_songs">
                            <li><span class="play_no">{{ $cnt }}</span><span class="play_hover play_music" data-musicid="{{ $audio->id }}" data-musictype="audio" data-url="{{ url('/songs') }}"></span></li>
                            <li><a href="{{ url('audio/single/'.$audio->id.'/'.$audio->audio_slug) }}" title="{{ $audio->audio_title }}">{{ $audio->audio_title }}</a></li>
                            <li>{{ rtrim($artist_name,',') }}</li>
                            <li class="text-center">{{ $audio->audio_duration }}</li>
                            <li class="text-center ms_more_icon"><a href="javascript:;"><span class="ms_icon1 ms_active_icon"></span></a>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audio->id }}" data-type="audio" title="{{ __(' frontWords.favourites') }}"
                                        ><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audio->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"
                                        ><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                    @php
                                        if(!empty($userPlan) && $userPlan->is_download == 1){
                                            if($audio->aws_upload == 1){
                                                echo  '<li><a href="'.getSongAWSUrlHtml($audio).'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                                            }else{
                                                echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$audio->id.'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                                            }
                                        }
                                    @endphp
                                    <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audio->id }}" title="{{ __(' frontWords.add_to_playlist') }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('images/audio/'.$audio->audio) }}" data-sharename="{{ $audio->title }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                </ul>
                            </li>
                            <li class="text-center">
                                <a href="javascript:;" 
                                  class="remove_user_playlist_music" 
                                  musicid="{{ $audio->id }}" 
                                  data-list-id="{{ (!empty($getPlaylist) ? $getPlaylist[0]->id : '') }}"
                                  title="{{ __('frontWords.remove_music_from_playlist') }}">
                                </a>

                                    <span class="ms_close">
                                        <img src="{{ asset('assets/images/svg/close.svg') }}" alt="{{ __('Close') }}">
                                    </span>
                            </li>
                        </ul>
                    @php
                    }
                        }
                            }
                                }
                                    }
                    @endphp
               
            </div>
        </div>
    </div>
</div>

@endsection
