@extends('layouts.front.main')
@section('title', __('frontWords.history'))
@section('content')
@php
    if(isset(Auth::user()->id)){
@endphp
<div class="ms_top_artist">
        <div class="container-fluid">
            @php if(sizeof($audios) > 0){ @endphp
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ms_heading">
                            <h1>{{ __('frontWords.history') }}</h1>
                        </div>
                    </div>
                    @php
                        $cnt = 0;
                        foreach($audios as $audio_id){
                            if($cnt <= 24){
                                $audioDetail = select(['column' => '*', 'table' => 'audio', 'where' => ['id'=> $audio_id] ]);
                                if(sizeof($audioDetail) > 0){
                                    $cnt = 0;
                                    foreach($audioDetail as $audio){
                                        $getArtist = json_decode($audio->artist_id);
                                        $artist_name = '';
                                        foreach($getArtist as $artistid){
                                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistid] ]);
                                            if(count($artists) > 0){
                                                $artist_name .= $artists[0]->artist_name.', ';
                                            }
                                        }
                                        
                                    @endphp
                                        <div class="col-lg-2 col-md-6">
                                            <div class="ms_rcnt_box marger_bottom30">
                                                <div class="ms_rcnt_box_img">
                                                    @if($audio->image != '' && file_exists(public_path('images/audio/thumb/'.$audio->image)))
                                                        <img src="{{ asset('images/audio/thumb/'.$audio->image) }}" alt="{{$audio->audio_title}}" class="img-fluid">
                                                    @else
                                                        <img src="{{ dummyImage('audio') }}" alt="{{$audio->audio_title}}" class="img-fluid">
                                                    @endif
                                                    <div class="ms_main_overlay">
                                                        <div class="ms_box_overlay"></div>
                                                        <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $audio->id }}" data-musictype="audio" data-url="{{ url('/songs') }}">
                                                            <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('Play Image')}}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="ms_rcnt_box_text">
                                                    <h3><a href="{{ url('audio/single/'.$audio->id.'/'.$audio->audio_slug) }}" title="{{ $audio->audio_title }}">{{ $audio->audio_title }}</a></h3>
                                                    <p>{{ rtrim($artist_name,', ') }}</p>
                                                </div>
                                            </div>
                                        </div> 
                                    @php
                                    }
                                }
                            }
                            $cnt++;
                        }
                    @endphp
                </div>
            @php
                }else{
                    echo '<div class="col-lg-12">
                            <div class="ms_heading">
                                <h1>'.__("frontWords.history").'</h1>
                            </div>
                        </div>
                        <div class="ms_empty_data">
                            <p>'.__("frontWords.no_track").'</p>
                        </div>';
                } 
            @endphp
        </div>
    </div>
</div>
@php
    }else{
        echo ' <div class="ms_content_wrapper">
                    <article id="post-31">
                        <div class="ms_entry_content">   
                            <div class="fw-page-builder-content">
                                <section class="fw-main-row ">
                                    <div class="fw-container-fluid">
                                        <div class="fw-row">
                                            <div class="fw-col-xs-12">
                                              <div class="ms_needlogin">
                                              <div class="needlogin_img">
                                              <img src="'.asset('assets/images/svg/headphones.svg').'">
                                             </div>
                                              <h2>Need_to_login</h2>
                                             <a href="javascript:;" 
                                              class="ms_btn reg_btn" 
                                             data-toggle="modal" 
                                             data-target="#registerModal">
                                             <span>Register_login</span>
                                             </a>
                                            </div>

                                            </div>
                                        </div>
                                        <div class="fw-row">
                                            <div class="fw-col-xs-12">
                                            <div class="fw-divider-space padder_top80"></div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </article>
                </div>';
        }
@endphp
@endsection
