@extends('layouts.front.main')
@section('title', __('adminWords.genre'))
@section('content')
<div class="ms_genres_wrapper ms_genres_single padder_top90">
    <div class="row">
        <div class="col-lg-12">
            <div class="ms_heading">
                <h1>{{ __('frontWords.top_genre') }}</h1>
            </div>
            @php
                if(sizeof($genres) > 0){
                    $html = '';
                    foreach($genres as $genre) {
                        if($genre->image != '' && file_exists(public_path('images/audio/audio_genre/'.$genre->image))){
                            $img = '<img src="'.asset('images/audio/audio_genre/'.$genre->image).'" alt="{{$genres[0]->genre_name}}" class="img-fluid">';
                        }else{
                            $img = '<img src="'.dummyImage('genre').'" alt="{{$genres[0]->genre_name}}" class="img-fluid">';
                        }
                        $html .= '<div class="grid-item">
                                    <div class="ms_genres_box">
                                        '.$img.'
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            
                                            <div class="ovrly_text_div">
                                                <span class="ovrly_text1"><a href="javascript:;">'.$genre->genre_name.'</a></span>
                                                <span class="ovrly_text2"><a href="'.url('genre/single/'.$genre->id.'/'.$genre->genre_slug).'">'.__("frontWords.view_song").'</a></span>
                                            </div>
                                        </div>
                                        <div class="ms_box_overlay_on">
                                            <div class="ovrly_text_div">
                                                <span class="ovrly_text1"><a href="#">'.$genre->genre_name.'</a></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
                    }
                    echo '<div class="grid" data-gutter="15"><div class="grid-sizer"></div>'.$html.'</div></div>';
                }else{
                    echo '<div class="ms_empty_data">
                            <p>'.__("frontWords.no_genre").'</p>
                        </div>';
                }
            @endphp
        
    </div>
</div>
@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.6/isotope.pkgd.min.js"></script>
@endsection
