@extends('layouts.front.main')
@section('title', __('frontWords.genre_single'))
@section('content')

<div class="ms_album_single_wrapper ms_artist_single">
    <div class="album_single_data">
        @php
            if(sizeof($genres) > 0){
        @endphp
            <div class="album_single_img">
                @if($genres[0]->image != '' && file_exists(public_path('images/audio/audio_genre/'.$genres[0]->image)))
                    <img src="{{ asset('images/audio/audio_genre/'.$genres[0]->image) }}" alt="{{$genres[0]->genre_name}}" class="img-fluid">
                @else
                    <img src="{{ dummyImage('genres') }}" alt="{{$genres[0]->genre_name}}" class="img-fluid">
                @endif
                
            </div>
            <div class="album_single_text">
                <p class="singer_name">{{ $genres[0]->genre_name }}</p>
                <div class="album_feature">
                    <a href="#" class="album_date" title="{{ __('frontWords.created_at') }}">{{ __('frontWords.created_at') }} - {{ date("F d, Y", strtotime($genres[0]->created_at)) }}</a>
                </div>
                <div class="album_btn">
                    <a href="#" class="ms_btn play_btn play_music" data-musicid="{{ $genres[0]->id }}"  title="{{ __(' frontWords.play_all') }}" data-musictype="genre" data-url="{{ url('/songs') }}"><span class="play_all"><img src="{{ asset('assets/images/svg/play_all.svg') }}" alt="{{ __('Play Image')}}">{{ __('frontWords.play_all') }}</span><span class="pause_all"><img src="{{ asset('assets/images/svg/pause_all.svg') }}" alt="{{ __('Pause Image')}}">{{ __('frontWords.pause') }}</span></a>
                    <a href="javascript:;" class="ms_btn add_to_queue" data-musicid="{{ $genres[0]->id }}"  title="{{ __(' frontWords.add_to_queue') }}" data-musictype="genre"><span class="play_all"><img src="{{ asset('assets/images/svg/add_q.svg') }}" alt="{{ __('Queue Image')}}">{{ __('frontWords.add_to_queue') }}</span></a>
                </div>
            </div>
        @php
            }   
        @endphp    
    </div>
</div>

<div class="col-lg-12">
	<div class="ms_free_download ms_purchase_wrapper">
        <div class="ms_heading">
            <h1>{{ (sizeof($genres) > 0 && $genres[0]->genre_name != '' ? $genres[0]->genre_name : '') }}</h1>
        </div>

        <div class="album_inner_list">
            <div class="album_list_wrapper">
                <ul class="album_list_name">
                    <li>#</li>
                    <li>{{ __('frontWords.track_title') }}</li>
                    <li>{{ __('frontWords.artist') }}</li>
                    <li class="text-center">{{ __('frontWords.duration') }}</li>
                    <li class="text-center">{{ __('frontWords.more') }}</li>
                </ul>
            @php
                if(sizeof($audioData) > 0){
                    $idArr = [];
                    $cnt = 0;
                    foreach($audioData as $audio){  
                        $cnt++;
                        $getAudioDetail = select(['column' => '*', 'table' => 'audio', 'where' => ['id'=>$audio->id] ]);
                        if(!empty($getAudioDetail)){
                            foreach($getAudioDetail as $audios){ 
                                $getArtist = json_decode($audios->artist_id);
                                $artist_name = '';
                                foreach($getArtist as $artistid){
                                    $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistid] ]);
                                    if(count($artists) > 0){
                                        $artist_name .= $artists[0]->artist_name.', ';
                                    }
                                }
                                $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audios->id]);
                            @endphp
                                <ul>
                                    <li><span class="play_no">{{ $cnt }}</span><span class="play_hover play_music" data-musicid="{{ $audios->id }}" data-musictype="audio" data-url="{{ url('/songs') }}"></span></li>
                                    <li><a href="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}" title="{{$audios->audio_slug}}">{{ $audios->audio_title }}</a></li>
                                    <li>{{ rtrim($artist_name,', ') }}</li>
                                    <li class="text-center">{{ $audios->audio_duration }}</li>
                                    <li class="text-center ms_more_icon"><a href="javascript:;" title="{{ __('active icon') }}"><span class="ms_icon1 ms_active_icon"></span></a>
                                        <ul class="more_option">
                                            <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audios->id }}" data-type="audio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                            <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audios->id }}" data-musictype="audio" title="{{ __('frontWords.queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                            @php
                                                if(!empty($userPlan) && $userPlan->is_download == 1){
                                                    if($audios->aws_upload == 1){
                                                        echo  '<li><a href="'.getSongAWSUrlHtml($audios).'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                                                    }else{
                                                        echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$audios->id.'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                                                    }
                                                }
                                            @endphp
                                            <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audios->id }}"><span class="opt_icon" title="{{ __('frontWords.add_to_playlist') }}"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
                                            <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}" data-sharename="{{ $audios->audio_title }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                        </ul>
                                    </li>
                                </ul>
            @php
                                }
                            }
                        }
                    }
            @endphp
            </div>
        </div>
    </div>
</div>
</div>
@endsection 
