@extends('layouts.front.main')
@section('title', __('frontWords.favourites'))
@section('content')
<div class="ms_free_download ms_purchase_wrapper">
    <div class="album_inner_list">
        <div class="album_list_wrapper">
            <ul class="album_list_name">
                <li>#</li>
                <li>{{ __('frontWords.track_title') }}</li>
                <li>{{ __('frontWords.artist') }}</li>
                <li class="text-center">{{ __('frontWords.duration') }}</li>
                <li class="text-center">{{ __('frontWords.more') }}</li>
            </ul>
            @php 
                if(sizeof($favourites) > 0 && $favourites[0]->audio_id != ''){
                    $favourite = json_decode($favourites[0]->audio_id);
                    if(sizeof($favourite) > 0){
                        $cnt = 0;
                        foreach($favourite as $favourite_audio){
                            $audioDetail = audioDetail(['songid' => $favourite_audio]);
                            if(sizeof($audioDetail) > 0){
                                foreach($audioDetail as $audios){
                                    $cnt++;
                                    $getArtist = json_decode($audios->artist_id);
                                    if(sizeof($getArtist) > 0){
                                        $artist_name = '';
                                        foreach($getArtist as $artistName){
                                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                                            if(count($artists) > 0){
                                                $artist_name .= $artists[0]->artist_name.', ';
                                            }
                                        }
                                        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audios->id]);
            @endphp
            
            <ul> 
                <li><span class="play_no">{{ $cnt }}</span><span class="play_hover play_music" data-musicid="{{ $audios->id }}" data-musictype="audio" data-url="{{ url('/songs') }}"></span></li>
                <li><a href="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}" title="{{$audios->audio_slug}}">{{ $audios->audio_title }}</a></li>
                <li>{{ rtrim($artist_name,', ') }}</li>
                <li class="text-center">{{ $audios->audio_duration }}</li>
                <li class="text-center ms_more_icon"><a href="javascript:;"><span class="ms_icon1 ms_active_icon"></span></a>
                    <ul class="more_option">
                        <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audios->id }}"  data-type="audio" 
                    title="{{ __('frontWords.favourites') }}"
>                   <span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                        <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audios->id }}" data-musictype="audio" 
                        title="{{ __('frontWords.add_to_queue') }}">
                        <span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                        @php
                            if(!empty($userPlan) && $userPlan->is_download == 1){
                                if($audios->aws_upload == 1){
                                    echo  '<li><a href="'.getSongAWSUrlHtml($audios).'" title="{{ __("frontWords.download_now") }}">

                                <span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                                }else{
                                    echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$audios->id.'" title="{{ __("frontWords.download_now") }}">
                                        <span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                                }
                            }
                        @endphp
                        <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audios->id }}" title="{{ __('frontWords.add_to_playlist') }}">
                            <span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
                        <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}" data-sharename="{{ $audios->title }}" title="{{ __('frontWords.share') }}">
                            <span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                    </ul>
                </li>
            </ul>
            @php
                                }
                            }
                        }
                    }
                }
            }else{
                echo '<ul>
                    <li>'.__("frontWords.no_track").'</li>
                </ul>';
            }
            @endphp
        </div>
    </div>
</div>

<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{ __('frontWords.your_fav').' '.__('frontWords.album') }}</h1>
    </div>
    @php 
        if(sizeof($favourites) > 0 && $favourites[0]->album_id != ''){
    @endphp
    <div class="ms_relative_inner">
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                @php 
                    $favourite = json_decode($favourites[0]->album_id);
                    foreach($favourite as $fav_id){
                        $albumData = select(['column' => '*', 'table' => 'albums', 'where' => ['id'=>$fav_id] ]);
                        if(sizeof($albumData) > 0){
                            foreach($albumData as $album){
                                if($album->image != '' && file_exists(public_path('images/album/thumb/'.$album->image))){
                                    $img = '<img src="'.asset('images/album/thumb/'.$album->image).'" alt="{{$album->album_name}}" class="img-fluid album-img">';
                                }else{
                                    $img = '<img src="'.dummyImage('album').'" alt="{{$album->album_name}}" class="img-fluid album-img">';
                                }
                                echo '<div class="swiper-slide">
                                        <div class="ms_rcnt_box">
                                            <div class="ms_rcnt_box_img">
                                                '.$img.'
                                                <div class="ms_main_overlay">
                                                    <div class="ms_box_overlay"></div>
                                                    <div class="ms_more_icon">
                                                        <img src="'.asset('assets/images/svg/more.svg').'">
                                                    </div>
                                               
                                                 <ul class="more_option">
                                                   <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php echo album->id; ?>" data-musictype="album"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php echo __("frontWords.add_to_queue"); ?></a></li>
                                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('album/single/'.$album->id.'/'.$album->album_slug).'" data-sharename="'.$album->album_name.'"><span class="opt_icon"><span class="icon icon_share"></span></span>'.__("frontWords.share").'</a></li>
												</ul>

                                                    <div class="ms_play_icon play_btn play_icon_btn play_music" data-musicid="'.$album->id.'" data-musictype="album" data-url="'.url('/songs').'">
                                                        <img src="'.asset('assets/images/svg/play.svg').'">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="ms_rcnt_box_text">
                                                <h3><a href="'.url('album/single/'.$album->id.'/'.$album->album_slug).'" title="{{$album->album_name }}">'.$album->album_name.'</a></h3>
                                            </div>
                                        </div>
                                    </div>';
                            }
                        }
                    }
                @endphp
            </div>
        </div>
        
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
    </div>
    @php
        }else{
            echo '<div class="ms_empty_data">
                    <p>'.__("frontWords.no_featured_album").'</p>
                </div>';
        }
    @endphp
</div>

<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{ __('frontWords.your_fav').' '.__('frontWords.artist') }}</h1>
    </div>
    @php 
        if(sizeof($favourites) > 0 && $favourites[0]->artist_id != ''){
    @endphp
    <div class="ms_relative_inner">
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                @php 
                $favourite = json_decode($favourites[0]->artist_id);
                foreach($favourite as $fav_id){
                    $artistData = select(['column' => '*', 'table' => 'artists', 'where' => ['id'=>$fav_id] ]);
                    if(sizeof($artistData) > 0){
                        foreach($artistData as $artist){
                            if($artist->image != '' && file_exists(public_path('images/artist/'.$artist->image))){
                                $img = '<img src="'.asset('images/artist/'.$artist->image).'" alt="{{$artist->artist_name}}" class="img-fluid album-img">';
                            }else{
                                $img = '<img src="'.dummyImage('artist').'" alt="{{$artist->artist_name}}" class="img-fluid album-img">';
                            }
                            echo '<div class="swiper-slide">
                                    <div class="ms_rcnt_box">
                                        <div class="ms_rcnt_box_img">
                                            '.$img.'
                                            <div class="ms_main_overlay">
                                                <div class="ms_box_overlay"></div>
                                                <div class="ms_more_icon">
                                                    <img src="'.asset('assets/images/svg/more.svg').'">
                                                </div>
                                                <ul class="more_option">
                                                  <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php echo $artist->id; ?>" data-musictype="artist"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php echo __("frontWords.add_to_queue"); ?></a></li>
                                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('artist/single/'.$artist->id.'/'.$artist->artist_slug).'" data-sharename="'.$artist->artist_name.'"><span class="opt_icon"><span class="icon icon_share"></span></span>'.__("frontWords.share").'</a></li>
                                                </ul>
                                                <div class="ms_play_icon play_btn play_icon_btn play_music" data-musicid="'.$artist->id.'" data-musictype="artist" data-url="'.url('/songs').'">
                                                    <img src="'.asset('assets/images/svg/play.svg').'">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3><a href="'.url('artist/single/'.$artist->id.'/'.$artist->artist_slug).'" title="{{ $artist->artist_name}}">'.$artist->artist_name.'</a></h3>
                                        </div>
                                    </div>
                                </div>';
                        }
                    }
                }
                @endphp
            </div>
        </div>
        
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
    </div>
    @php
        }else{
            echo '<div class="ms_empty_data">
                    <p>'.__("frontWords.no_featured_artist").'</p>
                </div>';
        }
    @endphp
</div>

<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{ __("frontWords.recently_added") }}</h1>
    </div>
    @php 
        if(sizeof($recentlyAddedAudio) > 0){
    @endphp
    <div class="ms_relative_inner">
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                @php 
                    foreach($recentlyAddedAudio as $audio){
                        $getArtist = json_decode($audio->artist_id);
                        $artist_name = '';
                        foreach($getArtist as $artistid){
                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistid] ]);
                            if(count($artists) > 0){
                                $artist_name .= $artists[0]->artist_name.', ';
                            }
                        }
                        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audio->id]);
                        $download = '';
                        if(!empty($userPlan) && $userPlan->is_download == 1){
                            $download = '<li>'.($audio->aws_upload == 1 ? '<a href="'.getSongAWSUrlHtml($audio).'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a>' : '<a href="javascript:;" class="download_track" data-musicid="'.$audio->id.'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a>').'</li>';
                        }
                        if($audio->image != '' && file_exists(public_path('images/audio/thumb/'.$audio->image))){
                            $img = '<img src="'.url('images/audio/thumb/'.$audio->image).'" alt="{{$audio->audio_title}}" class="img-fluid album-img">';
                        }else{
                            $img = '<img src="'.dummyImage('audio').'" alt="{{$audio->audio_title}}" class="img-fluid album-img">';
                        }
                        echo '<div class="swiper-slide">
                                <div class="ms_rcnt_box">
                                    <div class="ms_rcnt_box_img">
                                        '.$img.'
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            <div class="ms_more_icon">
                                                <img src="'.asset('assets/images/svg/more.svg').'" >      
                                            </div>
                                            <ul class="more_option">
                                                <li><a href="javascript:;" class="addToFavourite" data-favourite="'.$audio->id.'" data-type="audio"><span class="opt_icon"><span class="icon '.($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav').'"></span></span>'.__('frontWords.favourites').'</a></li>
                                                <li><a href="javascript:;" class="add_to_queue" data-musicid="'.$audio->id.'" data-musictype="audio"><span class="opt_icon"><span class="icon icon_queue"></span></span>'.__('frontWords.add_to_queue').'</a></li>
                                                '.$download.'
                                                <li><a href="javascript:;" class="ms_add_playlist" data-musicid="'.$audio->id.'"><span class="opt_icon"><span class="icon icon_playlst"></span></span>'.__('frontWords.add_to_playlist').'</a></li>
                                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('audio/single/'.$audio->id.'/'.$audio->audio_slug).'" data-sharename="'.$audio->audio_title.'"><span class="opt_icon"><span class="icon icon_share"></span></span>'.__('frontWords.share').'</a></li>
                                            </ul>
                                            <div class="ms_play_icon play_btn play_icon_btn  play_music" data-musicid="'.$audio->id.'" data-musictype="audio" data-url="'.url('/songs').'">
                                                <img src="'.asset('assets/images/svg/play.svg').'">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ms_rcnt_box_text">
                                        <h3><a href="'.url('audio/single/'.$audio->id.'/'.$audio->audio_slug).'" title="{{ $audio->audio_title}}">'.$audio->audio_title.'</a></h3>
                                    </div>
                                </div>
                            </div>';
                        }
                    
                @endphp
            </div>
        </div>
        
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
    </div>
    @php
        }else{
            echo '<div class="ms_empty_data">
                    <p>'.__("frontWords.no_track").'</p>
                </div>';
        }
    @endphp
</div>


@endsection
