@extends('layouts.front.main')
@section('title', __('frontWords.faqs'))
@section('content')
<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{ __('frontWords.faqs') }}</h1>
    </div>
    @php
    if(sizeof($faqs) > 0){
    @endphp
    <div id="accordion">
        @php foreach($faqs as $faq){ @endphp
        <div class="card">
            <div class="card-header" id="heading{{$faq->id}}">
                <h5 class="mb-0">
                    <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse{{$faq->id}}"
                        aria-expanded="true" aria-controls="collapse{{$faq->id}}"
                        title="{{ __('frontWords.faq', ['question' => $faq->question]) }}">
                        {{ $faq->question }}
                    </button>
                </h5>

            </div>

            <div id="collapse{{$faq->id}}" class="collapse" aria-labelledby="heading{{$faq->id}}"
                data-parent="#accordion">
                <div class="card-body">
                    {{ $faq->answer }}
                </div>
            </div>
        </div>
        @php } @endphp
    </div>
    @php }else{
    echo '<div class="ms_empty_data">
        <p>'.__("frontWords.no_faq").'</p>
    </div>';
    } @endphp
</div>
</div>
@endsection
