@extends('layouts.front.main')
@section('title', __('frontWords.home'))
@section('style')
    <link href="{{ asset('assets/css/star-rating.css') }}" rel="stylesheet" type="text/css">
@endsection
<meta name="theme-color" content="#6777EF">
<link href="{{ asset('logo.png') }}" rel="apple-touch-icon">
<link href="{{ asset('/manifest.json') }}" rel="manifest">
@section('content')
    <div class="ms-banner">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="ms_dashboard_slider swiper-container">
                        <div class="swiper-wrapper">
                        <?php
                            if((isset($sliders)) && !empty($sliders)){
                                foreach ($sliders as $slider){
                                    if($slider->image != '' && file_exists(public_path('images/slider/'.$slider->image))){
                        ?>
                                <div class="swiper-slide">
                                    <div class="ms_rcnt_box">
                                        <div class="ms_rcnt_box_img">
                                            <img src="{{ asset('images/slider/'.$slider->image) }}" 
                                                 alt="{{ __('frontWords.slider_image_alt', ['image' => $slider->image]) }}" 
                                                 class="img-fluid">
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3>
                                                <a class="pointer" 
                                                   onclick="" 
                                                   title="{{ __('frontWords.slider_link_title', ['title' => $slider->title]) }}">
                                                    {{ $slider->title }}
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    
                                </div>
                        <?php
                                }
                            }
                        }
                        ?>
                        </div>
                        
                        <div class="swiper-button-next1 slider_nav_next"></div>
                        <div class="swiper-button-prev1 slider_nav_prev"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>                  

    
    <div class="ms_featured_slider">
        <div class="ms_heading">
            <h1>{{ __('frontWords.featured').' '.__('frontWords.artist') }}</h1>
        </div>
        @php 
            if(sizeof($featured_artist) > 0){
        @endphp
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                @php
                    foreach($featured_artist as $artists){
                        $getLikeDislikeArtist = getFavDataId(['column' => 'artist_id', 'artist_id' => $artists->id]);
                        
                @endphp
                            <div class="swiper-slide">
                                <div class="ms_rcnt_box">
                                    <div class="ms_rcnt_box_img">
                                        @if($artists->image != '' && file_exists(public_path('images/artist/'.$artists->image)))
                                            <img src="{{ asset('images/artist/'.$artists->image) }}" alt="{{ __('frontWords.artist_image_alt', ['artist' => $artists->artist_name]) }}" class="img-fluid">
                                        @else
                                            <img src="{{ dummyImage('artist') }}" alt="{{ __('frontWords.default_artist_image_alt') }}" class="img-fluid">
                                        @endif
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            <div class="ms_more_icon">
                                                <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('frontWords.more_icon_alt') }}">
                                            </div>
                                            <ul class="more_option">
                                                <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $artists->id }}" data-type="artist" title="{{ __('frontWords.add_to_favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeArtist == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                                <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $artists->id }}" data-musictype="artist" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to').' '.__('frontWords.queue') }}</a></li>
                                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('artist/single/'.$artists->id.'/'.$artists->artist_slug) }}" data-sharename="{{ $artists->artist_name }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                            </ul>
                                            <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $artists->id }}" data-musictype="artist" data-url="{{ url('/songs') }}">
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ms_rcnt_box_text">
                                        <h3><a href="{{ url('artist/single/'.$artists->id.'/'.$artists->artist_slug) }}"title="{{$artists->artist_name }}">{{ $artists->artist_name }}</a></h3>
                                    </div>
                                </div>
                            </div>
                @php   } @endphp
            </div>
        </div>
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        
        @php
            }else{ 
                echo '<div class="ms_empty_data">
                        <p>'.__("frontWords.no_artist").'</p>
                    </div>';
            }
        @endphp
    </div>

    <div class="ms_fea_album_slider">
        <div class="ms_heading">
            <h1>{{ __('frontWords.featured').' '.__('frontWords.album') }}</h1>
        </div>
        @php 
            if(sizeof($featured_album) > 0){
        @endphp
        <div class="ms_album_slider swiper-container">
            <div class="swiper-wrapper">
                @php 
                    foreach($featured_album as $album){
                        $artist_name = get_artist_name(['album_id'=>$album->id]);
                        $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
                @endphp
                <div class="swiper-slide">
                    <div class="ms_rcnt_box">
                        <div class="ms_rcnt_box_img">
                            @if($album->image != '' && file_exists(public_path('images/album/'.$album->image)))
                                <img src="{{ asset('images/album/'.$album->image) }}" alt="{{ __('frontWords.album_image_alt', ['album' => $album->album_name]) }}" class="img-fluid album-img">
                            @else
                                <img src="{{ dummyImage('album') }}" alt="{{ __('frontWords.default_album_image_alt') }}" class="img-fluid album-img">
                            @endif
                            
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('frontWords.more_icon_alt') }}">
                                </div>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $album->id }}"  data-type="album"title="{{ __('frontWords.add_to_favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAlbum == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $album->id }}" data-musictype="album"title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to').' '.__('frontWords.queue') }}</a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" data-sharename="{{ $album->album_name }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                </ul>
                                <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $album->id }}" data-musictype="album" data-url="{{ url('/songs') }}">
                                    
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" title="{{ $album->album_name}}">{{ $album->album_name }}</a></h3>
                            <p>{{ rtrim($artist_name,',') }}</p>
                        </div>
                    </div>
                </div>
                @php } @endphp 
            </div>
        </div>
        @php
            }else{
                echo '<div class="ms_empty_data">
                        <p>'.__("frontWords.no_album").'</p>
                    </div>';
            }
        @endphp
        
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
    </div>
   
    @if(sizeof($testimonials) > 0)
    
        <div class="ms_fea_album_slider ms_test_wrapper">
            <div class="ms_heading">
                <input type="hidden" id="testimonial_count" value="{{ sizeof($testimonials) }}">
                <h1>{{ __('frontWords.testimonial') }} ({{ sizeof($testimonials) }})</h1>
            </div>
            <div class="ms_testimonial_slider swiper-container">
                <div class="swiper-wrapper">
                    @php foreach($testimonials as $testimonial){ @endphp
                        <div class="swiper-slide">
                            <div class="ms_test_box">
                                <div class="ms_test_top">
                                    <div class="ms_test_img">
                                        @if($testimonial->image != '' && file_exists(public_path('images/testimonial/'.$testimonial->image)))
                                            <img src="{{ asset('images/testimonial/'.$testimonial->image) }}" alt="{{ __('frontWords.testimonial', ['name' => $testimonial->name]) }}" class="img-fluid">
                                        @else
                                            <img src="{{ dummyImage('testimonial') }}" alt="{{ __('frontWords.default_testimonial') }}" class="img-fluid">
                                        @endif
                                    </div>
                                    <div class="ms_test_name">
                                        <h3>{{ $testimonial->client_name }}</h3>
                                        <div class="ms_test_para">
                                            <p>{{ strtoupper($testimonial->designation) }}</p>
                                            <div class="rating{{ $testimonial->id}}" data-star="rating" data-rating="{{ $testimonial->rating }}"></div>  
                                        </div>                                                                             
                                        <p>{{ strip_tags($testimonial->detail) }}</p>
                                        <span class="cmnt_time">{{ $testimonial->created_at->diffForHumans(date('Y-m-d h:i:s')) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @php } @endphp
                </div>
            </div>
            
            <div class="swiper-button-next1 slider_nav_next"></div>
            <div class="swiper-button-prev1 slider_nav_prev"></div>
        </div>
    @endif

@endsection 

@section('script')
    <script src="{{ asset('assets/js/star-rating.js') }}"></script>
@endsection

