@extends('layouts.front.main')
@section('title', __('frontWords.blog_single'))
@inject('users', 'App\User')
@inject('reply', 'App\Reply')
@section('content')
<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{__('frontWords.blog_single')}}</h1>
    </div>
    
    @php
        if(sizeof($blog) > 0){
            $getUser = $users->find($blog[0]->user_id);
    @endphp
    <main id="main" class="site-main">
        <div class="ms_main_wrapper ms_main_wrapper_single">
		       <div class="container">
                   	<div class="row">
				        <div class="col-lg-12 col-md-12">
                            <div class="ms_main_data"> 
                                <article class="hentry">
                                    <div class="ms_single_page_image">
                                        <span class="ms_blog_date">{{ date('F d, Y', strtotime($blog[0]->created_at)) }}</span>
                                            <img src="{{ asset('images/blogs/'.$blog[0]->image) }}" alt="{{ $blog[0]->title }}">
                                    </div>
                                    <header class="entry-header">
                                        <div class="entry-meta">
                                            <span class="posted-on">
                                                <i class="fa fa-calendar" aria-hidden="true"></i>
                                                <a href="javascript:;" rel="bookmark" title="{{ __('frontWords.blog_date') }}">
                                                    <time class="entry-date published" datetime="{{ $blog[0]->created_at }}">{{ date('F d, Y', strtotime($blog[0]->created_at)) }}</time>
                                                </a>
                                            </span>
                                            <span class="byline">
                                                <span class="ms-separator"></span>
                                                <i class="fa fa-user" aria-hidden="true"></i> 
                                                <span class="author vcard">
                                                    <a class="url fn n" href="{{url('/')}}" title="{{ __('Blogs')}}">{{ (!empty($getUser) ? $getUser->name : __('adminWords.miraculous')) }}</a>
                                                </span>
                                            </span>
                                        </div>
                                    </header>
                                    <div class="entry-content">
                                        <p>{{ strip_tags(htmlspecialchars_decode($blog[0]->detail)) }}</p>
                                    </div>
                                    <footer class="entry-footer ms-entry-footer"></footer>
                                </article>
                                <div id="comments" class="comments-area">
                                <div class="ms_heading">
                                    <h1 class="comments-title">{{ __('frontWords.comment') }} ({{ sizeof($comments) }})</h1>
                                    
                                </div>
                                    
                                <ol class="comment-list">
                                    @php
                                    if(sizeof($comments) > 0){
                                        foreach($comments as $comment){
                                            $userInfo = $users->find($comment->id);   
                                            $getReply = $reply->where(['comment_id' => $comment->id, 'blog_id' => $blog[0]->id])->get();                                     
                                    @endphp
                                            <li class="comment">
                                                <div class="comment-body ms_comment_section">
                                                    <div class="comment-author comment_img">
                                                        <img alt="{{$userInfo->title}}" src="{{ !empty($userInfo) && $userInfo->image != '' ? $userInfo->image : asset('assets/images/users/profile.svg') }}" class="avatar avatar-80 photo" height="80" width="80">
                                                    </div>
                                                    <div class="comment_info">
                                                        <div class="comment_head">
                                                            <h3><cite class="fn">{{ !empty($userInfo) ? $userInfo->name : '' }}</cite> <span class="says">says:</span></h3>
                                                            <p><a href="javascript:;" title="{{ __('user_joined_date') }}">
 
                                                                {{ !empty($userInfo) ? date('F d, Y', strtotime($userInfo->created_at)).' At '.date('h:i a', strtotime($userInfo->created_at)) : '' }}</a></p>
                                                        </div>

                                                        <p>{{ $comment->message }}</p>
                                                    </div>
                                                </div>
                                                @php
                                                    if(sizeof($getReply) > 0){
                                                        $usersInfo = $users->find($getReply[0]->user_id);   
                                                @endphp
                                                <ol class="children">
                                                    <li class="comment">
                                                        <div class="comment-body ms_comment_section">
                                                            <div class="comment-author comment_img">
                                                                <img alt="{{$userInfo->title}}" src="{{ !empty($usersInfo) && $usersInfo->image != '' ? $usersInfo->image : asset('assets/images/users/profile.svg') }}" class="avatar avatar-80 photo" height="80" width="80">
                                                            </div>
                                                            <div class="comment-meta commentmetadata comment_info">
                                                                <div class="comment_head">
                                                                    <h3><cite class="fn">{{ !empty($usersInfo) ? $usersInfo->name : '' }}</cite> <span class="says">says:</span></h3>
                                                                    <p><a href="javascript:;" title="{{ __(' user created at') }}">
                                                                        {{ !empty($usersInfo) ? date('F d, Y', strtotime($usersInfo->created_at)).' At '.date('h:i a', strtotime($usersInfo->created_at)) : '' }}
                                                                    </a></p>
                                                                </div>

                                                                <p>{{ $getReply[0]->reply }}</p>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    
                                                </ol>
                                                
                                                @php } @endphp
                                            </li>
                                            
                                    @php
                                        }
                                    }
                                    @endphp
                                </ol>

                                
                                <div class="blog_comments_forms">
                                    <div id="respond" class="comment-respond">
                                        <p>
                                            <h3 id="reply-title" class="comment-reply-title"> {{ __('frontWords.leave_comment') }} </h3>
                                        </p>
                                        <form action="{{ url('user/comment/blog/'.$blog[0]->id) }}" data-reset="1" method="post" class="comment-form">
                                            <div class="col-lg-12 col-md-12">
                                                <div class="comment_input_wrapper">
                                                    <textarea id="comment" class="require" name="message" placeholder="{{ __('frontWords.enter_comment') }}" cols="45" rows="8" aria-required="true" spellcheck="false"></textarea>
                                                </div>
                                            </div>
                                            <div class="ms_input_group2">
                                                <div class="ms_input">
                                                    <button type="button" class="ms_btn" data-action="submitThisForm" title="{{ __('frontWords.post_comment') }}"
                                                    >{{ __('frontWords.post_comment') }}</button> 
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
		            </div> 
				</div>
			</div>
		</div>
    </main> 
    @php
        }
    @endphp
</div>
</div>


</div>
@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.6/isotope.pkgd.min.js"></script>
@endsection
