@extends('layouts.front.main')
@section('title', __('frontWords.blog'))
@section('content')
<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>{{ __('frontWords.blog') }}</h1>
    </div>
    @php
        if(sizeof($blogs) > 0){
            $html = '';
            foreach($blogs as $blog) {
                if($blog->image != '' && file_exists(public_path('images/blogs/'.$blog->image))){
                    $img = ' <img src="'.asset('images/blogs/'.$blog->image).'"z class="img-fluid" alt="{{ __("blogs")}}">';
                }else{
                    $img = '<img src="'.dummyImage('blog').'" class="img-fluid" alt="{{ __("blogs")}}">';
                }
                $html .= '<div class="grid-item">
                            <div class="ms_genres_box">
                                '.$img.'
                                <div class="ms_main_overlay">
                                    <div class="ms_box_overlay"></div>
                                    <div class="ms_play_icon">
                                        <img src="'.asset('images/svg/play.svg').'">
                                    </div>
                                    <div class="ovrly_text_div">
                                        <span class="ovrly_text1"><a href="javascript:;">'.$blog->title.'</a></span>
                                        <span class="ovrly_text2"><a href="'.url('blog/single/'.$blog->id.'/'.$blog->slug).'"><i class="fa fa-long-arrow-right"></i></a></span>
                                    </div>
                                </div>
                                <div class="ms_box_overlay_on blog-text-overlay">
                                    <div class="ovrly_text_div">
                                        <span class="ovrly_text1"><a href="#" title="{{ $blog->title}}">'.$blog->title.'</a></span>
                                    </div>
                                </div>
                            </div>
                        </div>';
                    
            }
            echo '<div class="grid" data-gutter="30"><div class="grid-sizer"></div>'.$html.'</div></div>';
        }else{
            echo '<div class="ms_empty_data">
                    <p>'.__("frontWords.no_blog").'</p>
                </div>';
        }
    @endphp

@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.6/isotope.pkgd.min.js"></script>
@endsection
