@extends('layouts.front.main')
@section('title', __('frontWords.audio_single'))
@section('style')
    <link href="{{asset('assets/css/star-rating.css')}}" rel="stylesheet" type="text/css">
@endsection
@section('content')
@php 
    if(sizeof($audio) > 0){ 
        $artist_name = get_artist_name(['audio_id'=>$audio[0]->id, 'is_audio'=>1]);
        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audio[0]->id]);
@endphp
<div class="ms_artist_single padder_top80">
    <div class="album_single_data">
        <div class="album_single_img">
            @if($audio[0]->image != '' && file_exists(public_path('images/audio/thumb/'.$audio[0]->image)))
                <img src="{{ asset('images/audio/thumb/'.$audio[0]->image) }}" alt="{{$audio[0]->audio_name}}" class="img-fluid">
            @else
                <img src="{{ dummyImage('audio') }}" alt="{{$audio[0]->audio_name}}" class="img-fluid">
            @endif            
        </div>
        <div class="album_single_text">
            <h2>{{ $audio[0]->audio_title }}</h2>
            <p class="singer_name">{{ __('frontWords.by') }} - {{ $artist_name }}</p>
            <p class="singer_name">{{ __('frontWords.duration') }} - {{ $audio[0]->audio_duration }}</p>
            <div class="about_artist">
                <p>{{ $audio[0]->description }}</p>
            </div>
            <div class="album_btn">
                <a href="#" class="ms_btn play_btn play_music" data-musicid="{{ $audio[0]->id }}" data-musictype="audio" data-url="{{ url('/songs') }}" title="{{ __('Audio')}}"><span class="play_all"><img src="{{ asset('assets/images/svg/play_all.svg') }}" alt="{{ __('Play')}}" >{{ __('frontWords.play') }}</span><span class="pause_all"><img src="{{ asset('assets/images/svg/pause_all.svg') }}" alt="{{ __('Pause')}}">{{ __('frontWords.pause') }}</span></a>
                <a href="javascript:;" class="ms_btn add_to_queue" data-musicid="{{ $audio[0]->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"><span class="play_all"><img src="{{ asset('assets/images/svg/add_q.svg') }}" alt="{{ __('Queue')}}">{{ __('frontWords.add_to_queue') }}</span></a>
                <a href="javascript:;" class="ms_btn lyric_show" data-musicid="{{ $audio[0]->id }}" data-musictype="audio" data-toggle="modal" data-target="#ms_lyric_modal_id" title="{{ __('frontWords.lyrics') }}"><span class="play_all">

                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="512" height="512" x="0" y="0" viewBox="0 0 512 512"  xml:space="preserve" class=""><g><path xmlns="http://www.w3.org/2000/svg" d="M448,16H128a8,8,0,0,0-8,8V416H64a8,8,0,0,0-8,8v32a40.045,40.045,0,0,0,40,40H416a40.045,40.045,0,0,0,40-40V24A8,8,0,0,0,448,16ZM216,32H360V176H216ZM96,480a24.028,24.028,0,0,1-24-24V432H376v24a39.792,39.792,0,0,0,8.019,24Zm344-24a24,24,0,0,1-48,0V424a8,8,0,0,0-8-8H136V32h64V184a8,8,0,0,0,8,8H368a8,8,0,0,0,8-8V32h64Z" fill="#ffffff" data-original="#000000" ></path><path xmlns="http://www.w3.org/2000/svg" d="M340.923,49.694a7.988,7.988,0,0,0-6.863-1.455l-64,16A8,8,0,0,0,264,72v41.376A24,24,0,1,0,280,136V78.246l48-12v31.13A24,24,0,1,0,344,120V56A8,8,0,0,0,340.923,49.694ZM256,144a8,8,0,1,1,8-8A8.009,8.009,0,0,1,256,144Zm64-16a8,8,0,1,1,8-8A8.009,8.009,0,0,1,320,128Z" fill="#ffffff" data-original="#000000"></path><path xmlns="http://www.w3.org/2000/svg" d="M248,224h80a8,8,0,0,0,0-16H248a8,8,0,0,0,0,16Z" fill="#ffffff" data-original="#000000" ></path><path xmlns="http://www.w3.org/2000/svg" d="M368,240H208a8,8,0,0,0,0,16H368a8,8,0,0,0,0-16Z" fill="#ffffff" data-original="#000000"></path><path xmlns="http://www.w3.org/2000/svg" d="M360,280a8,8,0,0,0-8-8H224a8,8,0,0,0,0,16H352A8,8,0,0,0,360,280Z" fill="#ffffff" data-original="#000000"></path><path xmlns="http://www.w3.org/2000/svg" d="M248,320a8,8,0,0,0,0,16h80a8,8,0,0,0,0-16Z" fill="#ffffff" data-original="#000000"></path><path xmlns="http://www.w3.org/2000/svg" d="M368,352H208a8,8,0,0,0,0,16H368a8,8,0,0,0,0-16Z" fill="#ffffff" data-original="#000000" ></path><path xmlns="http://www.w3.org/2000/svg" d="M352,384H224a8,8,0,0,0,0,16H352a8,8,0,0,0,0-16Z" fill="#ffffff" data-original="#000000"></path></g></svg>
                {{ __('frontWords.lyrics') }}</span></a>
            </div>
        </div>
        <div class="album_more_optn ms_more_icon">
            <span><img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('Album Option')}}"></span>
        </div>
        <ul class="more_option">
            <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audio[0]->id }}" data-type="audio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
            <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audio[0]->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
            @php
                if(!empty($userPlan) && $userPlan->is_download == 1){
                    if($audio[0]->aws_upload == 1){
                        echo  '<li><a href="'.getSongAWSUrlHtml($audio[0]).'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                    }else{
                        echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$audio[0]->id.'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                    }
                } 
            @endphp
            <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audio[0]->id }}" title="{{ __('frontWords.add_to_playlist') }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
            <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('audio/single/'.$audio[0]->id.'/'.$audio[0]->audio_slug) }}" data-sharename="{{ $audio[0]->audio_title }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
        </ul>
    </div>
</div>
@php
    }
    if(sizeof($similar_audio) > 0){
@endphp
    <div class="ms_fea_album_slider">
        <div class="ms_heading">
            <h1>{{ __('frontWords.similar_track') }}</h1>
            <span class="veiw_all"></span>
        </div>
        <div class="ms_relative_inner">
            <div class="ms_album_slider swiper-container">
            <div class="swiper-wrapper">
                @php
                    foreach($similar_audio as $similarAudio){
                        $getArtist = json_decode($similarAudio->artist_id);
                        $artist_name = '';
                        foreach($getArtist as $artistName){
                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                            if(sizeof($artists) > 0){
                                $artist_name .= $artists[0]->artist_name.', ';
                            }
                        }
                        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $similarAudio->id]);
                @endphp
                <div class="swiper-slide">
                    <div class="ms_rcnt_box">
                        <div class="ms_rcnt_box_img">
                            @if($similarAudio->image != '' && file_exists(public_path('images/audio/thumb/'.$similarAudio->image)))
                                <img src="{{ asset('images/audio/thumb/'.$similarAudio->image) }}" alt="{{$similarAudio->audio_name}}">    
                            @else
                                <img src="{{ dummyImage('audio') }}" alt="{{$similarAudio->audio_name}}" class="img-fluid">
                            @endif
                                         
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('Audio Name')}}">
                                </div>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $similarAudio->id }}" data-type="audio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $similarAudio->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                    @php
                                        if(!empty($userPlan) && $userPlan->is_download == 1){
                                            if($similarAudio->aws_upload == 1){
                                                echo  '<li><a href="'.getSongAWSUrlHtml($similarAudio).'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                                            }else{
                                                echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$similarAudio->id.'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                                            }
                                        }
                                    @endphp
                                    <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $similarAudio->id }}" title="{{ __('frontWords.add_to_playlist') }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('audio/single/'.$similarAudio->id.'/'.$similarAudio->audio_slug) }}" data-sharename="{{ $similarAudio->audio_title }}" title="{{ __('frontWords.share') }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                </ul>
                                <div class="ms_play_icon play_icon_btn play_btn play_music" data-musicid="{{ $similarAudio->id }}" data-musictype="audio" data-url="{{ url('/songs') }}">
                                    <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{ __('play icon') }}">
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="" title="{{ $similarAudio->audio_title}}">{{ $similarAudio->audio_title }}</a></h3>
                            <p>{{ rtrim($artist_name,', ') }}</p>
                        </div>
                    </div>
                </div>  
                @php } @endphp              
        </div>
    </div>

    @php
        }
        if(sizeof($comments) > 0){
    @endphp
    <div class="ms_fea_album_slider">
        <div class="ms_album_content">
            <div class="ms_test_wrapper">
                <div class="ms_heading">
                    <h1>comments ({{ sizeof($comments) }})</h1>
                </div>
                <div class="ms_release_slider swiper-container">
                    <div class="swiper-wrapper">
                        @php foreach($comments as $comment){
                                $user = select(['column' => ['name', 'image'], 'table' => 'users', 'where' =>['id' => $comment->user_id] ]);
                        @endphp
                            <div class="swiper-slide">
                                <div class="ms_test_box">
                                    <div class="ms_test_top">
                                        <div class="ms_test_img">
                                            <img src="{{ !empty($user) && $user[0]->image != '' ? asset('images/user/'.$user[0]->image) : asset('assets/images/users/profile.svg') }}" alt="{{$user[0]->user_name}}" width="50px" height="50px">
                                        </div>
                                        <div class="ms_test_name">
                                            <h3>{{ !empty($user) ? $user[0]->name : '' }}</h3>
                                            <span class="cmnt_time">{{ $comment->created_at->diffForHumans(date('Y-m-d h:i:s')) }}</span>
                                        </div>
                                    </div>
                                    <div class="ms_test_para">
                                        <p>{{ $comment->message }}</p>
                                    </div>
                                </div>
                            </div>
                        @php } @endphp
                </div>
            </div>
            <div class="swiper-button-next1 slider_nav_next"></div>
            <div class="swiper-button-prev1 slider_nav_prev"></div>
        </div>
    </div>
    @php
        }
    @endphp
      
   <div class="ms_cmnt_wrapper">
        <div class="ms_heading">
            <h1>{{ __('frontWords.leave_comment') }}</h1>
        </div>
        <div class="ms_cmnt_form">
            <form method="post" id="commentForm" data-reset="1" action="{{ url('user/comment/audio/'.$audio_id) }}">
                <div class="ms_input_group1">
                    <div class="ms_input">
                        <textarea name="message" class="form-control require" placeholder="{{ __('frontWords.enter_comment') }}"></textarea>
                    </div>
                </div>
                <div class="ms_input_group2">
                    <div class="ms_input">
                        <button type="button" class="ms_btn" data-action="submitThisForm" title="{{ __('frontWords.post_comment') }}">{{ __('frontWords.post_comment') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @if(isset(Auth::user()->id) && Auth::user()->id == 0)
        <div class="ms_cmnt_wrapper">
            <div class="ms_heading">
                <h1>{{ __('frontWords.rating') }}</h1>
            </div>
            <div class="ms_cmnt_form">
                <form method="post" id="ratingForm" action="{{ url('audio/rating') }}">
                    <div class="form-group">
                        <div class="col-md-6">
                            <div class="rating"></div>
                            <input type="hidden" value="" name="rating" class="live-rating" />
                            <input type="hidden" value="{{ $audio_id }}" name="audio_id" id="audioId" />
                        </div>
                    </div> 
                    <div class="form-group">
                        <div class="ms_input">
                            <a href="javascript:;" class="ms_btn" data-action="submitThisForm" title="{{ __('frontWords.submit') }}">{{ __('frontWords.submit') }}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endif
    
</div>
@endsection 
@section('script')
<script src="{{asset('assets/js/star-rating.js')}}"></script>
@endsection
