@extends('layouts.front.main')
@section('title', __('frontWords.track'))
@section('content')
    <div class="ms_weekly_wrapper">
        <div class="ms_weekly_inner">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.top_15') }}</h1>
                    </div>
                </div>
            @php 
                $audio1 = '';
                $audio2 = '';
                $audio3 = '';
                if(sizeof($top_audio) > 0){
                     
                    $cnt = 1;
                    $i=1; 
                    $audios_id = json_decode($top_audio[0]->top_audio);
                    if (!empty($audios_id)) {
    foreach ($audios_id as $audio_id) {
        $audios = select(['column' => '*', 'table' => 'audio', 'where' => ['id' => $audio_id]]);
        foreach ($audios as $audio) {
            $getArtist = json_decode($audio->artist_id);
            $artist_name = '';
            foreach ($getArtist as $artistid) {
                $artists = select(['column' => 'artist_name', 'table' => 'artists', 'where' => ['id' => $artistid]]);
                if (count($artists) > 0) {
                    $artist_name .= $artists[0]->artist_name . ',';
                }
            }
            $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audio->id]);
            $download = '';
            if (!empty($userPlan) && $userPlan->is_download == 1) {
                $download = '<li>' . ($audio->aws_upload == 1 ? '<a href="' . getSongAWSUrlHtml($audio) . '" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>' . __("frontWords.download_now") . '</a>' : '<a href="javascript:;" class="download_track" data-musicid="' . $audio->id . '"><span class="opt_icon"><span class="icon icon_dwn"></span></span>' . __("frontWords.download_now") . '</a>') . '</li>';
            }
            if (!empty($audio->image) && file_exists(public_path('images/audio/thumb/' . $audio->image))) {
                $img = '<img src="' . asset('images/audio/thumb/' . $audio->image) . '"  alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}"class="img-fluid track-img">';
            } else {
                $img = '<img src="' . dummyImage('audio') . '"  alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}"class="img-fluid track-img">';
            }

            $html = '<div class="ms_weekly_box">
                        <div class="weekly_left">
                            <span class="w_top_no">' . ($cnt < 10 ? '0' . $cnt : $cnt) . '</span>
                            <div class="w_top_song">
                                <div class="w_tp_song_img">
                                    ' . $img . '
                                    <div class="ms_song_overlay"></div>
                                    <div class="ms_play_icon play_btn play_music" data-musicid="' . $audio->id . '" data-musictype="audio" data-url="' . url('/songs') . '">
                                        <img src="' . asset('assets/images/svg/play.svg') . '" alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}" >
                                    </div>
                                </div>
                                <div class="w_tp_song_name">
                                    <h3><a href="' . url('audio/single/' . $audio->id . '/' . $audio->audio_slug) . '" title="{{ __("frontWords.audio_title", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}">' . htmlspecialchars($audio->audio_title, ENT_QUOTES) . '</a></h3>
                                    <p>' . (!empty($artist_name) ? rtrim($artist_name, ', ') : 'Unknown') . '</p>
                                </div>
                            </div>
                        </div>
                        <div class="weekly_right">
                            <span class="w_song_time">
                                ' . $audio->audio_duration . ' 
                                <i class="fa fa-thumbs-up likeDislikeAudio" data-id="' . $audio->id . '" data-type="1"></i>
                                <i class="fa fa-thumbs-down likeDislikeAudio" data-id="' . $audio->id . '" data-type="2"></i>
                            </span>
                            <span class="ms_more_icon" data-other="1">
                                <img src="' . asset('assets/images/svg/more.svg') . '" alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}">									
                            </span>
                        </div>
                        <ul class="more_option">
                            <li><a href="javascript:;" class="addToFavourite" data-favourite="' . $audio->id . '" data-type="audio" title="{{ __(" frontWords.favourites ") }}"><span class="opt_icon"><span class="icon ' . ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') . '"></span></span>' . __("frontWords.favourites") . '</a></li>
                            <li><a href="javascript:;" class="add_to_queue" data-musicid="' . $audio->id . '" data-musictype="audio" title="{{ __(" frontWords.add_to_queue") }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>' . __("frontWords.add_to_queue") . '</a></li>
                            ' . $download . '
                            <li><a href="javascript:;" class="ms_add_playlist" data-musicid="' . $audio->id . '" title="{{ __(" frontWords.add_to_playlist") }}"><span class="opt_icon"><span class="icon icon_playlst"  ></span></span>' . __("frontWords.add_to_playlist") . '</a></li>
                            <li><a href="javascript:;" class="ms_share_music" data-shareuri="' . url('audio/single/' . $audio->id . '/' . $audio->audio_slug) . '" data-sharename="' . htmlspecialchars($audio->audio_title, ENT_QUOTES) . '" title="{{ __(" frontWords.share") }}"><span class="opt_icon"><span class="icon icon_share"></span></span>' . __("frontWords.share") . '</a></li>
                        </ul>
                    </div>
                    <div class="ms_divider"></div>';

            $cnt++;
            if ($i % 2 == 0) {
                $audio2 .= $html;
            } else if ($i % 3 == 0) {
                $audio3 .= $html;
            } else {
                $audio1 .= $html;
            }
            
            $i++;
            if ($i % 4 == 0) {
                $i = 1;
            }
        }
    }
}

                    echo '<div class="col-lg-4 col-md-12 padding_right40">'.$audio1.'</div>
                        <div class="col-lg-4 col-md-12 padding_right40">'.$audio2.'</div>
                        <div class="col-lg-4 col-md-12 padding_right40">'.$audio3.'</div>';
                }else{
                    echo '<div class="col-lg-12">
                            <div class="ms_empty_data">
                                <p>'.__("frontWords.no_track").'</p>
                            </div>
                        </div>';
                }
            
            @endphp

        </div>
    </div>
</div>


<div class="ms_releases_wrapper">
    <div class="ms_heading">
        <h1>{{ __("frontWords.trending").' '.__("frontWords.track") }}</h1>
    </div>
    @php 
        if(isset($trending_audio) && sizeof($trending_audio) > 0){
    @endphp
    <div class="ms_release_slider swiper-container">
        <div class="ms_divider"></div>
        <div class="swiper-wrapper">
            @php 
                foreach($trending_audio as $audio){
                    $getArtist = json_decode($audio->artist_id);
                    $artist_name = '';
                    foreach($getArtist as $artistName){
                        $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                        if(count($artists) > 0){
                            $artist_name .= $artists[0]->artist_name.',';
                        }
                    }
                    if($audio->image != '' && file_exists(public_path('images/audio/thumb/'.$audio->image))){
                        $img = '<img src="'.asset('images/audio/thumb/'.$audio['image']).'" alt="{{$audio->audio_title}}" class="img-fuid track-img">';
                    }else{
                        $img = '<img src="'.dummyImage('audio').'" alt="{{$audio->audio_title}}" class="img-fluid track-img">';
                    }
                    echo '<div class="swiper-slide">
                    <div class="ms_release_box">
                        <div class="w_top_song">
                            <span class="slider_dot"></span>
                            <div class="w_tp_song_img">
                                '.$img.'
                                <div class="ms_song_overlay">
                                </div>
                                <div class="ms_play_icon play_btn play_music" data-musicid="'.$audio->id.'" data-musictype="audio" data-url="'.url('/songs').'">
                                    <img src="'.asset('assets/images/svg/play.svg').'"  alt="{{ __("frontWords.play") }}">
                                </div>
                            </div>
                            <div class="w_tp_song_name">
                                <h3><a href="'.url('audio/single/'.$audio['id'].'/'.$audio['audio_slug']).'" title="{{ __(" frontWords.audio") }}">'.$audio['audio_title'].'</a></h3>
                                <p>'.($artist_name != '' ? rtrim($artist_name,',') : 'Unknown').'</p>
                            </div>
                        </div>
                        <div class="weekly_right">
                            <span class="w_song_time">'.$audio->audio_duration.'</span>
                        </div>
                    </div>
                </div>';
            }
        @endphp
           
        </div>
    </div>
    <div class="swiper-button-next1 slider_nav_next"></div>
    <div class="swiper-button-prev1 slider_nav_prev"></div>
    @php
        }else{
            echo '<div class="ms_empty_data">
                    <p>'.__("frontWords.no_track").'</p>
                </div>';
        }
    @endphp
</div>


<div class="ms_featured_slider">
        <div class="ms_heading">
            <h1>{{ __('adminWords.all').' '.__('frontWords.track') }}</h1>
        </div>
        @php
            if(sizeof($all_audios) > 0){
        @endphp
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                <?php
                    foreach($all_audios as $audio){
                        $getArtist = json_decode($audio->artist_id);
                        $artist_name = '';
                        foreach($getArtist as $artistName){
                            $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                            if(count($artists) > 0){
                                $artist_name .= $artists[0]->artist_name.',';
                            }
                        }
                        $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audio->id]);
                        $download = '';
                        if(!empty($userPlan) && $userPlan->is_download == 1){
                            $download = '<li>'.($audio->aws_upload == 1 ? '<a href="'.getSongAWSUrlHtml($audio).'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a>' : '<a href="javascript:;" class="download_track" data-musicid="'.$audio->id.'"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a>').'</li>';
                        }
                        if (!empty($audio->image) && file_exists(public_path('images/audio/thumb/' . $audio->image))) {
                            $img = '<img src="' . asset('images/audio/thumb/' . $audio->image) . '"  alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}"class="img-fluid track-img">';
                        } else {
                             $img = '<img src="' . dummyImage('audio') . '"  alt="{{ __("frontWords.audio_alt", ["title" => htmlspecialchars($audio->audio_title, ENT_QUOTES)]) }}"class="img-fluid track-img">';
                        }

                
                        echo '<div class="swiper-slide">
                                <div class="ms_rcnt_box">
                                    <div class="ms_rcnt_box_img">
                                        '.$img.'
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            <div class="ms_more_icon">
                                                <img src="'.asset('assets/images/svg/more.svg').'"  alt="{{ __("frontWords.more") }}">
                                            </div>
                                            <ul class="more_option">
                                                <li><a href="javascript:;" class="addToFavourite" data-favourite="'.$audio->id.'" data-type="audio" title="{{ __(" frontWords.favourites ") }}"><span class="opt_icon"><span class="icon '.($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav').'"></span></span>'.__("frontWords.favourites").'</a></li>
                                                <li><a href="javascript:;" class="add_to_queue" data-musicid="'.$audio->id.'" data-musictype="audio" title="{{ __(" frontWords.add_to_queue") }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>'.__("frontWords.add_to_queue").'</a></li>
                                                '.$download.'
                                                <li><a href="javascript:;" class="ms_add_playlist" data-musicid="'.$audio->id.'" title="{{ __(" frontWords.add_to_playlist") }}"><span class="opt_icon"><span class="icon icon_playlst"></span></span>'.__("frontWords.add_to_playlist").'</a></li>

                                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('audio/single/'.$audio->id.'/'.$audio->audio_slug).'" data-sharename="'.$audio->audio_title.'" title="{{ __(" frontWords.share") }}"><span class="opt_icon"><span class="icon icon_share"></span></span>'.__("frontWords.share").'</a></li>
                                            </ul>
                                            <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="'.$audio->id.'" data-musictype="audio" data-url="'.url('/songs').'">
                                                <img src="'.asset('assets/images/svg/play.svg').'"  alt="{{ __("frontWords.play") }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ms_rcnt_box_text">
                                        <h3><a href="'.url('audio/single/'.$audio->id.'/'.$audio->audio_slug).'" title="{{$audio->audio_title }}">'.$audio->audio_title.'</a></h3>
                                        <p>'.($artist_name != '' ? rtrim($artist_name,',') : 'Unknown').'</p>
                                    </div>
                                </div>
                            </div>';
                
                    }
                // @endphp
                ?>
            </div>
        </div>
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        @php
            }else{
                echo '<div class="ms_empty_data">
                        <p>'.__("frontWords.no_featured_audio").'</p>
                    </div>';
            }
        @endphp
    </div>
@endsection
