@extends('layouts.front.main')
@section('title', __('frontWords.artist_single'))
@section('content')
<div class="ms_album_single_wrapper ms_artist_single">
    <div class="album_single_data">
        @php
            if(!empty($artist)){
                $genre_name = getArtistGenreName(['genre_id' => $artist[0]->artist_genre_id]);
        @endphp
        <div class="album_single_img">
            @if($artist[0]->image != '' && file_exists(public_path('images/artist/'.$artist[0]->image)))
                <img src="{{ asset('images/artist/'.$artist[0]->image) }}" alt="{{$artist[0]->artist_name}}" class="img-fluid">
            @else
                <img src="{{ dummyImage('artist') }}" alt="{{$artist[0]->artist_name}}" class="img-fluid">
            @endif            
        </div>
        <div class="album_single_text">
            <h2>{{ $artist[0]->artist_name }}</h2>
            <p class="singer_name">{{ $genre_name }}</p>
            <div class="about_artist">{{ $artist[0]->description }} </div>
            <div class="album_btn">
                <a href="#" class="ms_btn play_btn play_music" data-musicid="{{ $artist[0]->id }}" data-musictype="artist" data-url="{{ url('/songs') }}" title="{{ __('Songs') }}"><span class="play_all"><img src="{{ asset('assets/images/svg/play_all.svg') }}" alt="{{$artist[0]->artist_name}}">{{ __('frontWords.play_all') }}</span><span class="pause_all"><img src="{{ asset('assets/images/svg/pause_all.svg') }}" alt="{{$artist[0]->artist_name}}">{{ __('frontWords.pause') }}</span></a>
                <a href="javascript:;" class="ms_btn add_to_queue" data-musicid="{{ $artist[0]->id }}" data-musictype="artist" title="{{ __('frontWords.add_to_queue') }}"><span class="play_all"><img src="{{ asset('assets/images/svg/add_q.svg') }}" alt="{{$artist[0]->artist_name}}">{{ __('frontWords.add_to_queue') }}</span></a>
            </div>
        </div>
        <div class="album_more_optn ms_more_icon">
            <span><img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('Icons')}}"></span>
        </div>
        <ul class="more_option">
            <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $artist[0]->id }}" data-type="artist" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
            <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $artist[0]->id }}" data-musictype="artist" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
            <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('artist/single/'.$artist[0]->id.'/'.$artist[0]->artist_slug) }}" data-sharename="{{ $artist[0]->artist_name }}" title="{{ $artist[0]->artist_name}}">><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
        </ul>
       
    </div>
    <div class="album_inner_list">
        <div class="album_list_wrapper">
            <ul class="album_list_name">
                <li>#</li>
                <li>{{ __('frontWords.track_title') }}</li>
                <li>{{ __('frontWords.artist') }}</li>
                <li class="text-center">{{ __('frontWords.duration') }}</li>
                <li class="text-center">{{ __('frontWords.more') }}</li>
            </ul>
            @php 
                if(sizeof($getSong) > 0){
                    $song_list = json_decode($getSong[0]->audio_id);
                    if(!empty($song_list)){
                        $cnt = 0;
                        foreach($song_list as $song){
                            $audioDetail = audioDetail(['songid' => $song]);
                            if(!empty($audioDetail)){
                                foreach($audioDetail as $audios){
                                    $cnt++;
                                    $getArtist = json_decode($audios->artist_id);
                                    $artist_name = '';
                                    foreach($getArtist as $artistName){
                                        $artists = select(['column'=>'artist_name','table'=>'artists','where'=>['id'=>$artistName] ]);
                                        if(count($artists) > 0){
                                            $artist_name .= $artists[0]->artist_name.',';
                                        }
                                    }
                                    $getLikeDislikeAudio = getFavDataId(['column' => 'audio_id', 'audio_id' => $audios->id]);
            @endphp
            <ul>
                <li><span class="play_no">{{ $cnt }}</span><span class="play_hover play_music" data-musicid="{{ $audios->id }}" data-musictype="audio" data-url="{{ url('/songs') }}"></span></li>
                <li><a href="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}">{{ $audios->audio_title }}</a></li>
                <li>{{ rtrim($artist_name,',') }}</li>
                <li class="text-center">{{ $audios->audio_duration }}</li>
                <li class="text-center ms_more_icon"><a href="javascript:;"><span class="ms_icon1 ms_active_icon"></span></a>
                    <ul class="more_option">
                        <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $audios->id }}" data-type="audio" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAudio == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                        <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $audios->id }}" data-musictype="audio" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                        @php
                            if(!empty($userPlan) && $userPlan->is_download == 1){
                                if($audios->aws_upload == 1){
                                    echo  '<li><a href="'.getSongAWSUrlHtml($audios).'" title="{{ __("frontWords.download_now") }}"><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__("frontWords.download_now").'</a></li>';
                                }else{
                                    echo '<li><a href="javascript:;" class="download_track" data-musicid="'.$audios->id.'" title="{{$audios->id }}">><span class="opt_icon"><span class="icon icon_dwn"></span></span>'.__('frontWords.download_now').'</a></li>';
                                }
                            }
                        @endphp
                        <li><a href="javascript:;" class="ms_add_playlist" data-musicid="{{ $audios->id }}" title="{{ $audios->id}}">><span class="opt_icon"><span class="icon icon_playlst"></span></span>{{ __('frontWords.add_to_playlist') }}</a></li>
                        <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('audio/single/'.$audios->id.'/'.$audios->audio_slug) }}" data-sharename="{{ $audios->title }}" title="{{$audios->title }}">><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                    </ul>
                </li>
            </ul>
            @php
                            }
                        }
                    }
                }
            }
            @endphp
        </div>
    </div>
</div>

@php
    }
@endphp

@endsection 
