@extends('layouts.front.main')
@section('title', __('frontWords.artist'))
@section('content')

<div class="ms_featured_slider padder_top20">
    <div class="ms_heading">
        <h1>Featured Artists</h1>
    </div>
    <div class="ms_relative_inner">
        @php 
            if(sizeof($featured_artist) > 0){
        @endphp
        <div class="ms_release_slider swiper-container">
            <div class="swiper-wrapper">
                @php 
                    foreach($featured_artist as $artists){
                        if($artists->image != '' && file_exists(public_path('images/artist/'.$artists->image))){
                            $img = '<img src="'.asset('images/artist/'.$artists->image).'" alt="{{$artists->artist_name}}" class="img-fluid">';
                        }else{
                            $img = '<img src="'.dummyImage('artist').'" alt="{{$artists->artist_name}}" class="img-fluid">';
                        }
                        echo '<div class="swiper-slide">
                                <div class="ms_rcnt_box">
                                    <div class="ms_rcnt_box_img">
                                        '.$img.'
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            <div class="ms_more_icon">
                                                <img src="'.asset('assets/images/svg/more.svg').'" alt="">
                                            </div>
                                            <ul class="more_option">
                                                <li><a href="javascript:;" class="addToFavourite" data-favourite="'.$artists->id.'" data-type="artist" title="{{ __("frontWords.favourites") }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>'.__("frontWords.favourites").'</a></li>
                                                <li><a href="javascript:;" class="add_to_queue" data-musicid="'. $artists->id.'" data-musictype="artist" title="{{ __("frontWords.add_to_queue") }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>'.__("frontWords.add_to_queue").'</a></li>
                                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('artist/single/'.$artists->id.'/'.$artists->artist_slug).'" data-sharename="'.$artists->artist_name.'" title="{{ __("frontWords.share") }}"><span class="opt_icon"><span class="icon icon_share"></span></span>'.__("frontWords.share").'</a></li>
                                            </ul>
                                            <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="'.$artists->id.'" data-musictype="artist" data-url="'.url('/songs').'">
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ms_rcnt_box_text">
                                        <h3><a href="'.url('artist/single/'.$artists->id.'/'.$artists->artist_slug).'" title="{{$artists->artist_name }}">'.$artists->artist_name.'</a></h3>
                                    </div>
                                </div>
                            </div>';
                    }
                @endphp
            </div>
        </div>
        
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        @php
            }else{
                echo '<div class="ms_empty_data">
                        <p>'.__("frontWords.no_featured_artist").'</p>
                    </div>';
            }
        @endphp
    </div>
</div>

<div class="ms_top_artist">
    <div class="container-fluid">
    @php 
        if(sizeof($top_artist) > 0){
    @endphp
        <div class="row">
            <div class="col-lg-12">
                <div class="ms_heading">
                    <h1>{{ __("frontWords.top_artist") }}</h1>
                </div>
            </div>
            @php 
                $artists_id = json_decode($top_artist[0]->top_artist);
                if(!empty($artists_id)){
                    foreach($artists_id as $artist_id){
                        $getArtist = select(['column' => '*', 'table'=>'artists', 'where'=>['id'=>$artist_id] ]); 
                        if(!empty($getArtist)){
                            foreach($getArtist as $artist){
            @endphp                        
                <div class="col-lg-2 col-md-6">
                    <div class="ms_rcnt_box marger_bottom30">
                        <div class="ms_rcnt_box_img">
                            @if($artist->image != '' && file_exists(public_path('images/artist/'.$artist->image)))
                                <img src="{{ asset('images/artist/'.$artist->image) }}" alt="{{$artist->artist_name}}" class="img-fluid">
                            @else
                                <img src="{{ dummyImage('artist') }}" alt="{{$artist->artist_name}}" class="img-fluid">
                            @endif
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{$artist->artist_name}}">
                                </div>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $artist->id }}" data-type="artist" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon icon_fav"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $artist->id }}" data-musictype="artist" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('artist/single/'.$artist->id.'/'.$artist->artist_slug) }}" data-sharename="{{ $artist->artist_name }}" title="{{$artist->artist_name }}" ><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                </ul>
                                <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $artist->id }}" data-musictype="artist" data-url="{{ url('/songs') }}">
                                    
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="{{ url('artist/single/'.$artist->id.'/'.$artist->artist_slug) }}" title="{{ $artist->artist_name }}">{{ $artist->artist_name }}</a></h3>
                        </div>
                    </div>
                </div>
            @php
                            }
                        }
                    }
                }
            @endphp
        </div>
    @php
        }else{
            echo '<div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>'.__("frontWords.top_artist").'</h1>
                    </div>
                </div>
                <div class="ms_empty_data">
                    <p>'.__("frontWords.no_artist").'</p>
                </div>';
        }
    @endphp
    </div>
</div>

</div>
@endsection
