class="ms_rcnt_box_text"@extends('layouts.front.main')
@section('title', __('frontWords.album'))
@section('content')

    <div class="ms_fea_album_slider padder_top10 ms_new_slider_dv">
        <div class="ms_heading" class="ms_rcnt_box_text">
            <h1>{{ __('frontWords.featured').' '.__('frontWords.album') }}</h1>
        </div>
        @php
            if(sizeof($albums) > 0){
        @endphp
        <div class="ms_album_slider swiper-container">
            <div class="swiper-wrapper">
                @php
                    foreach($albums as $album){
                        if($album->is_featured == 1){
                            $artist_name = get_artist_name(['album_id'=>$album->id]);
                            $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
                @endphp
                        <div class="swiper-slide">
                            <div class="ms_rcnt_box">
                                <div class="ms_rcnt_box_img">
                                    @if($album->image != '' && file_exists(public_path('images/album/'.$album->image)))
                                        <img src="{{ asset('images/album/'.$album->image) }}" alt="{{$album->album_name}}" class="img-fluid album-img">
                                    @else
                                        <img src="{{ dummyImage('album') }}" alt="{{$album->album_name}}" class="img-fluid album-img">
                                    @endif                                    
                                    <div class="ms_main_overlay">
                                        <div class="ms_box_overlay"></div>
                                        <div class="ms_more_icon">
                                            <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('Icons')}}">
                                        </div>
                                        <ul class="more_option">
                                            <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $album->id }}" data-type="album" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAlbum == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                            <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $album->id }}" data-musictype="album" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                            <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" data-sharename="{{ $album->album_name }} " title="{{ $album->album_name}}">><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                        </ul>
                                        <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $album->id }}" data-musictype="album" data-url="{{ url('/songs') }}">
                                            <img src="{{ asset('assets/images/svg/play.svg') }}" alt="{{$album->album_slug}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="ms_rcnt_box_text">
                                    <h3><a href="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" title="{{ $album->album_name }}">{{ $album->album_name }}</a></h3>
                                    <p>{{ ($artist_name != '' ? $artist_name : 'Unknown') }}</p>
                                </div>
                            </div>
                        </div>
                @php   }
                    }
                @endphp
            </div>
        </div>
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        @php
            }else{
                echo '<div class="ms_empty_data">
                        <p>'.__("frontWords.no_featured_album").'</p>
                    </div>';
            }
        @endphp
    </div>
        
    <div class="ms_rcnt_slider padder_top50">
        <div class="ms_heading">
            <h1>{{ __("frontWords.trending").' '.__("frontWords.album") }}</h1>
        </div>
        @php
            if(sizeof($albums) > 0){
        @endphp
        <div class="swiper-container ms_album_slider">
            <div class="swiper-wrapper">
            @php
                foreach($albums as $album){
                    if($album->is_trending == 1){
                        $artist_name = get_artist_name(['album_id'=>$album->id]);
                        $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
            @endphp
                <div class="swiper-slide">
                    <div class="ms_rcnt_box">
                        <div class="ms_rcnt_box_img">
                            @if($album->image != '' && file_exists(public_path('images/album/'.$album->image)))
                                <img src="{{ asset('images/album/'.$album->image) }}" alt="{{ $album->album_name}}" class="img-fluid album-img">
                            @else
                                <img src="{{ dummyImage('album') }}" alt="{{ $album->album_name}}" class="img-fluid album-img">
                            @endif
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="{{ asset('assets/images/svg/more.svg') }}" alt="{{ __('Icons')}}">
                                </div>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="addToFavourite" data-favourite="{{ $album->id }}" data-type="album" title="{{ __('frontWords.favourites') }}"><span class="opt_icon"><span class="icon {{ ($getLikeDislikeAlbum == 1 ? 'icon_fav_add' : 'icon_fav') }}"></span></span>{{ __('frontWords.favourites') }}</a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="{{ $album->id }}" data-musictype="album" title="{{ __('frontWords.add_to_queue') }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>{{ __('frontWords.add_to_queue') }}</a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="{{ url('album/single/'.$album->id.'/'.$album->album_slug) }}" data-sharename="{{ $album->album_name }} " title="{{$album->album_name }}"><span class="opt_icon"><span class="icon icon_share"></span></span>{{ __('frontWords.share') }}</a></li>
                                </ul>
                                <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="{{ $album->id }}" data-musictype="album" data-url="{{ url('/songs') }}"> 
                                    
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="{{ url('album/single/'.$album->id.'/'.$album->album_slug)}}" title="{{$album->album_name}}">{{ $album->album_name }}</a></h3>
                            <p>{{ ($artist_name != '' ? $artist_name : 'Unknown')}}</p>
                        </div>
                    </div>
                </div>  
                @php
                        }
                    }
                @endphp
            </div>
        </div>
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        @php
            }else{
                echo '<div class="ms_empty_data">
                            <p>'.__("frontWords.no_trending_album").'</p>
                        </div>';
            }
        @endphp
    </div>
    <div class="ms_weekly_wrapper">
        <div class="ms_weekly_inner">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1>{{ __('frontWords.top_15').' '.__('frontWords.album') }}</h1>
                    </div>
                </div>
                    
                    @php 
                        $album1 = '';
                        $album2 = '';
                        $album3 = '';
                        if(sizeof($top_album) > 0){
                            $cnt = 1;
                            $i=1; 
                            
                            $albums_id = json_decode($top_album[0]->top_album);
                            if(!empty($albums_id)){
                                foreach($albums_id as $album_id){
                                    $albumsData = select(['column' => '*', 'table' => 'albums', 'where' => ['id'=>$album_id] ]);
                                    if(!empty($albumsData)){
                                        foreach($albumsData as $album){
                                            $artist_name = get_artist_name(['album_id'=>$album->id]);
                                            $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
                                            if(!empty($album->song_list)){
                                                $duration = multiple_audio_duration(['list'=>$album->song_list,'add'=>1]);
                                            }
                                            if($album->image != '' && file_exists(public_path('images/album/'.$album->image))){
                                                $img = '<img src="'.asset('images/album/'.$album->image).'" alt="{{$album->song_list}}" class="img-fuid track-img">';
                                            }else{
                                                $img = '<img src="'.dummyImage('album').'" alt="{{$album->song_list}}" class="img-fuid track-img">';
                                            }
                                                $html = '<div class="ms_weekly_box">
                                                            <div class="weekly_left">
                                                                <span class="w_top_no">'.($cnt < 10 ? '0'.$cnt : $cnt).'</span>
                                                                <div class="w_top_song">
                                                                    <div class="w_tp_song_img">
                                                                        '.$img.'
                                                                        <div class="ms_song_overlay">
                                                                        </div>
                                                                        <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="'.$album->id.'" data-musictype="album" data-url="'.url('/songs').'">
                                                                            <img src="'.asset('assets/images/svg/play.svg').'"  alt="{{ __("frontWords.play_icon") }}">
                                                                        </div>
                                                                    </div>
                                                                    <div class="w_tp_song_name">
                                                                        <h3><a href="'.url('album/single/'.$album->id.'/'.$album->album_slug).'" title="{{$album->album_slug}}">'.$album->album_name.'</a></h3>
                                                                        <p>'.rtrim(($artist_name != '' ? $artist_name : '') , ',').'</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="weekly_right">
                                                                <span class="w_song_time">'.$duration.'</span>
                                                                <span class="ms_more_icon" data-other="1">
                                                                    <img src="'.asset('assets/images/svg/more.svg').'" alt="{{$album->album_slug}}">									
                                                                </span>
                                                            </div>
                                                            <ul class="more_option">
                                                                <li><a href="javascript:;" class="addToFavourite" data-favourite="'.$album->id.'" data-type="album" title="{{ __("frontWords.favourites") }}"><span class="opt_icon"><span class="icon '.($getLikeDislikeAlbum == 1 ? 'icon_fav_add' : 'icon_fav').'"></span></span>'.__('frontWords.favourites').'</a></li>
                                                                <li><a href="javascript:;" class="add_to_queue" data-musicid="'.$album->id.'" data-musictype="album" title="{{ __("frontWords.add_to_queue") }}"><span class="opt_icon"><span class="icon icon_queue"></span></span>'.__('frontWords.add_to_queue').'</a></li>
                                                                <li><a href="javascript:;" class="ms_share_music" data-shareuri="'.url('album/single/'.$album->id.'/'.$album->album_slug).'" data-sharename="'.$album->album_name.'" title="{{ $album->album_name}}">><span class="opt_icon"><span class="icon icon_share"></span></span>'.__('frontWords.share').'</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="ms_divider"></div>';
                                            $cnt++;
                                            if($i%2 == 0){
                                                $album2 .= $html;
                                            }else if($i%3==0){
                                                $album3 .= $html;
                                            }else{
                                                $album1 .= $html;
                                            }
                                            
                                            $i++;
                                            if($i%4 == 0){
                                                $i=1;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    @endphp
                    
                    
                <div class="col-lg-4 col-md-12 padding_right40">@php echo $album1 @endphp</div> 
                <div class="col-lg-4 col-md-12 padding_right40">@php echo $album2 @endphp</div>
                <div class="col-lg-4 col-md-12 padding_right40">@php echo $album3 @endphp</div>
            </div>
            @php
                if(sizeof($top_album) == 0 ){
                    echo '<div class="ms_empty_data">
                            <p>'.__("frontWords.no_album").'</p>
                        </div>';
                }
            @endphp
        </div>
    </div>

    <div class="ms_releases_wrapper">
        <div class="ms_heading">
            <h1>{{ __('frontWords.newly_released') }}</h1>
        </div>
        @php 
            if(sizeof($albums) == 0){
        @endphp
            <div class="ms_empty_data">
                <p>{{ __("frontWords.no_album") }}</p>
            </div>
        @php 
            }else{
        @endphp
        <div class="ms_release_slider swiper-container">
            <div class="ms_divider"></div>
            <div class="swiper-wrapper">
            @php 
                foreach($albums as $newAlbum){
                    $artist_name = get_artist_name(['album_id'=>$newAlbum->id]);
                    $getLikeDislikeAlbum = getFavDataId(['column' => 'album_id', 'album_id' => $album->id]);
                    if(!empty($newAlbum->song_list)){
                        $duration = multiple_audio_duration(['list'=>$newAlbum->song_list,'add'=>1]);
                    }
                    if($newAlbum->image != '' && file_exists(public_path('images/album/'.$newAlbum->image))){
                        $img = '<img src="'.asset('images/album/'.$newAlbum->image).'" alt="{{$newAlbum->artist_name}}" class="img-fuid track-img">';
                    }else{
                        $img = '<img src="'.dummyImage('album').'" alt="{{$newAlbum->artist_name}}" class="img-fuid track-img">';
                    }
                    echo '<div class="swiper-slide">
                            <div class="ms_release_box">
                                <div class="w_top_song">
                                    <span class="slider_dot"></span>
                                    <div class="w_tp_song_img">
                                        '.$img.'
                                        <div class="ms_song_overlay">
                                        </div>
                                        <div class="ms_play_icon play_btn play_music play_icon_btn" data-musicid="'.$newAlbum->id.'" data-musictype="album" data-url="'.url('/songs').'">
                                            <img src="'.asset('assets/images/svg/play.svg').'" alt="{{$newAlbum->artist_name}}">
                                        </div>
                                    </div>
                                    <div class="w_tp_song_name">
                                        <h3><a href="'.url('album/single/'.$newAlbum->id.'/'.$newAlbum->album_slug).'" title="{{ __("frontWords.album") }}">'.$newAlbum->album_name.'</a></h3>
                                        <p>'.$artist_name.'</p>
                                    </div>
                                </div>
                                <div class="weekly_right">
                                    <span class="w_song_time">'.$duration.'</span>
                                </div>
                            </div>
                        </div>';
                }
            @endphp
                
            </div>
        </div>
        <div class="swiper-button-next1 slider_nav_next"></div>
        <div class="swiper-button-prev1 slider_nav_prev"></div>
        @php
            }
        @endphp
        
    </div>
</div>
@endsection
