<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="{{ (isset($settings['meta_desc']) ? $settings['meta_desc'] : 'Miraculous laravel admin dashboard template') }}">
    <meta name="keywords" content="{{ (isset($settings['keywords']) ? $settings['keywords'] : 'songs') }}">
    <meta name="author" content="{{ (isset($settings['author_name']) ? $settings['author_name'] : __('adminWords.miraculous') ) }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ (isset($settings['w_title']) ? $settings['w_title'] : __('adminWords.miraculous')) }}</title>
    <link href="{{ asset('assets/images/favicon.ico') }}" rel="shortcut icon" >
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet" type="text/css">
</head>
<body class="vertical-layout">
    <div id="containerbar" class="containerbar authenticate-bg">
        <div class="container">
            <div class="auth-box error-box">
                 <div class="row no-gutters align-items-center justify-content-center">
                    <div class="col-md-8 col-lg-6">
                        <div class="text-center">
                            @if(isset($settings['logo']))
                                <img src="{{ asset('images/sites/'.$settings['logo']) }}" class="img-fluid error-logo" alt="{{ __('logo')}}">
                            @endif
                            <img src="{{ asset('assets/images/error/404.svg') }}" class="img-fluid error-image" alt="{{ __('l404')}}">
                            <h4 class="error-subtitle mb-4">{{ __('adminWords.page_not_found') }}</h4>
                            <p class="mb-4">{{ __('adminWords.error_404') }}</p>
                            <a href="{{url('/')}}" class="btn btn-primary font-16" title="{{ __('adminWords.go_to_db') }}"><i class="feather icon-home mr-2"></i> {{ __('adminWords.go_to_db') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
