@extends('layouts.admin.main')
@section('title', __('Service'))
@section('style')
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('Open Ai Service') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}" title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#" title="{{ __('Open Ai Service') }}">{{ __('Open Ai Service') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-5 col-lg-5">
                <div class="widgetbar">
                    <a type="button" class="btn btn-danger " data-toggle="modal" data-target="#bulk_delete"><i class="flaticon-delete"></i> {{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-4 col-md-5">
                <div class="card">
                    <div class="card-body">
                        <div class="admin-form">
                            <form action="{{ route('services.store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="title" class="form-label">{{ __('Title') }}<span class="required">*</span></label>
                                    <input class="form-control" type="text" name="name" required id="title" placeholder="{{ __('Enter Your Title') }}" aria-label="title" value="{{ old('title') }}">
                                    <div class="form-control-icon"><i class="flaticon-heading"></i></div>
                                </div>

                                <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('Status', __('adminWords.status')) !!}
                                        </div>
                                        <div class="col-lg-2">
                                            {!! Form::checkbox('status', 1, isset($status) && $status->status == 0 ? 0 : 1, ['class' => 'js-switch-primary']) !!}
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group-btn">
                                    <button type="submit" class="btn btn-primary" title="{{ __('Submit') }}"><i class="flaticon-upload-1"></i> {{ __('Submit') }}</button>
                                </div>
                            </form>
                            <!-- form Code end -->
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-lg-8 col-md-7">
                <div class="card m-b-30">
                    <div class="card-body">
                        <div class="table-responsive">
                            <!-- table code start -->
                            <table class="table table-borderless mrclsDtToShowData text-center" id="datatable-buttons" data-url="{{ route('services.index') }}">
                                <thead>
                                    <tr>
                                        <th class="select-checkbox">
                                            <div class="inline custom-checkbox">
                                                <input id="checkboxAll" type="checkbox" class="custom-control-input selectAllUser" onchange="checkAll(this, 'CheckBoxes')">
                                                <label for="checkboxAll" class="custom-control-label"></label>
                                            </div>
                                        </th>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <!-- loop Print data show start -->
                                <tbody>
                                    @if (isset($services))
                                        @foreach ($services as $data)
                                            <tr data-id="{{ $data->id }}">
                                                <td>
                                                    <div class="inline custom-checkbox">
                                                        <input name="checked" id="checkboxAll{{ $data->id }}" type="checkbox" class="custom-control-input CheckBoxes" value="{{ $data->id }}">
                                                        <label for="checkboxAll{{ $data->id }}" class="custom-control-label"></label>
                                                    </div>
                                                </td>
                                                <td>
                                                    {{ $data->name }}
                                                </td>
                                                <td>
                                                    <div class="switch-main-block">
                                                        <input class="js-switch-primary" type="checkbox" role="switch" 
                                                               name="status" data-id="{{ $data->id }}" 
                                                               value="{{ $data->status }}" {{ $data->status == 1 ? 'checked' : '' }}>
                                                    </div>
                                                </td>
                                                
                                                <td>
                                                    <a href="{{ route('services.edit', $data->id) }}" class="btn btn-sm btn-success-rgba" title="{{ __('Edit') }}"><i class="feather icon-edit-2"></i></a>
                                                            
                                                     <a class="btn btn-sm btn-danger-rgba" href="#" data-toggle="modal" data-target="#exampleModal{{ $data->id }}" title="{{ __('Delete') }}"><i class="feather icon-trash"></i></a>
                                                </td>
                                            </tr>
                                            <!-- model Start -->
                                            <div class="modal fade" id="exampleModal{{ $data->id }}" tabindex="-1"
                                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="exampleModalLabel"> {{ __('Are You Sure ?') }}</h1>
                                                            <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <p>{{ __('Do you really want to delete') }} ?{{ __('This process cannot be undone.') }}</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <form method="post" action="{{ route('services.destroy', $data->id) }}" class="pull-right">
                                                                {{ csrf_field() }}
                                                                {{ method_field('DELETE') }}
                                                                <button type="reset" class="btn btn-secondary" title="{{ __('No') }}" data-dismiss="modal">{{ __('No') }}</button>
                                                                <button type="submit" title="{{ __('Yes') }}" class="btn btn-primary">{{ __('Yes') }}</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- model end -->
                                        @endforeach
                                        <!-- loop  Print data show end -->
                                    @endif
                                </tbody>
                            </table>
                            <!-- table code end -->
                            <div class="d-flex justify-content-end">
                                <div class="pagination pagination-circle mb-3">
                                    {{ $services->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bulk Delete Modal start -->
    <div class="modal fade" id="bulk_delete" tabindex="-1" aria-labelledby="bulkDeleteLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="bulkDeleteLabel">{{ __('Delete Selected Records') }}</h1>
                    <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('Do you really want to delete the selected records? This action cannot be undone.') }}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" title="{{ __('No') }}" data-dismiss="modal">{{ __('No') }}</button>
                    <form id="bulk_delete_form" method="post" action="{{ route('services.bulk_delete') }}">
                        @csrf
                        @method('POST')
                        <button type="submit" title="{{ __('Yes') }}" class="btn btn-primary">{{ __('Yes') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Bulk Delete Modal end -->
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>      
    <script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script> 
    <script>
        $(function () {
            $(".js-switch-primary").change(function () {
                var is_active = $(this).prop("checked") ? 1 : 0;
                var id = $(this).data("id");
    
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "services/update-status", // Ensure this URL matches your route
                    data: {
                        status: is_active,
                        id: id
                    },
                    success: function (data) {
                        if (data.success) {
                            console.log('Status updated successfully for ID:', id);
                        } else {
                            console.log('Failed to update status for ID:', id);
                        }
                    },
                    error: function (error) {
                        console.log('Error:', error);
                    }
                });
            });
        });
    </script>
    
@endsection
