@extends('layouts.admin.main')
@section('title', __('Edit Service'))
@section('style')
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('Service') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}" title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#" title="{{ __('Service') }}">{{ __('Service') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-5 col-lg-5">
                <div class="widgetbar">
                    <a href="{{ route('services.index') }}" type="button" class="btn btn-success"><i class="flaticon-back"></i>{{ __('Back') }}</a>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-6">
                <div class="card m-b-30">
                    <div class="card-body">
                        <div class="admin-form">
                            <!-- form Code start -->
                            <form action="{{ route('services.update', $service->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('put')
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label for="title" class="form-label">{{ __('Title') }}<span class="required">*</span></label>
                                            <input class="form-control" type="text" name="name" required id="title" placeholder="{{ __('Enter Your Title') }}" aria-label="title" value="{{ $service->name }}">
                                            <div class="form-control-icon"><i class="flaticon-heading"></i></div>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                            <div class="row">
                                                <div class="col-lg-3">
                                                    {!! Form::label('Status', __('adminWords.status')) !!}
                                                </div>
                                                <div class="col-lg-2">
                                                    {!! Form::checkbox('status', 1, old('status', $service->status), ['id' => 'switch1', 'class' => 'js-switch-primary']) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                 </div>
                                 <div class="form-group-btn">
                                    <button type="submit" class="btn btn-success" title="{{ __('Submit') }}"><i class="flaticon-paper-plane"></i> {{ __('Update') }}</button>
                                 </div>
                           </form>
                    </div>
                    <!-- form Code end -->
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
