@extends('layouts.admin.main')
@section('title', __('Open AI'))
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('Open AI') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"  title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#" title="{{ __('Open AI') }}">{{ __('Open AI') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-5 col-lg-5">
                <div class="widgetbar">
                    <a type="button" class="btn btn-danger " data-toggle="modal" data-target="#bulk_delete" title="{{ __('Delete') }}"><i class="flaticon-delete"></i> {{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    <!--start contentbar -->
    <div class="contentbar ">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-body">
                        <div class="table-responsive">
                            <!-- Table start-->
                            <table class="table table-borderless mrclsDtToShowData text-center" id="datatable-buttons">
                                <thead>
                                    <tr>
                                        <th class="select-checkbox">
                                            <div class="inline custom-checkbox">
                                                <input id="checkboxAll" type="checkbox" class="custom-control-input selectAllUser" onchange="checkAll(this, 'CheckBoxes')"  placeholder="{{ __('checkboxAll') }}">
                                                <label for="checkboxAll" class="custom-control-label"></label>
                                            </div>
                                        </th>
                                        <th>{{ __('#') }}</th>
                                        <th>{{ __('Genrate') }}</th>
                                        <th>{{ __('Prompt') }}</th>
                                        <th>{{ __('Response') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <!-- loop  Print data show Start --->
                                <tbody>
                                    @foreach ($openai as $key => $test)
                                        @if (isset($test))
                                            <tr>
                                                <td>
                                                    <div class="inline custom-checkbox">
                                                        <input name="checked" id="checkboxAll{{ $test->id }}" type="checkbox" class="custom-control-input CheckBoxes" value="{{ $test->id }}"  placeholder="{{ __('checkboxAll') }}">
                                                        <label for="checkboxAll{{ $test->id }}" class="custom-control-label"></label>
                                                    </div>
                                                </td>

                                                <td class="py-1">
                                                    {{ ($openai->currentPage() - 1) * $openai->perPage() + $loop->iteration }}
                                                </td>
                                                <td>
                                                    {{ $test->generate }}
                                                </td>
                                                <td>
                                                    {{ $test->prompt }}
                                                </td>
                                                @if ($test->generate == 'Image Generate')
                                                    @if (!empty($test->response))
                                                        <td>
                                                            <div class="ai-generate-image">
                                                                <img src="{{ $test->response }}" class="img-fluid img-circle" alt="{{ __('Image') }}">
                                                                <div class="img-output-icon">
                                                                    <ul>
                                                                        <li><a href="{{ $test->response }}" title="{{ __('Download') }}" download><i class="feather icon-download"></i></a> </li>
                                                                        <li><a href="{{ $test->response }}"  data-lightbox="homePortfolio" title="{{ __('View') }}" target="_blank"><i class="feather icon-eye"></i></a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    @endif
                                                @else
                                                    @php
                                                        $jsonData = $test->response;
                                                        $decodedData = json_decode($jsonData, true);
                                                        $content = $decodedData['content'] ?? '';
                                                        $words = str_word_count($content, 1);
                                                        $limitedContent = implode(' ', array_slice($words, 0, 100));
                                                    @endphp
                                                    <td>{!! nl2br($limitedContent) !!}</td>
                                                @endif
                                                <td>
                                                    <a class="btn btn-sm btn-danger-rgba" href="#" data-toggle="modal" data-target="#exampleModal{{ $test->id }}" title="{{ __('Delete') }}"><i class="feather icon-trash"></i> </a>
                                                 </td>
                                            </tr>
                                            <!-- delete Modal start -->
                                            <div class="modal fade" id="exampleModal{{ $test->id }}" tabindex="-1"
                                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                                {{ __('Are You Sure ?') }}</h1>
                                                            <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <p>{{ __('Do you really want to delete') }} ?{{ __('This process cannot be undone.') }}</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <form method="post" action="{{ route('openai.delete', $test->id) }}" class="pull-right">
                                                                {{ csrf_field() }}
                                                                {{ method_field('DELETE') }}
                                                                <button type="reset" class="btn btn-secondary" title="{{ __('No') }}" data-dismiss="modal">{{ __('No') }}</button>
                                                                <button type="submit" title="{{ __('Yes') }}" class="btn btn-primary">{{ __('Yes') }}</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- delete Model ended -->
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="d-flex justify-content-end">
                                <div class="pagination pagination-circle mb-3">
                                    {{ $openai->links() }}
                                </div>
                            </div>
                            <!-- Table end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--End Contentbar-->
    </div>
    <!-- Bulk Delete Modal start -->
    <div class="modal fade" id="bulk_delete" tabindex="-1" aria-labelledby="bulkDeleteLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="bulkDeleteLabel">{{ __('Delete Selected Records') }}</h1>
                    <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close" 
                    title="{{ __('adminWords.close_modal') }}"
                    ></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('Do you really want to delete the selected records? This action cannot be undone.') }}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" 
                    title="{{ __('no') }}">{{ __('No') }}</button>
                    <form id="bulk_delete_form" method="post" action="{{ route('openai.bulk.delete') }}">
                        @csrf
                        @method('POST')
                        <button type="submit" class="btn btn-primary" 
                        title="{{ __('Yes') }}">{{ __('Yes') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Bulk Delete Modal end -->
@endsection
@section('script')
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>      
@endsection
