@extends('layouts.admin.main')
@section('title', __('adminWords.invoice'))
@section('rightbar-content')

<div class="breadcrumbbar">
    <div class="contentbar">                
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-10 col-xl-10">
                <div class="card m-b-30">
                    @if(!empty($invoiceData))
                        @php
                            if($type == 0 && $invoiceData->status == 2){
                                $cls = 'info_status';
                                $msg = __('adminWords.pending');
                            }elseif($type == 1){
                                $cls = 'success_status';
                                $msg = __('adminWords.success') ;
                            }else{
                                $cls = 'warning_status';
                                $msg = __('adminWords.cancelled');
                            }
                        @endphp
                        <div class="status_msg {{ $cls }}">
                            <p>{{ __('adminWords.payment_status').' : '.$msg}} </p>
                        </div>
                   
                        <div class="card-body">
                            @php
                                if($type == 0){
                                    $getPlan = select(['column' => '*', 'table' => 'plans', 'where' => ['id' => $invoiceData->plan_id], 'limit' => 1]);
                                    $planData = [];
                                }else{
                                    $getPlan = [];
                                    $planData = select(['column' => '*', 'table' => 'user_purchased_plans', 'where' => ['user_id' => $invoiceData->user_id, 'order_id' => $order_id], 'order'=>['id','desc'], 'limit' => 1 ]);
                                }
                                $getUserDetail = select(['column' => 'billing_detail', 'table' => 'users', 'where' => ['id' => $invoiceData->user_id], 'limit' => 1]);
                                $paymentData = json_decode($invoiceData->payment_data)[0];
                            @endphp
                            <div class="invoice">
                                <div class="invoice-head">
                                    <div class="row">
                                        <div class="col-12 col-md-7 col-lg-7">
                                            <h4>{{ isset($settings['w_title']) ? ucfirst($settings['w_title']) : __('adminWords.miraculous') }}</h4>
                                            @if(sizeof($invoice_setting) > 0 && $invoice_setting[0]->invoice_data != '')
                                                @php $detail = json_decode($invoice_setting[0]->invoice_data); @endphp
                                                <p>{{ $detail->address1 }}</p>
                                                <p class="mb-0">{{ $detail->address2 }}</p>
                                            @endif
                                        </div>
                                        <div class="col-12 col-md-5 col-lg-5">
                                            <div class="invoice-name">
                                                <h5 class="text-uppercase mb-3">{{ __('adminWords.invoice') }}</h5>
                                                <p class="mb-1">{{ __('adminWords.number') }} : {{ 'INV'.'-'.$invoiceData->id.'-'.date('Ymd',strtotime($invoiceData->created_at)) }}</p>
                                                <p class="mb-0">{{ date('d F, Y', strtotime($invoiceData->created_at)) }}</p>
                                                <h4 class="text-success mb-0 mt-3">{{ $paymentData->currency.$paymentData->amount }}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div> 
                                <div class="invoice-billing float-left w-100">
                                    <div class="row float-left w-100 d-block">
                                        @if(sizeof($getUserDetail) > 0 && $getUserDetail[0]->billing_detail != '')
                                            @php $billingDetail = json_decode($getUserDetail[0]->billing_detail); @endphp
                                                <div class="invoice-address float-left p-3">
                                                    <h6 class="mb-3">{{ __('frontWords.bill_to') }}</h6>
                                                    <h6 class="text-muted">{{ ucfirst($billingDetail->billing_name) }}</h6>
                                                    <ul class="list-unstyled">
                                                        <li>{{ $billingDetail->billing_address }}</li>  
                                                        <li>{{ $billingDetail->billing_contact }}</li>  
                                                        <li>{{ $billingDetail->billing_email }}</li>  
                                                    </ul>
                                                </div>
                                        @endif
                                        
                                            <div class="invoice-address float-right">
                                                <div class="card">
                                                    <div class="card-body bg-info-rgba text-center">
                                                        <h6>{{ __('adminWords.payment_method') }}</h6>
                                                        <p><img src="{{ asset('assets/images/Payment/'.ucfirst($paymentData->payment_gateway).'.png') }}" alt="{{ __('Payment')}}"></p>
                                                        @php
                                                            $exp = explode('_',$paymentData->payment_gateway);

                                                        @endphp
                                                        <p>{{ __('adminWords.via') }} {{ucfirst($exp[0]).(isset($exp[1]) ? ' '.$exp[1] : '' )}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                </div>  
                                <div class="invoice-summary">
                                    <div class="table-responsive ">
                                        <table class="table table-borderless">
                                            <thead>
                                                <tr>
                                                    <th scope="col">{{ __('adminWords.id') }}</th>                       
                                                    <th scope="col">{{ __('adminWords.image') }}</th>
                                                    <th scope="col">{{ __('adminWords.plan') }}</th>
                                                    <th scope="col">{{ __('adminWords.quantity') }}</th>
                                                    <th scope="col">{{ __('adminWords.price') }}</th>
                                                    <th scope="col" class="text-right">{{ __('adminWords.txn_date') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    if(sizeof($planData) > 0){
                                                        $planDetail = json_decode($planData[0]->plan_data);
                                                        $paymentData = json_decode($planData[0]->payment_data);
                                                @endphp
                                                    <tr>
                                                        <th scope="row">1</th>
                                                        <td><img src="{{ asset('images/plan/'.$planDetail->image) }}" class="img-fluid" width="35" alt="{{ $planDetail->plan_name }}"></td>
                                                        <td>{{ $planDetail->plan_name }}</td>
                                                        <td>1</td> 
                                                        <td>{{ $planData[0]->currency.$paymentData[0]->amount }}</td>
                                                        <td class="text-right">{{ date('d F, Y @ h:i A', strtotime($planData[0]->created_at)) }}</td>
                                                    </tr>
                                                @php
                                                    }else if(sizeof($getPlan) > 0){
                                                        $plan_detail = json_decode($invoiceData->payment_data);
                                                @endphp
                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td><img src="{{ asset('images/plan/'.$getPlan[0]->image) }}" class="img-fluid" width="35" alt="{{ $getPlan[0]->plan_name }}"></td>
                                                            <td>{{ $getPlan[0]->plan_name }}</td>
                                                            <td>1</td> 
                                                            <td>{{ $plan_detail[0]->currency.$plan_detail[0]->amount }}</td>
                                                            <td class="text-right">{{ date('d F, Y @ h:i A', strtotime($invoiceData->created_at)) }}</td>
                                                        </tr>
                                                @php }
                                                @endphp                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="invoice-summary-total w-100 float-left">
                                    <div class="row w-100 float-left d-block">
                                        <div class="float-right w-50">
                                            <div class="order-total table-responsive ">
                                                <table class="table table-borderless text-right">
                                                    <tbody>
                                                        @if(sizeof($planData) > 0 || sizeof($getPlan) > 0)
                                                            @php if(sizeof($planData) > 0 ){
                                                                    $payment_data = json_decode($planData[0]->payment_data);
                                                                }else{
                                                                    $payment_data = json_decode($invoiceData->payment_data);
                                                                }
                                                            @endphp
                                                            <tr>
                                                                <td>{{ __('adminWords.total_price') }} :</td>
                                                                <td>{{ ((sizeof($planData) > 0) ? $planData[0]->currency : $payment_data[0]->currency).$payment_data[0]->plan_exact_amount }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>{{ __('adminWords.total_tax') }} ({{ $payment_data[0]->taxPercent }}%) :</td>
                                                                <td>{{ '+ '.((sizeof($planData) > 0) ? $planData[0]->currency : $payment_data[0]->currency).$payment_data[0]->taxAmount }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>{{ __('adminWords.coupon_discount') }} :</td>
                                                                <td>{{ '- '.((sizeof($planData) > 0) ? $planData[0]->currency : $payment_data[0]->currency).$payment_data[0]->discount }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td class="f-w-7 font-18"><h5>{{ __('adminWords.payable_amnt') }} :</h5></td>
                                                                <td class="f-w-7 font-18"><h5>{{ ((sizeof($planData) > 0) ? $planData[0]->currency : $payment_data[0]->currency).$payment_data[0]->amount }}</h5></td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if(sizeof($invoice_setting) > 0)
                                    <div class="invoice-meta w-100 float-left">
                                        <div class="row">
                                                @if($invoice_setting[0]->invoice_data != '')
                                                    @php 
                                                        $detail = json_decode($invoice_setting[0]->invoice_data);
                                                        $terms = explode(',', $detail->terms);
                                                    @endphp
                                                
                                                    <div class="col-sm-6 col-md-4 col-lg-4">
                                                        <div class="invoice-meta-box">
                                                            <h6 class="mb-3">Terms & Conditions</h6>
                                                            <ul class="pl-3">
                                                                @for($i=0; $i < sizeof($terms); $i++)
                                                                    <li>{{ $terms[$i] }}</li>
                                                                @endfor
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-4 col-lg-4">
                                                        <div class="invoice-meta-box">
                                                            <h6 class="mb-3">{{ __('frontWords.contact_us') }}</h6>
                                                            <ul class="list-unstyled">
                                                                <li><i class="feather icon-aperture mr-2"></i>{{ $detail->website_link }}</li>  
                                                                <li><i class="feather icon-mail mr-2"></i>{{ $detail->email }}</li>  
                                                                <li><i class="feather icon-phone mr-2"></i>{{ $detail->contact_number }}</li>  
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 col-md-4 col-lg-4">
                                                        <div class="invoice-meta-box text-right">
                                                            <h6 class="mb-0">{{ __('adminWords.authorize_signature') }}</h6>
                                                            <img src="{{ asset('images/sites/'.$detail->author_sign) }}" class="img-fluid my-3 signature" alt="{{ __('Author Sign')}}">
                                                            <p class="mb-0">{{ $detail->author_name }}</p>
                                                        </div>
                                                    </div>
                                                @endif
                                        </div>
                                    </div> 
                                @endif
                                <div class="invoice-footer w-100 float-left">
                                    <div class="row align-items-center">
                                        <div class="col-md-6">
                                            <div class="invoice-footer-btn">
                                                <a href="javascript:window.print()" class="btn btn-primary-rgba py-1 font-16"><i class="feather icon-printer mr-2" title=" {{ __('adminWords.print') }}"></i>{{ __('adminWords.print') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>                                   
                            </div>
                        
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>   
</div>

@endsection
