@section('title', __('adminWords.dashboard'))
@extends('layouts.admin.main') 

@section('rightbar-content')
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.dashboard')}}">{{ __('adminWords.dashboard') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>    

<div class="contentbar">              
    <div class="row">
        <div class="col-lg-12 col-xl-12">
            <div class="row">
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <img src="{{ asset('assets/images/svg-icon/d_users.svg') }}" width="40" height="40" alt="{{ __('Dashboard Image')}}"/>
                                         {{ $countUser }} </h4>
                                    <a href="{{ url('users') }}" target="_blank" class="mb-0" title="{{ __('adminWords.total_user')}}">{{ __('adminWords.total_user') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="#F9616D" width="40px" height="40px"><path d="m352 256c0-52.933594-43.066406-96-96-96s-96 43.066406-96 96 43.066406 96 96 96 96-43.066406 96-96zm-96 56c-30.878906 0-56-25.121094-56-56s25.121094-56 56-56 56 25.121094 56 56-25.121094 56-56 56zm-140-56c0 22.785156 5.296875 44.511719 15.738281 64.5625 5.101563 9.796875 1.296875 21.875-8.5 26.976562-2.953125 1.539063-6.109375 2.265626-9.222656 2.265626-7.21875 0-14.1875-3.917969-17.753906-10.765626-13.253907-25.453124-20.261719-54.167968-20.261719-83.039062 0-11.046875 8.953125-20 20-20s20 8.953125 20 20zm30.464844 118.328125c6.445312-8.96875 18.941406-11.015625 27.914062-4.566406 2.640625 1.898437 5.378906 3.726562 8.136719 5.429687 9.394531 5.804688 12.304687 18.128906 6.496094 27.527344-3.78125 6.117188-10.328125 9.484375-17.03125 9.484375-3.585938 0-7.21875-.964844-10.496094-2.988281-3.539063-2.1875-7.054687-4.535156-10.449219-6.972656-8.96875-6.445313-11.015625-18.941407-4.570312-27.914063zm99.375 118.300781c-1.28125 10.101563-9.890625 17.484375-19.816406 17.484375-.835938 0-1.6875-.054687-2.539063-.160156-127.40625-16.164063-223.484375-125.339844-223.484375-253.953125 0-68.378906 26.628906-132.667969 74.980469-181.019531 48.351562-48.351563 112.640625-74.980469 181.019531-74.980469 85.460938 0 164.886719 42.179688 212.472656 112.828125 6.167969 9.160156 3.746094 21.589844-5.417968 27.761719-9.160157 6.171875-21.589844 3.746094-27.761719-5.417969-40.136719-59.59375-107.160157-95.171875-179.292969-95.171875-119.101562 0-216 96.898438-216 216 0 108.519531 81.046875 200.636719 188.515625 214.269531 10.960937 1.390625 18.714844 11.402344 17.324219 22.359375zm30.160156-236.628906c0 11.046875-8.953125 20-20 20s-20-8.953125-20-20 8.953125-20 20-20 20 8.953125 20 20zm228.574219-74.582031c-4.695313-3.796875-10.851563-5.265625-16.761719-4.003907l-74.527344 15.953126c-21.027344 4.390624-36.285156 23.152343-36.285156 44.636718v140.765625c-9.097656-4.335937-19.269531-6.769531-30-6.769531-38.597656 0-70 31.402344-70 70s31.402344 70 70 70c38.15625 0 69.257812-30.691406 69.964844-68.679688.007812-.222656.035156-.4375.035156-.664062v-128.226562l55.402344-11.875c22.945312-4.882813 39.597656-25.449219 39.597656-48.90625v-56.675782c0-6.039062-2.730469-11.757812-7.425781-15.554687zm-157.574219 290.582031c-16.542969 0-30-13.457031-30-30s13.457031-30 30-30 30 13.457031 30 30-13.457031 30-30 30zm125-218.351562c0 4.691406-3.332031 8.804687-7.949219 9.785156l-47.050781 10.085937v-35.515625c0-2.640625 1.878906-4.945312 4.464844-5.480468.042968-.007813.085937-.019532.132812-.027344l50.402344-10.789063zm0 0"/></svg>
                                         {{ $countAudio }} </h4>
                                        <a href="{{ url('audio') }}" target="_blank" class="mb-0" 
                                        title="{{ __('adminWords.total.song') }}"
                                        >{{ __('adminWords.total_song') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="40px" height="40px"><g id="outline"><path fill="#3D9BFB" d="M80.77,444.083a67.525,67.525,0,0,0,47.23,19.9V464a8,8,0,0,0,8,8H280a8,8,0,0,0,8-8V331.15a27.225,27.225,0,0,0,34.327-19.473,121.823,121.823,0,0,0,2.424-46.989l-2.58-18.058,16.98-7.277a8,8,0,0,0,4.16-10.6l-11.734-26.4,39.836-39.462,22.4-8.4a8,8,0,0,0,2.96-1.949l49-51a8,8,0,0,0-.343-11.42l-39-36a8,8,0,0,0-11.248.392l-49,52a7.986,7.986,0,0,0-1.767,2.956l-7.381,22.143-25.8,24.973a8,8,0,0,0-4.7-4.175S256.839,136,256,136V114.315l17.1-25.654a31.3,31.3,0,0,0-52.082-34.722l-1.3,1.955h-18.66a42.118,42.118,0,0,0-36.116,63.787l9.851,16.418a7.964,7.964,0,0,0-1.324.312l-48,16a8,8,0,0,0-3.98,2.939l-40,56L49.413,256.258A37.482,37.482,0,0,0,59.892,309.75a67.561,67.561,0,0,0-23.749,44.521l-.91,8.185a67.671,67.671,0,0,0,19.5,55.592ZM320,230.153V215.7l5.4,12.143Zm29.563-88.4a7.99,7.99,0,0,0,2.026-3.219l7.443-22.327,42.36-44.954,27.185,25.094-42.087,43.8-22.3,8.362a8.017,8.017,0,0,0-2.821,1.807l-36.743,36.4-6.473-14.566ZM272,456H168.054a67.862,67.862,0,0,0,30.716-33.846L208,400h64Zm0-72H214.666l.7-1.681a29.505,29.505,0,0,1,22.511-17.855A45.808,45.808,0,0,0,272,338.578Zm-7.129-160.282,6.357,15.893L208.14,302.105l-13.668-10.251ZM181.51,282.133a20.076,20.076,0,0,0-3.775-1.943l-24.547-5.455a45.529,45.529,0,0,0,3.823-8.471l1.917-5.751A29.963,29.963,0,0,1,187.389,240h4.871a29.8,29.8,0,0,1,21.213,8.787l1.225,1.225Zm87.371-17.676-1.933,15.463c-.866-1.037-1.764-2.05-2.726-3.012l-3.937-3.936ZM304,209.3s.027,23.459.081,23.833l4.831,33.82a105.9,105.9,0,0,1-2.107,40.845,11.266,11.266,0,0,1-19.636,4.423,8.041,8.041,0,0,0-1.432-2.035l-3.1-4.655a11.276,11.276,0,0,1-1.807-7.651l7.111-56.886a7.994,7.994,0,0,0-.51-3.963l-12.086-30.214-.023-.059-.92-2.3,16.115-6.446.056-.023,8.524-3.409ZM180.165,82.341a26.241,26.241,0,0,1,20.894-10.447H224a8,8,0,0,0,6.656-3.563l3.678-5.517a15.3,15.3,0,0,1,25.457,16.972l-16.072,24.108H208a8,8,0,0,0-5.657,2.343l-16.755,16.754-6.925-11.542A26.017,26.017,0,0,1,180.165,82.341ZM240,119.894V144a24,24,0,0,1-48,0v-4.793l19.314-19.313ZM133,166.767l43.84-14.614a40,40,0,0,0,78.324,0l42.961,14.321.868,1.954L283.214,183.7l-22.185,8.874a8,8,0,0,0-4.457,10.4l1.878,4.695L226.2,238.883l-1.409-1.41A45.7,45.7,0,0,0,192.26,224h-4.871A45.934,45.934,0,0,0,144,254.749V224a8,8,0,0,0-14.656-4.438l-10.587,15.881L98.449,215.135Zm-5,83.655v18.716l-10.867-2.415ZM59.067,283.284a21.486,21.486,0,0,1,3.366-17.726l26.588-37.224,20.685,20.685L97.344,267.562a8,8,0,0,0,4.921,12.248l70.315,15.625,24.566,18.424-10.28,15.419-15.6,5.2-12.611-18.916a8,8,0,0,0-5.341-3.453L76.406,299.291A21.514,21.514,0,0,1,59.067,283.284Zm89.577,77.758L136,348.451l15.413-14.918,9.936,14.9.01.013Zm3.442,25.945-8.207,8.511L99.171,350.906l8.007-8.447ZM51.136,364.222l.909-8.184a51.636,51.636,0,0,1,27.117-40.067l57.487,9.581-12.043,11.656-11.973-11.872a8,8,0,0,0-11.439.178l-19,20.046a8,8,0,0,0,.157,11.168l55.99,55.843a8,8,0,0,0,5.65,2.336h.078a8,8,0,0,0,5.681-2.447l19.33-20.046a8,8,0,0,0-.126-11.234l-8.948-8.872,26.185-25.939,8.339-2.78a8,8,0,0,0,4.126-3.151l12.6-18.894,37.666-37.312,3.99,3.99a30.145,30.145,0,0,1,8.486,25.456l-1.38,9.655a29.892,29.892,0,0,1-24.766,25.349A45.418,45.418,0,0,0,200.6,376.166L184,416a51.864,51.864,0,0,1-48,32h-7.147a51.663,51.663,0,0,1-36.77-15.23L66.048,406.734A51.745,51.745,0,0,1,51.136,364.222Z"/></g></svg>
                                        {{ $countArtist }} </h4>
                                        <a href="{{ url('artist') }}" target="_blank" class="mb-0" 
                                        title="{{ __('adminWords.total_artish') }}"
                                        >
                                            {{ __('adminWords.total_artist') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
               
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <svg xmlns="http://www.w3.org/2000/svg" height="40" viewBox="0 0 512 512" width="40"><path fill="#F7BB4D" d="m339.320312 303.519531-135-90c-4.601562-3.070312-10.519531-3.355469-15.398437-.746093-4.875 2.613281-7.921875 7.695312-7.921875 13.226562v180c0 5.53125 3.046875 10.613281 7.921875 13.226562 4.878906 2.609376 10.796875 2.324219 15.398437-.746093l135-90c4.171876-2.78125 6.679688-7.464844 6.679688-12.480469s-2.507812-9.699219-6.679688-12.480469zm-128.320312 74.453125v-123.945312l92.957031 61.972656zm0 0"/><path fill="#F7BB4D" d="m497 121h-15v-45c0-8.285156-6.714844-15-15-15h-15v-46c0-8.285156-6.714844-15-15-15h-362c-8.285156 0-15 6.714844-15 15v46h-15c-8.285156 0-15 6.714844-15 15v45h-15c-8.285156 0-15 6.714844-15 15v361c0 8.285156 6.714844 15 15 15h482c8.285156 0 15-6.714844 15-15v-361c0-8.285156-6.714844-15-15-15zm-407-91h332v31h-332zm-30 61h392v30h-392zm422 391h-452v-331h452zm0 0"/></svg>
                                        {{ $countAlbum }} </h4>
                                        <a href="{{ url('album') }}" target="_blank" class="mb-0" 
                                        title="{{ __('adminWords.totla_album') }}"
                                        >
                                            {{ __('adminWords.total_album') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 262.048 262.048" width="40" height="40" fill="#A0616A">
                                            <g>
                                                <path d="M237.498,77.304H56.649l148.676-62.895c3.815-1.613,5.6-6.015,3.985-9.829   c-1.614-3.816-6.02-5.6-9.829-3.985L17.672,77.506c-1.066,0.451-1.968,1.126-2.687,1.938C7.349,83.046,2.05,90.817,2.05,99.804   v139.744c0,12.406,10.094,22.5,22.5,22.5h212.947c12.406,0,22.5-10.094,22.5-22.5V99.804   C259.998,87.398,249.904,77.304,237.498,77.304z M244.998,239.548c0,4.136-3.364,7.5-7.5,7.5H24.55c-4.136,0-7.5-3.364-7.5-7.5   V99.804c0-4.136,3.364-7.5,7.5-7.5h212.947c4.136,0,7.5,3.364,7.5,7.5V239.548z"/>
                                                <path d="M79.503,116.59c-27.62,0-50.091,22.471-50.091,50.09c0,27.619,22.471,50.089,50.091,50.089   s50.09-22.47,50.09-50.089C129.592,139.061,107.123,116.59,79.503,116.59z M79.503,201.769c-19.35,0-35.091-15.741-35.091-35.089   c0-19.349,15.741-35.09,35.091-35.09c19.349,0,35.09,15.741,35.09,35.09C114.592,186.028,98.851,201.769,79.503,201.769z"/>
                                                <path d="M220.123,162.138c5.514,0,10-4.486,10-10v-28.14c0-5.514-4.486-10-10-10h-68.188   c-5.514,0-10,4.486-10,10v28.14c0,5.514,4.486,10,10,10H220.123z M220.124,152.138l-0.001,5v-5H220.124z M151.934,123.998h68.188   l-0.015,28.14h-68.174V123.998z"/>
                                                <path d="M159.885,176.264h-6.197c-4.143,0-7.5,3.357-7.5,7.5c0,4.143,3.357,7.5,7.5,7.5h6.197   c4.143,0,7.5-3.357,7.5-7.5C167.385,179.621,164.028,176.264,159.885,176.264z"/>
                                                <path d="M191.829,176.264h-6.198c-4.143,0-7.5,3.357-7.5,7.5c0,4.143,3.357,7.5,7.5,7.5h6.198   c4.143,0,7.5-3.357,7.5-7.5C199.329,179.621,195.971,176.264,191.829,176.264z"/>
                                                <path d="M223.771,176.264h-6.197c-4.143,0-7.5,3.357-7.5,7.5c0,4.143,3.357,7.5,7.5,7.5h6.197   c4.143,0,7.5-3.357,7.5-7.5C231.271,179.621,227.914,176.264,223.771,176.264z"/>
                                                <path d="M159.885,198.508h-6.197c-4.143,0-7.5,3.357-7.5,7.5c0,4.142,3.357,7.5,7.5,7.5h6.197   c4.143,0,7.5-3.358,7.5-7.5C167.385,201.866,164.028,198.508,159.885,198.508z"/>
                                                <path d="M191.829,198.508h-6.198c-4.143,0-7.5,3.357-7.5,7.5c0,4.142,3.357,7.5,7.5,7.5h6.198   c4.143,0,7.5-3.358,7.5-7.5C199.329,201.866,195.971,198.508,191.829,198.508z"/>
                                                <path d="M223.771,198.508h-6.197c-4.143,0-7.5,3.357-7.5,7.5c0,4.142,3.357,7.5,7.5,7.5h6.197   c4.143,0,7.5-3.358,7.5-7.5C231.271,201.866,227.914,198.508,223.771,198.508z"/>
                                            </g>
                                            </svg>
                                        {{ $countRadio }} </h4>
                                        <a href="{{ url('radio') }}" target="_blank" class="mb-0" 
                                        title="{{ __('adminWords.total_ratio') }}"
                                        >{{ __('adminWords.total_radio') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
               
                <div class="mobile_col col-lg-3">
                    <div class="card m-b-30">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <h4 class="box_font">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 480 480" width="40px" height="40px" fill="#506ee4">
                                            <rect x="144" y="264" width="16" height="16"/><rect x="144" y="296" width="16" height="16"/><rect x="144" y="328" width="16" height="16"/><rect x="144" y="232" width="16" height="16"/><rect x="144" y="200" width="16" height="16"/><rect x="144" y="168" width="16" height="16"/><rect x="144" y="136" width="16" height="16"/><rect x="32" y="136" width="16" height="16"/><rect x="432" y="136" width="16" height="16"/><rect x="432" y="328" width="16" height="16"/><rect x="32" y="328" width="16" height="16"/>
                                            <path d="M472,200c4.418,0,8-3.582,8-8v-80c0-4.418-3.582-8-8-8H8c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8    c22.091,0,40,17.909,40,40s-17.909,40-40,40c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8h464c4.418,0,8-3.582,8-8v-80    c0-4.418-3.582-8-8-8c-22.091,0-40-17.909-40-40S449.909,200,472,200z M416.524,247.956c3.532,24.61,22.867,43.944,47.476,47.476    V360H16v-64.568c30.614-4.394,51.87-32.773,47.476-63.388C59.944,207.435,40.61,188.1,16,184.568V120h448v64.568    C433.386,188.962,412.13,217.341,416.524,247.956z"/>
                                            <path d="M240,160c-17.673,0-32,14.327-32,32s14.327,32,32,32c17.673,0,32-14.327,32-32S257.673,160,240,160z M240,208    c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S248.837,208,240,208z"/>
                                            <path d="M336,256c-17.673,0-32,14.327-32,32c0,17.673,14.327,32,32,32c17.673,0,32-14.327,32-32C368,270.327,353.673,256,336,256z     M336,304c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S344.837,304,336,304z"/>
                                            <rect x="197.494" y="231.982" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -85.3385 273.9377)" width="181.017" height="16"/>
                                        </svg>
                                        {{ $countCoupon }} </h4>
                                        <a href="{{ url('coupon_management') }}" target="_blank" class="mb-0" 
                                        title="{{ __('adminWords.total_coupon') }}"
                                         >
                                            {{ __('adminWords.total_coupon') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        @if(isset($settings['latest_subs']) && $settings['latest_subs'] == 1)
            <div class="col-lg-12 col-xl-12">
                <div class="card m-b-30">
                    <div class="card-header bg-primary">   
                        <div class="col-9">
                            <h5 class="card-title mb-0">{{ __('adminWords.latest_subs') }}</h5>
                        </div> 
                    </div>
                    <div class="card-body ">
                        <div class="row align-items-center">
                            
                            <div class="table-responsive mt-2 p-3">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>{{ __('adminWords.txn_id') }}</th>
                                            <th>{{ __('adminWords.customer_name') }}</th>
                                            <th>{{ __('adminWords.quantity') }}</th>
                                            <th>{{ __('adminWords.payment_method') }}</th>
                                            <th>{{ __('adminWords.total_price') }}</th>
                                            <th>{{ __('adminWords.txn_date') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(sizeof($recent_subscription) > 0)
                                            @foreach($recent_subscription as $subscription)
                                                @php
                                                   $getUser =  select(['column' => 'name', 'table' => 'users', 'where' => ['id' => $subscription->user_id]]);    
                                                   $getPlan = select(['column' => 'plan_name', 'table' => 'plans', 'where' => ['id' => $subscription->plan_id]]); 
                                                   $subs = json_decode($subscription->payment_data)[0];
                                                   $arr = [];
                                                   if(strpos($subs->payment_gateway, '_') != ''){
                                                       $arr = explode('_', $subs->payment_gateway);
                                                   }
                                                @endphp
                                                <tr>
                                                    <td>#</td>
                                                    <td><a href="{{ url('user/invoice/'.$subscription->id.'/'.$subs->order_id.'/1') }}" target="_blank">{{ $subs->order_id }}</a></td>
                                                    <td>{{ $getUser[0]->name }}</td>
                                                    <td>1</td>
                                                    <td>{{ !empty($arr) ? ucfirst($arr[0]).' '.ucfirst($arr[1]) : $subs->payment_gateway }}</td>
                                                    <td>{{ $subs->currency.$subs->amount }}</td>
                                                    <td>{{ date('d-m-Y', strtotime($subscription->created_at)) }}</td>
                                                </tr>
                                            @endforeach
                                            @else   
                                                <td colspan="6" class="text-center">{{ __('adminWords.no_data') }}</td>
                                        @endif                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="{{ url('subscription') }}" class="link-text" target="_blank" 
                        title="{{ __('adminWords.view_all').' '.__('adminWords.subscription') }}"
                        ><i class="fa fa-eye"></i> {{ __('adminWords.view_all').' '.__('adminWords.subscription') }}</a>
                    </div>
                </div>
            </div>
        @endif
    </div>
    
    <div class="col-lg-12 col-xl-12">
        <div class="card m-b-30">
            <div class="card-header">   
                <div class="col-9">
                    <h5 class="card-title mb-0">{{ __('adminWords.monthly_subs').date('Y') }}</h5>
                </div> 
            </div>
            <div class="card-body">
                <canvas id="subscriptionChart"></canvas>
                <input type="hidden" id="subsMonthCount" value="{{ json_encode($subsMonthCount) }}" data-label="{{ __('adminWords.monthly_subs').date('Y') }}">
            </div>
        </div>
    </div>

    <div class="row dashboard_box" >
        @if(isset($settings['rcnt_add_track']) && $settings['rcnt_add_track'] == 1)
            <div class="col-lg-12 col-xl-4">
                <div class="card m-b-30">
                    <div class="card-header bg-primary">                                
                        <div class="row align-items-center">
                            <div class="col-9">
                                <h5 class="card-title mb-0">{{ __('adminWords.recently_song') }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-borderless">                                        
                                <tbody>
                                    @if(sizeof($recent_track) > 0)
                                        @foreach($recent_track as $track)
                                            <tr>
                                                <td>
                                                    <span class="mr-3 action-icon badge badge-primary-inverse">
                                                        <img src="{{ asset('images/audio/thumb/'.$track->image) }}" alt="{{ __('Thumbail Image')}}" />
                                                    </span>
                                                </td>
                                                <td>
                                                    <h5 class="mt-0 mb-1 font-16">{{ $track->audio_title }}</h5>
                                                    <p class="mb-0 font-14">
                                                        @php
                                                            if($track->description != ''){
                                                                echo strlen($track->description) > 100 ? substr($track->description,0,100).'...<a href="'.url('audio/single/'.$track->id.'/'.$track->audio_slug).'">'.__('adminWords.read_more').'</a>' : substr($track->description,0,100);
                                                            }
                                                        @endphp
                                                    </p>
                                                </td>
                                                <td>
                                                    <a href="javascript:;" class="float-right btn btn-primary-rgba font-14" title="{{ date('d M Y', strtotime($track->created_at)) }}">
                                                        {{ date('d M Y', strtotime($track->created_at)) }}</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        @else
                                            <p>{{ __('frontWords.no_track') }}</p>
                                    @endif
                                                
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <a href="{{ url('audio') }}" class="link-text" target="_blank" title="{{ __('adminWords.view_all').' '.__('adminWords.audio') }}"><i class="fa fa-eye"></i> {{ __('adminWords.view_all').' '.__('adminWords.audio') }}</a>
                    </div>
                </div>
            </div>
        @endif
        @if(isset($settings['rcnt_add_user']) && $settings['rcnt_add_user'] == 1)
            <div class="col-lg-12 col-xl-4">
                <div class="card m-b-30">
                    <div class="card-header bg-primary">                                
                        <div class="row align-items-center">
                            <div class="col-9">
                                <h5 class="card-title mb-0">{{ __('adminWords.recent_users') }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center">
                            @if(sizeof($recent_users) > 0)
                                @foreach($recent_users as $users)
                                    <div class="col-lg-3">
                                        <div class="center_box mb-3">
                                            <img src="{{ Avatar::create($users->name)->toBase64() }}" alt="{{ __('Avatar Image')}}"/>
                                            <p class="font-13">{{ date('m-d-Y', strtotime($users->created_at)) }}</p>
                                        </div>
                                    </div>
                                @endforeach
                                @else
                                    <p>{{ __('frontWords.no_user') }}</p>
                            @endif
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <a href="{{ url('users') }}" class="link-text" target="_blank" title="{{ __('adminWords.view_all')}}"><i class="fa fa-eye"></i>{{ __('adminWords.view_all').' '.__('adminWords.users') }}</a>
                    </div>
                </div>
            </div>
        @endif
        @if(isset($settings['rcnt_add_album']) && $settings['rcnt_add_album'] == 1)
            <div class="col-lg-12 col-xl-4">
                <div class="card m-b-30">
                    <div class="card-header bg-primary">                                
                        <div class="row align-items-center">
                            <div class="col-9">
                                <h5 class="card-title mb-0">{{ __('adminWords.recent_alums') }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-borderless">                                        
                                <tbody>
                                    @if(sizeof($recent_album) > 0)
                                        @foreach($recent_album as $album)
                                            <tr>
                                                <td>
                                                    <span class="mr-3 action-icon badge badge-primary-inverse">
                                                        <img src="{{ asset('images/album/'.$album->image) }}" alt="{{ __('Album Image')}}"/>
                                                    </span>
                                                </td>
                                                <td>
                                                    <h5 class="mt-0 mb-1 font-16">{{ $album->album_name }}</h5>
                                                    <p class="mb-0 font-14">
                                                        @php
                                                            if($album->description != ''){
                                                                echo strlen($album->description) > 100 ? substr($album->description,0,100).'...<a href="'.url('album/single/'.$album->id.'/'.$album->album_slug).'">'.__('adminWords.read_more').'</a>' : substr($album->description,0,100);
                                                            }
                                                        @endphp
                                                    </p>
                                                </td>
                                                <td>
                                                    <a href="javascript:;" class="float-right btn btn-primary-rgba font-14" title="{{ __('Date')}}">{{ date('d M Y', strtotime($album->created_at)) }}</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        @else
                                            <p>{{ __('frontWords.no_album') }}</p>
                                    @endif                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="{{ url('album') }}" class="link-text" target="_blank" title="{{ __('Album')}}"><i class="fa fa-eye"></i> {{ __('adminWords.view_all').' '.__('adminWords.album') }}</a>
                    </div>
                </div>
            </div>
        @endif
        <input type="hidden" id="userMonthCount" value="{{ json_encode($userMonthCount) }}" data-label="{{ __('adminWords.monthly_user').date('Y') }}">
    </div>

    <div class="col-lg-12 col-xl-12">
        <div class="card m-b-30">
            <div class="card-header">   
                <div class="col-9">
                    <h5 class="card-title mb-0">{{ __('adminWords.monthly_user').date('Y') }}</h5>
                </div> 
            </div>
            <div class="card-body">
                <canvas id="userChart"></canvas>
            </div>
        </div>
    </div>
</div>
</div>
@endsection 

@section('script')
    <script src="{{ asset('assets/plugins/chart-js/chart.min.js') }}"></script>
    <script src="{{ asset('assets/js/dashboard.js') }}"></script>
@endsection
