@extends('layouts.admin.main')
@section('title', __('Api Setting'))
@section('style')
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('Api Key Settings') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#"
                                title="{{ __('Api Key Settings') }}">{{ __('Api Key Settings') }}</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="admin-form">
                            <form action="{{ route('openapikey.store') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="faq-block">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="openapikey" class="form-label">{{ __('Open API Key (ChatGPT)') }}<span class="required"> *</span></label>
                                                <input class="form-control" type="password" name="openapikey" placeholder="{{ __('Enter Your Open API Key (ChatGPT)') }}"aria-label="openapikey" id="openapikey" value="{{ $openapikey }}">
                                                <div class="form-control-icon"><i class="flaticon-key"></i></div>
                                            </div>
                                        </div>
                            
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="status" class="form-label">{{ __('Status') }}</label>
                                                <div class="switch-main-block">
                                                    <input class="js-switch-primary" type="checkbox" role="switch"  id="status" name="gpt_toggle" value="1" {{ $apisetting->gpt_toggle == 1 ? 'checked' : '' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Button trigger modal -->
                                    <button type="submit" class="btn btn-primary mt-3"  title="{{ __('Click to Update') }}"> <i class="flaticon-upload-1"></i>{{ __('Submit') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
