<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class User extends Authenticatable
{
    use Notifiable;
    use HasFactory;

    
    protected $guarded = [];

   
    protected $hidden = [
        'password', 'remember_token',
    ];

    
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    function country(){
        $this->belongsTo('\Modules\Location\Entities\AllCountry','country_id');
    }

    function state(){
        $this->belongsTo('\Modules\Location\Entities\AllState','state_id');
    }

    function city(){
        $this->belongsTo('\Moduels\Location\Entities\AllCity', 'city_id');
    }

    public function authentications()
    {
        return $this->hasMany(Authentication::class);
    }
    
    public function notifyAuthenticationLogVia() {
      
    }
}
