<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Modules\Setting\Entities\Settings;
use Modules\Language\Entities\Language;
use App\Playlist;
use Auth;
use App\User;
use App\UserPurchasedPlan;
use Modules\Plan\Entities\Plan;
use Modules\Setting\Entities\Currency;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(){
        
        Schema::defaultStringLength(191);
        view()->composer('*', function($view){
            $dc = Settings::where('name', 'default_currency_id')->first();
            $defaultCurrency = [];
            if(!empty($dc)){
                $defaultCurrency = Currency::where('id',$dc->value)->first();
            }
            $settings = Settings::pluck('value','name');
            if(!empty($settings)){
                $title = '';
                if(isset($settings['w_title'])){
                    $title = $settings['w_title'];
                    if(isset($settings['meta_desc'])){
                        $title .= '-'.$settings['meta_desc'];
                    }
                }else{
                    $title = 'Miraculous-Dream your moments';
                }
            }
            $language = Language::where('status',1)->pluck('language_name','id')->all();
            $playlist = Playlist::orderBy('id','desc')->get();
            $planDetail = [];
            if(isset(Auth::user()->id)){
                $planData = UserPurchasedPlan::where([ ['expiry_date', '>=', date('Y-m-d')] ])->orderBy('id', 'desc')->limit(1)->get();
                if(sizeof($planData) == 0){ /// free plan
                    $getplans = Plan::where('plan_amount' , 0)->orderBy('id', 'desc')->limit(1)->get();
                    if(sizeof($getplans) > 0){
                        $planDetail = $getplans[0];
                    }
                }else{
                    $planDetail = json_decode($planData[0]->plan_data);
                }
            }
            
            $view->with(['settings' => $settings, 'language'=>$language, 'defaultCurrency' => $defaultCurrency, 'playlist'=>$playlist, 'userPlan' => $planDetail, 'title' => $title]);
        });
    }
}
