<?php

namespace App\Http\Controllers;

use App\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Laracasts\Flash\Flash;

class ServiceController extends Controller
{
    public function index()
    {
        $services = Service::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.serviceai.index', compact('services'));
    }


    public function create()
    {
        return view('admin.serviceai.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);

        $services = new Service;
        $services->name = $request->input('name');
        $services->status = $request->input('status') ? 1 : 0;
        $services->save();
        Flash::success('Service created successfully.');

        return redirect()->route('services.index');
    }

    public function edit($id)
    {
        $service = Service::findOrFail($id);
        return view('admin.serviceai.edit', compact('service'));
    }

    public function update(Request $request,$id)
    {
        $services = Service::find($id);
        $services->name = $request->input('name');
        $services->status = $request->input('status') ? 1 : 0;
        $services->save();
        Flash::success('Service updated successfully.');

        return redirect()->route('services.index');
    }



     public function destroy(string $id)
        {
            $service = Service::find($id);
            $service->delete();
            Flash::success('Service deleted successfully.');

            return redirect()->route('services.index');

        }

    public function bulk_delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'checked' => 'required',
        ]);
        if ($validator->fails()) {
            Flash::error('Atleast one item is required to be checked')->important();

            return back();
        }
        else{
            Service::whereIn('id',$request->checked)->delete();
            Flash::success('Service deleted successfully.');

            return redirect('admin/services');
        }
    }


    public function updateStatus(Request $request)
    {
        $service = Service::find($request->id);
    
        if ($service) {
            $service->status = $request->status;
            $service->save();
    
            return response()->json(['success' => true, 'message' => 'Service status updated successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Service not found.']);
        }
    }
    

    
    // function updateStatus(Request $request, $id){
    //     $checkValidate = validation($request->all(),['status' =>'required']);
    //     if($checkValidate['status'] == 1){
    //         $resp = change_status(['table'=>'servicess', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
    //         echo $resp;
    //     }else{
    //         echo json_encode($checkValidate);
    //     }
    // }
}
