<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Password;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    public function showLinkRequestForm(){
        return view('auth.passwords.email');
    }

    public function sendResetLinkEmail(Request $request){

        $credentials = request()->validate(['email' => 'required|email']);

        try{
            Password::sendResetLink($credentials);
            toastr()->success( 'Reset email link has been sent to email '.$request->email, '', ['timeOut' => 2000, 'progressBar' =>false] );
            return back();
        }catch(\Exception $e){
            toastr()->error( $e->getMessage(), '', ['timeOut' => 2000, 'progressBar' =>false] );
            return back();
        }

       

    }
}
