<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ApiSetting;
use Laracasts\Flash\Flash;
use Illuminate\Support\Facades\Crypt;

class ApiSettingController extends Controller
{

    public function apisetting()
    {
        $apisetting = ApiSetting::first();    
        $openapikey = $apisetting->openapikey;
    
        return view('admin.api-setting.index', compact('apisetting', 'openapikey'));
    }
    
    public function openapikey(Request $request)
    {
        if(config('app.demolock') == 1){
            return back()->with('delete','Disabled in demo');
        }
        $request->validate([
            'openapikey' => 'required',
        ]);
        $openapikey = ApiSetting::firstOrNew();
        $openapikey->openapikey = encrypt($request->input('openapikey'));
        $openapikey->gpt_toggle = $request->input('gpt_toggle') ? 1 : 0;
        $openapikey->save();
        return redirect('api-setting')->with('success', 'Data has been added.');
    }








}
