<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Modules\Audio\Entities\Audio;
use Modules\Artist\Entities\Artist;
use Modules\Album\Entities\Album;
use Modules\Radio\Entities\Radio;
use Modules\Setting\Entities\Settings;
use Modules\General\Entities\invoiceSetting;
use Auth;
use Hash;
use Str;
use Redirect;
use Socialite;
use Session;
use App\SuccessPayment;
use App\paymentGateway;
use Modules\Language\Entities\Language;
use Modules\Coupon\Entities\Coupon;
use Modules\Plan\Entities\Plan;
use App\userPurchasedPlan;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Mail;
use App\Mail\WelcomeMail;
use DB;

class AdminController extends Controller
{
    public function index(){
        $data['countUser'] = User::where(['status' => 1, 'role' => 0])->count();
        $data['countAudio'] = Audio::where('status', 1)->count();
        $data['countArtist'] = Artist::where('status', 1)->count();
        $data['countArtist'] = Artist::where('status', 1)->count();
        $data['countAlbum'] = Album::where('status', 1)->count();
        $data['countRadio'] = Radio::where('status', 1)->count();
        $data['countCoupon'] = Coupon::where('status', 1)->count();
        $getSetting = Settings::pluck('value','name')->all(); 
        if(!empty($getSetting) && isset($getSetting['rcnt_add_track']) && $getSetting['rcnt_add_track'] == 1){
            $data['recent_track'] = Audio::where('status', 1)->orderBy('created_at','desc')->limit($getSetting['max_rcnt_add_track'])->get();
        }else{
            $data['recent_track'] = Audio::where('status', 1)->orderBy('created_at','desc')->limit(10)->get();
        }
        if(!empty($getSetting) && isset($getSetting['rcnt_add_user'])){
            $data['recent_users'] = User::where(['status' => 1, 'role' => 0])->orderBy('created_at','desc')->limit($getSetting['max_rcnt_add_user'])->get();
        }else{
            $data['recent_users'] = User::where(['status' => 1, 'role' => 0])->orderBy('created_at','desc')->limit(10)->get();
        }
        if(!empty($getSetting) && isset($getSetting['rcnt_add_album'])){
            $data['recent_album'] = Album::where('status', 1)->orderBy('created_at','desc')->limit($getSetting['max_rcnt_add_album'])->get();
        }else{
            $data['recent_album'] = Album::where('status', 1)->orderBy('created_at','desc')->limit(10)->get();
        }
        if(!empty($getSetting) && isset($getSetting['latest_subs'])){
            $data['recent_subscription'] = SuccessPayment::orderBy('created_at','desc')->limit($getSetting['max_latest_subs'])->get();
        }else{
            $data['recent_subscription'] = SuccessPayment::orderBy('created_at','desc')->limit(10)->get();
        }
        $userArr = $subsArr = [];
        for($i=1; $i<=date('m'); $i++){
            $userDetail = DB::table('users')->where([['created_at', 'LIKE', '%'.date('Y').'-'.($i<10 ? '0'.$i : $i).'-%'], ['role','=',0]])->count('id');
            $subscriptionDetail = DB::table('success_payments')->where('created_at', 'LIKE', '%'.date('Y').'-'.($i<10 ? '0'.$i : $i).'-%')->count('id');
            array_push($userArr, $userDetail);
            array_push($subsArr, $subscriptionDetail);
        }
       $data['userMonthCount'] = $userArr;
       $data['subsMonthCount'] = $subsArr;
        
        return view('admin.dashboard', $data);
    }

    public function user_invoice($purchase_id, $order_id, $type){
        $data['order_id'] = $order_id;
        $data['invoice_setting'] = invoiceSetting::all();
        if($type == '0'){ /////// type == 0 when payment is cancelled
            $data['invoiceData'] = paymentGateway::find($purchase_id);
        }else{ ///////// success payment
            $data['invoiceData'] = SuccessPayment::find($purchase_id);
        }
        $data['type'] = $type;
        if(!empty($data['invoiceData']))
            return view('admin.invoice', $data);
        else
            return redirect('admin');
    }

    public function register(Request $request){
        $checkValidation =  validation($request->except('_token'), ['name' => 'required|min:3', 'email' => 'required|email|max:255|unique:users', 'password' => 'required' ]);
        if($checkValidation['status'] == 1){
            $pass = $request->password;
            $dataArr = [
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'mobile' => $request->mobile
            ];

            $createUser = User::create($dataArr);

            $checkPlan = Plan::where('plan_amount', 0)->get();
            // dd($checkPlan);
            if(sizeof($checkPlan) > 0){
                $planValid = $checkPlan[0]->validity;
                $expiry_date = date("Y-m-d", strtotime("+".$planValid.' day', strtotime(date('Y-m-d'))));
                $addPlan = UserPurchasedPlan::create([
                    'user_id' => $createUser->id,
                    'plan_id' => $checkPlan[0]->id,
                    'plan_data' => json_encode($checkPlan),
                    'payment_data' => json_encode([]),
                    'currency' => '$',
                    'expiry_date' => $expiry_date
                ]); 
            }

            $checkSetting = Settings::where('name', 'LIKE', '%wel_mail%')->get();
            if(sizeof($checkSetting) > 0 && $checkSetting[0]->value == 1){
                $dataArr['url'] = url('/home');
                $dataArr['password'] = $pass;
                Mail::to($request->email)->send(new WelcomeMail($dataArr));
            }


            if($createUser){
                $resp = ['status' => 1, 'msg' => __('frontWords.register_success') ];
            }else{
                $resp = ['status' => 0, 'msg' => __('frontWords.something_wrong')];
            }
        }else{
            $resp = $checkValidation;
        }
        echo json_encode($resp);
    }

    public function authenticated(Request $request){
        if (Auth::attempt([ 'email' => $request->get('email') , 'password' => $request->get('password')], $request->remember)){
            if(Auth::user()->status == 0){
                Auth::logout();
                toastr()->error( __('frontWords.deactivate_acc'), '', ['timeOut' => 2000, 'progressBar' =>false] );
                return redirect('/home');
            }else{
                
                if(Auth::user()->role == 0 || Auth::user()->role == 1){
                    toastr()->success( __('frontWords.login_success'), '', ['timeOut' => 2000, 'progressBar' =>false] );
                    return redirect('/home');
                }
                
            }
        }else{
            Auth::logout();
            toastr()->error( __('frontWords.credential_err'), '', ['timeOut' => 2000, 'progressBar' =>false] );
            return redirect('/home');
        }
    }

    public function socialLogin($service){
        return Socialite::driver($service)->redirect();
    }

    public function socialLoginRedirect(Request $request, $service){
        if(isset($request->error)){
            toastr()->error($request->error_description, '', ['timeOut' => 2000, 'progressBar' =>false]);
            return redirect()->route('home');
        }else{
            $user = Socialite::driver($service)->user();
            if($user->email == ''){
                $user->email = $user->id.'@'.$service.'.com';
            }
            $user = User::firstOrCreate([
                'email' => $user->email
            ],[
                'name' => $user->name,
                'password' => Hash::make(Str::random())
            ]);

            Auth::login($user, true);
            return redirect('home');
        }
    }

    public function setLanguage($locale){
        Session::put('locale', $locale);
        \App::setLocale(Session::get('locale'));
        $setNonedefault = Language::where('is_default', 1)->update(['is_default' => 0]);
        $setDefault = Language::where('Language_code', $locale)->update(['is_default' => 1]);
        return redirect()->back();        
    }
    
    Public function logout(Request $request){
        Auth::logout();
        toastr()->success(__('frontWords.logout_success'), '', ['timeOut' => 2000, 'progressBar' =>false]);
        return redirect('/home');
    }
}
