@extends('layouts.admin.main')
@section('title', __('adminWords.users'))
@section('style')
<link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
          
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ __('adminWords.users') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('users')}}" title="{{ __('adminWords.users')}}">{{ __('adminWords.users') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">   
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('users') }}" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{ __('adminWords.users') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="admin-form">
                    @if(isset($user))
                      {!! Form::model($user, ['method'=>'post', 'files'=>true, 'route'=>['updateUser', $user->id], 'id'=>'updateUser', 'onsubmit'=>'return false', 'data-redirect' => url('/users')]) !!}
                    @else
                      {!! Form::open(['method' => 'POST', 'route'=>['updateUser','add'], 'data-reset'=>1, 'files' => true, 'onsubmit'=>'return false', 'data-redirect' => url('/users')]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                        <div class="form-group{{$errors->has('name') ? 'has-error' : ''}}">
                          <label for="name">{{ __('adminWords.user').' '.__('adminWords.name') }}<sup>*</sup></label>
                          {!! Form::text('name', null, ['class' => 'form-control require', 'required', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.name') ]) !!}
                          <small class="text-danger">{{ $errors->first('name')}}</small>
                        </div>
                        <div class="form-group{{$errors->has('gender') ? 'has-error' : ''}}">
                          <label for="gender">{{ __('adminWords.gender') }}<sup>*</sup></label>
                          <div class="custom-control custom-radio custom-control-inline">
                            {!! Form::radio('gender', 0, (isset($user) && $user->gender == 0 ? 'checked' : (!isset($user) ? 'checked' : '')), ['class' => 'custom-control-input', 'id'=>'male']) !!}
                            {!! Form::label('male', null, ['class' => 'custom-control-label']) !!}
                          </div>
                          <div class="custom-control custom-radio custom-control-inline">
                            {!! Form::radio('gender', 1, (isset($user) && $user->gender == 1 ? 'checked' : ''), ['class' => 'custom-control-input', 'id'=>'female']) !!}
                            {!! Form::label('female', null, ['class' => 'custom-control-label']) !!}
                          </div>
                        </div>
                        <div class="form-group{{$errors->has('email') ? 'has-error' : ''}}">
                          <label for="email">{{ __('adminWords.user_email') }}<sup>*</sup></label>
                          {!! Form::email('email', null, ['class' => 'form-control require', 'required', 'data-valid'=>'email', 'data-error'=>__('adminWords.invalid').' '.__('adminWords.email').'.', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.user_email') ]) !!}
                          <small class="text-danger">{{ $errors->first('email')}}</small>
                        </div>
                        <div class="form-group{{$errors->has('password') ? 'has-error' : ''}}">
                          <label for="password">{{ __('adminWords.user').' '.__('adminWords.password') }}</label>
                          {!! Form::password('password',['class' => 'form-control '.(isset($passwordReq) ? 'require' : ''), 'placeholder'=>__('adminWords.enter').' '.__('adminWords.user').' '.__('adminWords.password')]) !!}
                        </div>
                        <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                          <label for="mobile">{{ __('adminWords.mobile') }}<sup>*</sup></label>
                          {!! Form::text('mobile', null, ['class' => 'form-control require', 'max-length'=>'12', 'length'=>'10' , 'data-length-error'=>__('adminWords.invalid').' '.__('adminWords.mobile').' '.__('adminWords.number') , 'required', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.mobile').' '.__('adminWords.number')]) !!}
                          <small class="text-danger">{{ $errors->first('mobile') }}</small>
                        </div>
                        <div class="form-group{{ $errors->has('image') ? ' has-error' : '' }}">
                          {!! Form::label('image', __('adminWords.user') . ' ' . __('adminWords.image'), ['class' => 'col-lg-12']) !!}
                          <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="User Image">
                              <i class="icon fa fa-check"></i>
                              {!! Form::file('image', ['class' => 'form-control hide', 'id' => 'image','accept' => 'image/*']) !!}
                              <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                          </label>
                          <input type="hidden" id="image_name" name="image" value="{{ isset($user) ? $user->image : '' }}" placeholder="{{ __('User Image')}}">
                          <span class="image_title">{{ isset($user) && $user->image != '' ? $user->image : __('adminWords.choose_image') }}</span>
                          <small class="text-danger">{{ $errors->first('image') }}</small>
                          <p class="note_tooltip">Note: {{ __('adminWords.recommended') . ' size - 500X500 px' }}</p>
                      </div>
                      
                        <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                          {!! Form::label('', '') !!}
                            <div class="row">
                              <div class="col-lg-3">
                                {!! Form::label('status', __('adminWords.status') ) !!}
                              </div>
                              <div class="col-lg-2">
                                  {!! Form::checkbox('status', 1, (isset($user) &&   $user->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                              </div>
                            </div>
                            <small class="text-danger">{{ $errors->first('status') }}</small>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group{{ $errors->has('address') ? ' has-error' : '' }}">
                            {!! Form::label('address', __('adminWords.address')) !!}
                            {!! Form::textarea('address', null, ['class' => 'form-control', 'rows' => '3','placeholder' => __('Please Enter Address')]) !!}
                            <small class="text-danger">{{ $errors->first('address') }}</small>
                          </div> 
                        <div class="form-group{{ $errors->has('country_id') ? ' has-error' : '' }}">
                          {!! Form::label('country_id', __('adminWords.select').' '.__('adminWords.country') ) !!}
                          
                          {!! Form::select('country_id', $country, (isset($user) ? $user->country_id : ''), ['class' => 'form-control select2WithSearch','placeholder' => __('adminWords.choose'), 'data-url'=>url('/fetch_states')]) !!}
                          <small class="text-danger">{{ $errors->first('country_id') }}</small>
                        </div> 
                        <div class="form-group{{ $errors->has('state_id') ? ' has-error' : '' }}">
                          {!! Form::label('state_id', __('adminWords.select').' '.__('adminWords.state')) !!}
                          {!! Form::select('state_id', $state, (isset($user) ? $user->state_id : ''), ['class' => 'form-control select2WithSearch','placeholder' => __('adminWords.choose'), 'data-url'=>url('/fetch_city')]) !!}
                          <small class="text-danger">{{ $errors->first('state_id') }}</small>
                        </div> 
                        <div class="form-group{{ $errors->has('city_id') ? ' has-error' : '' }}">
                          {!! Form::label('city_id', __('adminWords.select').' '.__('adminWords.city')) !!}
                          {!! Form::select('city_id', $city, (isset($user) ? $user->city_id : ''), ['class' => 'form-control select2WithSearch','placeholder' => __('adminWords.choose')]) !!}
                          <small class="text-danger">{{ $errors->first('city_id') }}</small>
                        </div> 
                        <div class="form-group{{ $errors->has('pincode') ? ' has-error' : '' }}">
                          {!! Form::label('pincode', __('adminWords.pincode')) !!}
                          {!! Form::text('pincode', null, ['class' => 'form-control', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.pincode')]) !!}
                          <small class="text-danger">{{ $errors->first('pincode') }}</small>
                        </div> 
                      </div>
                      <div class="col-lg-8">
                        <div class="form-group"> 
                          @if(!isset($user))
                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset') }}</button>
                          @endif  
                          <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.update') }}"><i class="fa fa-check-circle"></i> {{isset($user) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                        </div>
                        <div class="clear-both"></div>
                      </div>
                    </div>
                    {!! Form::close() !!}
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
  <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
  <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
  <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
  <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>  
  <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
