<?php
namespace Modules\Users\Http\Controllers;
use App\User;
use Auth;
use DataTables;
use DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Location\Entities\Country;
use Modules\Location\Entities\AllCountry;
use Modules\Location\Entities\AllState;
use Modules\Location\Entities\AllCity;
use Stevebauman\Purify\Facades\Purify;
use Illuminate\Support\Facades\Validator;
class UsersController extends Controller
{
    public function index()
    {
        return view('users::index');
    }

    public function create(){
        $data['country'] = Country::with('allCountries')->get()->pluck('allCountries.nicename','allCountries.id');
        $data['state'] = collect();
        $data['city'] = collect();
        $data['title'] = 'Create User';
        $data['passwordReq'] = '1';
        return view('users::edituser',$data);
    }

    public function show($id){
        return view('users::show');
    }

    public function edit($id)
    {
        return view('users::edit');
    }

    public function profile(){
        $user = User::where('id',Auth::user()->id)->first();
        return view('users::profile', compact('user'));
    }
    public function editUser($id){
        $data['country'] = Country::with('allCountries')->get()->pluck('allCountries.nicename','allCountries.id');
        $data['user'] = User::where('id', $id)->first();
        $data['state'] = AllState::where('country_id', $data['user']->country_id)->pluck('name','id')->all();
        $data['city'] = AllCity::where('state_id', $data['user']->state_id)->pluck('name','id')->all();
        $data['title'] = 'Edit User';
        return view('users::edituser', $data);
    }

    public function updateUser(Request $request, $id=''){
        if(is_numeric($id))
            $user = User::find($id);
        else
            $user = [];
        $data = $request->all();
        if(!empty($user)){
            $rules = [
                'name' => 'required',
                'email' =>'required|string|email|max:255|unique:users,id,'.$user->id,
                'gender' => 'required',
                'mobile' => 'required',
                'password' => 'nullable|string|min:8',
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ];
            $checkMail = select(['table'=>'users', 'column'=>'id', 'where'=>[['email',$request->email],['id','!=', $id]], 'single'=>1]);
            if(!empty($checkMail)){
                echo json_encode(array('status'=>0, 'msg'=>__('adminWords.email').' '.__('adminWords.already_exist') ));
                return;
            }
        }else{
            $email = User::where('email',$request->email)->first();
            if(!empty($email)){
                echo json_encode(array('status'=>0, 'msg'=>__('adminWords.email').' '.__('adminWords.already_exist') ));
                return;
            }else{
                $rules = [
                    'name' => 'required',
                    'email' => 'required|string|email|max:255|unique:users',
                    'mobile' => 'required',
                    'gender' => 'required',
                    'password' => 'required|string|min:8',
                    'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ];
                $id = get_increment_id('users');  
            }
        }    
        $checkValidate = validation($data, $rules);
        if($checkValidate['status'] == 1){
            $newArr = array(
                'name' => isset($data['name']) ? $data['name'] : NULL,
                'email' => $data['email'],
                'gender' => $data['gender'],
                'mobile' => $data['mobile'],
                'status' => 1,
                'address' => Purify::clean($data['address']),
                'country_id' => isset($data['state_id']) ?  $data['country_id'] : null,
                'state_id' => $data['state_id'],
                'city_id' => $data['city_id'],
                'pincode' =>$data['pincode'],
               
                'image' => $data['image'],
                
            );
              // ========================================
              if ($file = $request->file('image')) {
                $validator = Validator::make(
                    [
                        'image' => strip_tags($request->image),
                        'extension' => strtolower($request->image->getClientOriginalExtension()),
                    ],
                    [
                        'image' => 'required',
                        'extension' => 'required|in:jpg,png',
                    ]
                );
                if ($validator->fails()) {
                    return back()->withErrors( __('Invalid file !'));
                }
                if ($file = $request->file('image')) {
                    $name = time() . $file->getClientOriginalName();
                    $file->move('images/user', $name);
                    $newArr['image'] = $name;
                }
            }
            // ========================================
            if(isset($data['password'])){
                $newArr['password'] = bcrypt($data['password']);
            }
            if(!isset($data['status'])){
                $newArr['status'] = 0;
            }
            
            if(!empty($user)){
                $usersDetail = $user->update($newArr);
                $msg = __('adminWords.user').' '.__('adminWords.updated_msg');
            }else{
                $usersDetail = User::create($newArr); 
                $msg = __('adminWords.user').' '.__('adminWords.added_msg');
            }
            if($usersDetail){
                $resp = array('status'=>1, 'msg'=>$msg);
            }else{
                $resp = array('status'=>0, 'msg'=>__('adminWords.error_msg'));
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function usersData(){
        $users = User::where('role', 0)->orderBy('id','desc')->get();
        return DataTables::of($users)
        ->editColumn('checkbox',function($user){
            return '<div class="inline custom-checkbox"><input id="checkboxAll'.$user->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$user->id.'"><label for="checkboxAll'.$user->id.'" class="custom-control-label"></label></div>';
        })
        ->addColumn('image', function ($user) {
            if($user->image != '' && file_exists(public_path("images/user/".$user->image)))
                $src = asset('images/user/'.$user->image);
            else
                $src = asset('assets/images/users/profile.svg');
            return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
        })
        ->addColumn('status',function($user){
            return '<div class="custom-switch"><input id="switch'.$user->id.'" class="custom-control-input changeStatus" '.($user->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('updateStatus/'.$user->id).'"><label class="custom-control-label" for="switch'.$user->id.'"></label></div>';
        })
        ->addColumn('action', function ($user) {
            return '<div class="button-list"><a href="'.url('edit/'.$user->id).'" class="btn btn-sm btn-success-rgba"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('destroy/'.$user->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
        })
        ->rawColumns(['checkbox','image','status','action'])->make(true);
    }

    function updateStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'users', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function destroy($id, $bulk=''){
        $resp = singleDelete([ 'table'=>'users','column'=>['image','name'], 'where'=>['id'=>$id], 'msg'=>__('adminWords.user').' '.__('adminWords.delete_success'), 'isImage'=>public_path().'/images/user/' ]);
        echo $resp;
    }

    function bulkDelete(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'],__('adminWords.atleast').' '.__('adminWords.user').' '.__('adminWords.delete_success') );
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'users','column'=>'id', 'msg'=>__('adminWords.user').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    function fetch_states(Request $request){
        $country = AllCountry::findOrFail($request->country_id);
        $states = AllState::where('country_id', $request->country_id)->pluck('name','id')->all();
        $resp = array('status'=>1, 'data'=>$states);
        return response()->json($resp);
    }

    function fetch_city(Request $request){
        $states = AllState::findOrFail($request->state_id);
        $city = AllCity::where('state_id', $request->state_id)->pluck('name','id')->all();
        $resp = array('status'=>1, 'data'=>$city);
        return response()->json($resp);
    }
}
