@extends('layouts.admin.main')
@section('title', __('adminWords.tax').' '.__('adminWords.setting') )
@section('rightbar-content')
              
<div class="breadcrumbbar taxSetting">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.tax').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.tax')}}">{{ __('adminWords.tax').' '.__('adminWords.setting') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>
   
<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
        {!! Form::open(['method' => 'POST', 'route'=>'tax.save' ]) !!}
            <div class="card m-b-30">
            <div class="card-header">
                <div class="row">
                <div class="col-lg-8">
                    <h5>{{ __('adminWords.set_tax') }}</h5>
                </div>
                <div class="col-lg-4 text-right">
                    <div class="form-group">
                    <div class="custom-switch">
                        {!! Form::checkbox('set_tax', 1, !empty($settings) && isset($settings['set_tax']) ? $settings['set_tax'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"tax_box", 'data-type'=>'set_tax', 'required-id'=>'#tax', 'id'=>'tax_check']) !!}
                        <label class="custom-control-label" for="tax_check"></label>
                        <input type="hidden" value="{{route('changeStatus')}}" id="URL">
                    </div>
                    </div>
                </div>
                </div>
            </div>
            <div id="tax_box" class="card-body">
                <div class="row">                    
                <div class="col-lg-10">
                    <div class="form-group{{ $errors->has('tax') ? ' has-error' : '' }}">
                    <label for="tax">{{ __('adminWords.enter').' '.__('adminWords.tax').' %' }}<sup>*</sup></label>
                    {!! Form::text('tax', !empty($settings) && isset($settings['set_tax']) && $settings['set_tax'] == 1 ? $settings['tax'] : '', ['class'=>'form-control', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.tax').' % ' ]) !!}
                    <small class="text-danger">{{ $errors->first('tax') }}</small>
                    <p>{{ __('adminWords.tax_note') }}</p>
                    </div>                      
                </div>                  
                <div class="col-lg-10">  
                    <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                    <div class="clear-both"></div>
                </div>
                </div>
            </div>
            </div>
        {!! Form::close() !!}
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
