@extends('layouts.admin.main')
@section('title', __('adminWords.site_setting'))
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">{{ __('adminWords.site_setting') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#"
                                title="{{ __('adminWords.site_setting') }}">{{ __('adminWords.site_setting') }}</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <h5 class="card-title mb-0">{{ __('adminWords.create') . ' ' . __('adminWords.site_setting') }}
                                </h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        {!! Form::open(['method' => 'POST', 'files' => true, 'route' => 'site.update']) !!}
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group{{ $errors->has('w_title') ? ' has-error' : '' }}">
                                    <label for="w_title">{{ __('adminWords.website_title') }}<sup>*</sup></label>
                                    {!! Form::text('w_title', isset($settings['w_title']) ? $settings['w_title'] : null, [
                                        'class' => 'form-control require',
                                        'placeholder' => __('adminWords.enter') . ' ' . __('adminWords.website_title'),
                                    ]) !!}
                                    <small class="text-danger">{{ $errors->first('w_title') }}</small>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div
                                            class="form-group{{ $errors->has('logo') ? ' has-error' : '' }} input-file-block label_full">
                                            <label for="logo">{{ __('adminWords.logo') }}<sup>*</sup></label>
                                            {!! Form::file('logo', [
                                                'class' => 'input-file hide basicImage ' . (isset($settings['logo']) && $settings['logo'] != null ? '' : 'require'),
                                                'id' => 'logo',
                                                'data-id' => 'showLogo',
                                                'data-label' => 'logoLabel',
                                                'accept' => 'image/*',
                                            ]) !!}
                                            <label for="logo" class="btn btn-danger js-labelFile" data-toggle="tooltip"
                                                data-original-title="Website Logo">
                                                <i class="icon fa fa-check"></i>
                                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                            </label>
                                            <span class="info"
                                                id="logoLabel">{{ isset($settings['logo']) && $settings['logo'] != '' ? $settings['logo'] : __('adminWords.choose_a') . ' ' . __('adminWords.logo') }}</span>
                                            <small class="text-danger">{{ $errors->first('logo') }}</small>
                                            <p class="note_tooltip">Note:
                                                {{ __('adminWords.recommended') . ' size - 60X60 px' }} </p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="image-block site_image_dv">
                                            @if (isset($settings['logo']) && $settings['logo'] != null)
                                                <img src="{{ asset('images/sites/' . $settings['logo']) }}"
                                                    class="img-responsive" alt="{{ __('logo') }}">
                                            @else
                                                <img src="" id="showLogo" class="img-responsive"
                                                    alt="{{ __('logo') }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div
                                            class="form-group{{ $errors->has('favicon') ? ' has-error' : '' }} input-file-block label_full">
                                            <label for="favicon">{{ __('adminWords.website_fav') }}<sup>*</sup></label>
                                            {!! Form::file('favicon', [
                                                'class' =>
                                                    'input-file hide basicImage' . (isset($settings['favicon']) && $settings['favicon'] != null ? '' : 'require'),
                                                'id' => 'favicon',
                                                'data-id' => 'showFavicon',
                                                'data-label' => 'faviconLabel',
                                                'data-ext' => "['jpg','jpeg','png','svg', 'ico']",
                                                'accept' => 'image/*',
                                            ]) !!}
                                            <label for="favicon" class="btn btn-danger js-labelFile" data-toggle="tooltip"
                                                data-original-title="Website Favicon">
                                                <i class="icon fa fa-check"></i>
                                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                            </label>
                                            <span class="info"
                                                id="faviconLabel">{{ isset($settings['favicon']) && $settings['favicon'] != '' ? $settings['favicon'] : __('adminWords.choose_a') . ' ' . __('adminWords.favicon') }}</span>
                                            <small class="text-danger">{{ $errors->first('favicon') }}</small>
                                            <p class="note_tooltip">Note:
                                                {{ __('adminWords.recommended') . ' size - 34X34 px' }} </p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="image-block site_image_dv">
                                            @if (isset($settings['favicon']) && $settings['favicon'] != null)
                                                <img src="{{ asset('images/sites/' . $settings['favicon']) }}"
                                                    class="img-responsive" alt="{{ __('favicon') }}">
                                            @else
                                                <img src="" id="showFavicon" class="img-responsive"
                                                    alt="{{ __('favicon') }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div
                                            class="form-group{{ $errors->has('preloader') ? ' has-error' : '' }} input-file-block label_full">
                                            {!! Form::label('preloader', __('adminWords.website_preloader')) !!}
                                            {!! Form::file('preloader', [
                                                'class' =>
                                                    'input-file hide basicImage ' .
                                                    (isset($settings['preloader']) && $settings['preloader'] != null ? '' : 'require'),
                                                'id' => 'preloader',
                                                'data-id' => 'showPreloader',
                                                'data-label' => 'preloaderLabel',
                                                'data-ext' => "['jpg','jpeg','png','svg', 'gif']",
                                                'accept' => 'image/*',
                                            ]) !!}
                                            <label for="preloader" class="btn btn-danger js-labelFile" data-toggle="tooltip"
                                                data-original-title="Website Preloader">
                                                <i class="icon fa fa-check"></i>
                                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                            </label>
                                            <span class="info"
                                                id="preloaderLabel">{{ isset($settings['preloader']) && $settings['preloader'] != '' ? $settings['preloader'] : __('adminWords.choose_a') . ' ' . __('adminWords.preloader') }}</span>
                                            <small class="text-danger">{{ $errors->first('preloader') }}</small>
                                            <p class="note_tooltip">Note:
                                                {{ __('adminWords.recommended') . ' size - 100X100 px' }} </p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="image-block site_image_dv">
                                            @if (isset($settings['preloader']) && $settings['preloader'] != null)
                                                <img src="{{ asset('images/sites/' . $settings['preloader']) }}"
                                                    class="img-responsive" alt="{{ __('preloader') }}">
                                            @else
                                                <img src="" id="showPreloader" class="img-responsive"
                                                    alt="{{ __('preloader') }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group{{ $errors->has('is_preloader') ? ' has-error' : '' }}">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('is_preloader', __('adminWords.preloader')) !!}
                                        </div>
                                        <div class="col-lg-2 custom-switch">
                                            {!! Form::checkbox(
                                                'is_preloader',
                                                1,
                                                isset($settings['is_preloader']) && $settings['is_preloader'] == 0 ? 0 : 1,
                                                ['id' => 'is_preloader', 'class' => 'custom-control-input'],
                                            ) !!}
                                            <label class="custom-control-label" for="is_preloader"></label>
                                        </div>
                                    </div>
                                    <small class="text-danger">{{ $errors->first('is_preloader') }}</small>
                                </div>
                                <div class="form-group{{ $errors->has('is_gotop') ? ' has-error' : '' }}">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('is_gotop', __('adminWords.go_to_top')) !!}
                                        </div>
                                        <div class="col-lg-2 custom-switch">
                                            {!! Form::checkbox('is_gotop', 1, isset($settings['is_gotop']) && $settings['is_gotop'] == 0 ? 0 : 1, [
                                                'id' => 'is_gotop',
                                                'class' => 'custom-control-input',
                                            ]) !!}
                                            <label class="custom-control-label" for="is_gotop"></label>
                                        </div>
                                    </div>
                                    <small class="text-danger">{{ $errors->first('is_gotop') }}</small>
                                </div>
                                <div class="form-group{{ $errors->has('inspect') ? ' has-error' : '' }}">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('inspect', __('adminWords.inspect')) !!}
                                        </div>
                                        <div class="col-lg-2 custom-switch">
                                            {!! Form::checkbox('inspect', 1, isset($settings['inspect']) && $settings['inspect'] == 0 ? 0 : 1, [
                                                'id' => 'inspect',
                                                'class' => 'custom-control-input',
                                            ]) !!}
                                            <label class="custom-control-label" for="inspect"></label>
                                        </div>
                                    </div>
                                    <small class="text-danger">{{ $errors->first('inspect') }}</small>
                                </div>
                                <div class="form-group{{ $errors->has('right_click') ? ' has-error' : '' }}">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('right_click', __('adminWords.right_click')) !!}
                                        </div>
                                        <div class="col-lg-2 custom-switch">
                                            {!! Form::checkbox('right_click', 1, isset($settings['right_click']) && $settings['right_click'] == 0 ? 0 : 1, [
                                                'id' => 'right_click',
                                                'class' => 'custom-control-input',
                                            ]) !!}
                                            <label class="custom-control-label" for="right_click"></label>
                                        </div>
                                    </div>
                                    <small class="text-danger">{{ $errors->first('right_click') }}</small>
                                </div>
                                <div class="form-group{{ $errors->has('wel_mail') ? ' has-error' : '' }}">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            {!! Form::label('wel_mail', __('adminWords.welcome_mail')) !!}
                                        </div>
                                        <div class="col-lg-2 custom-switch">
                                            {!! Form::checkbox('wel_mail', 1, isset($settings['wel_mail']) && $settings['wel_mail'] == 0 ? 0 : 1, [
                                                'id' => 'wel_mail',
                                                'class' => 'custom-control-input',
                                            ]) !!}
                                            <label class="custom-control-label" for="wel_mail"></label>
                                        </div>
                                    </div>
                                    <small class="text-danger">{{ $errors->first('wel_mail') }}</small>
                                </div>

                                   

                            </div>
                            <div class="col-lg-12 mt-3">
                                <button type="button" class="btn btn-success"
                                    data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                                <div class="clear-both"></div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
