@extends('layouts.admin.main')
@section('title', __('adminWords.seo').' '.__('adminWords.setting') )
@section('rightbar-content')                 
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.seo').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.seo')}}">{{ __('adminWords.seo').' '.__('adminWords.setting') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>

<div class="contentbar">  
  <div class="row">
    <div class="col-lg-12">
        <div class="card m-b-30 add-form hide-block">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0">{{ __('adminWords.create').' '.__('adminWords.seo').' '.__('adminWords.setting') }}</h5>
                        </div>
                    </div>
                    </div>
                    <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                        {!! Form::open(['method' => 'POST', 'route'=>'seo.update']) !!}
                            <div class="form-group{{ $errors->has('author_name') ? ' has-error' : '' }}">
                              <label for="author_name">{{ __('adminWords.author_name') }}<sup>*</sup></label>
                              {!! Form::text('author_name', isset($settings['author_name']) ? $settings['author_name'] : null, ['class' => 'form-control require', 'placeholder' => __('adminWords.enter').' '.__('adminWords.author_name') ]) !!}
                              <small class="text-danger">{{ $errors->first('author_name') }}</small>
                            </div> 
                            <div class="form-group{{ $errors->has('keywords') ? ' has-error' : '' }}">
                              <label for="keywords">{{ __('adminWords.web_keyword') }}<sup>*</sup></label>
                              {!! Form::textarea('keywords', isset($settings['keywords']) ? $settings['keywords'] : null, ['class' => 'form-control require', 'rows' => 3, 'placeholder' => __('adminWords.enter').' '.__('adminWords.web_keyword') ]) !!}
                              <small class="text-danger">{{ $errors->first('keywords') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('meta_desc') ? ' has-error' : '' }}">
                              <label for="meta_desc">{{ __('adminWords.metadata_desc') }}<sup>*</sup></label>
                              {!! Form::textarea('meta_desc', isset($settings['meta_desc']) ? $settings['meta_desc'] : null, ['class' => 'form-control require', 'rows' => 3, 'placeholder' =>  __('adminWords.enter').' '.__('adminWords.metadata_desc') ]) !!}
                              <small class="text-danger">{{ $errors->first('meta_desc') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('google_analysis') ? ' has-error' : '' }}">
                              <label for="google_analysis">{{ __('adminWords.google_analysis') }}</label>
                              {!! Form::text('google_analysis', isset($settings['google_analysis']) ? $settings['google_analysis'] : null, ['class' => 'form-control', 'placeholder' => __('adminWords.enter').' '.__('adminWords.google_analysis') ]) !!}
                              <small class="text-danger">{{ $errors->first('google_analysis') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('fb_pixel') ? ' has-error' : '' }}">
                              <label for="fb_pixel">{{ __('adminWords.fb_pixel') }}</label>
                              {!! Form::text('fb_pixel', isset($settings['fb_pixel']) ? $settings['fb_pixel'] : null, ['class' => 'form-control', 'placeholder' => __('adminWords.enter').' '.__('adminWords.fb_pixel') ]) !!}
                              <small class="text-danger">{{ $errors->first('fb_pixel') }}</small>
                            </div> 
                            <button type="button" data-action="submitThisForm" class="btn btn-success" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                            <div class="clear-both"></div>
                        {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
