@extends('layouts.admin.main')
@section('title', __('adminWords.open_exchange').' '.__('adminWords.setting') )
@section('rightbar-content')
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.open_exchange').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.open_exchange')}}">{{ __('adminWords.open_exchange').' '.__('adminWords.setting') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>
 
<div class="contentbar">  
  <div class="row">
    <div class="col-lg-12">
        <div class="card m-b-30 add-form hide-block">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0 with_svg_title">
                          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512.002 512.002">
                          <circle cx="364" cy="140.062" r="32"/>
                          <path d="M506.478,165.937c-10.68-27.194-30.264-66.431-62.915-98.927c-32.535-32.384-71.356-51.408-98.194-61.666    c-29.464-11.261-62.945-4.163-85.295,18.082l-78.538,78.17c-23.281,23.171-29.991,58.825-16.698,88.72    c4.122,9.272,8.605,18.341,13.395,27.103L5.858,389.793C2.107,393.544,0,398.631,0,403.936v88c0,11.046,8.954,20,20,20h88    c11.046,0,20-8.954,20-20v-36l36-0.001c11.046,0,20-8.954,20-20v-35.999h36c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20h-56    c-11.046,0-20,8.954-20,20v35.999l-36,0.001c-11.046,0-20,8.954-20,20v36H40V412.22l177.355-177.354    c6.516-6.516,7.737-16.639,2.958-24.517c-6.931-11.424-13.298-23.632-18.923-36.285c-6.599-14.841-3.237-32.57,8.366-44.119    l78.537-78.169c11.213-11.159,28.011-14.718,42.798-9.068c23.222,8.876,56.69,25.214,84.256,52.652    c27.735,27.604,44.62,61.567,53.9,85.197c5.791,14.748,2.272,31.503-8.965,42.687l-79.486,79.114    c-11.575,11.519-28.851,14.887-44.016,8.58c-12.507-5.202-24.62-11.382-36-18.367c-9.413-5.778-21.729-2.83-27.507,6.584    c-5.778,9.414-2.831,21.73,6.583,27.508c13.152,8.072,27.136,15.207,41.562,21.207c30.142,12.539,64.525,5.8,87.595-17.161    l79.486-79.113C511.044,229.157,518.101,195.534,506.478,165.937z"/>
                          </svg> {{ __('adminWords.open_exchange').' '.__('adminWords.setting') }}
                        </h5>
                        </div>
                    </div>
                    </div>
                    <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                        {!! Form::open(['method' => 'POST', 'route'=>'open_exchange.save']) !!}
                            <div class="open_exchange_key form-group{{ $errors->has('OPEN_EXCHANGE_KEY') ? ' has-error' : '' }}">
                              <label for="OPEN_EXCHANGE_KEY">{{ __('adminWords.open_exchange') }}<sup>*</sup></label>
                              <a class="float-right" href="https://openexchangerates.org/signup/free" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512.002 512.002">
                                <circle cx="364" cy="140.062" r="32"/>
                                <path d="M506.478,165.937c-10.68-27.194-30.264-66.431-62.915-98.927c-32.535-32.384-71.356-51.408-98.194-61.666    c-29.464-11.261-62.945-4.163-85.295,18.082l-78.538,78.17c-23.281,23.171-29.991,58.825-16.698,88.72    c4.122,9.272,8.605,18.341,13.395,27.103L5.858,389.793C2.107,393.544,0,398.631,0,403.936v88c0,11.046,8.954,20,20,20h88    c11.046,0,20-8.954,20-20v-36l36-0.001c11.046,0,20-8.954,20-20v-35.999h36c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20h-56    c-11.046,0-20,8.954-20,20v35.999l-36,0.001c-11.046,0-20,8.954-20,20v36H40V412.22l177.355-177.354    c6.516-6.516,7.737-16.639,2.958-24.517c-6.931-11.424-13.298-23.632-18.923-36.285c-6.599-14.841-3.237-32.57,8.366-44.119    l78.537-78.169c11.213-11.159,28.011-14.718,42.798-9.068c23.222,8.876,56.69,25.214,84.256,52.652    c27.735,27.604,44.62,61.567,53.9,85.197c5.791,14.748,2.272,31.503-8.965,42.687l-79.486,79.114    c-11.575,11.519-28.851,14.887-44.016,8.58c-12.507-5.202-24.62-11.382-36-18.367c-9.413-5.778-21.729-2.83-27.507,6.584    c-5.778,9.414-2.831,21.73,6.583,27.508c13.152,8.072,27.136,15.207,41.562,21.207c30.142,12.539,64.525,5.8,87.595-17.161    l79.486-79.113C511.044,229.157,518.101,195.534,506.478,165.937z"/>
                                </svg> Get your Open Exchange Key from here
                              </a>
                              {!! Form::text('OPEN_EXCHANGE_KEY', (env('OPEN_EXCHANGE_KEY') ? env('OPEN_EXCHANGE_KEY') : null), ['class' => 'form-control require', 'placeholder' => __('adminWords.enter').' '.__('adminWords.open_exchange') ]) !!}
                              <small class="text-danger">{{ $errors->first('OPEN_EXCHANGE_KEY') }}</small>
                            </div> 
                            
                            <button type="button" data-action="submitThisForm" class="btn btn-success" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                            <div class="clear-both"></div>
                        {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
