@extends('layouts.admin.main')
@section('title', __('adminWords.notification'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
<div class="breadcrumbbar">
	<div class="row align-items-center">
		<div class="col-md-7 col-lg-7">
			<h4 class="page-title">{{ __('adminWords.all').' '.__('adminWords.notification') }}</h4>
			<div class="breadcrumb-list">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
					<li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.notification')}}">{{ __('adminWords.notification') }}</a></li>
				</ol>
			</div>
		</div>
		<div class="col-md-5 col-lg-5">
			<div class="widgetbar">
				<a class="btn btn-primary-rgba mr-2 notificationPopup" data-add="1" data-url="{{route('notification.add')}}" title="{{ __('adminWords.create').' '.__('adminWords.notification') }}"><i class="feather icon-plus mr-2"></i>{{ __('adminWords.create').' '.__('adminWords.notification') }}</a>
				<button type="button" class="btn btn-danger" id="bulkDelete" data-type="notification" data-msg="{{ __('adminWords.atleast').' '.__('adminWords.notification').' '.__('adminWords.must_selected') }}" data-url="{{route('bulkDeleteNotification')}}" title="{{ __('adminWords.delete_selected') }}"><i class="fa fa-trash"></i> {{ __('adminWords.delete_selected') }}</button>
			</div>                        
		</div>
	</div>          
</div>

<div class="contentbar">  
	<div class="row">
		<div class="col-lg-12"> 
			<div class="card m-b-30">
				<div class="card-header">                                
					<div class="row align-items-center">
						<div class="col-6">
							<h5 class="card-title mb-0">{{ __('adminWords.all').' '.__('adminWords.notification') }}</h5>
						</div>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<form method="post" id="notificationForm">
							<table data-method="post" id="datatable-buttons" class="table table-borderless mrclsDtToShowData" data-url="{{route('notificationData')}}">
								<thead>
									<tr> 
										<th class="select-checkbox"> 
											<div class="inline custom-checkbox">
												<input id="checkboxAll" type="checkbox" class="custom-control-input selectAllUser" onchange="checkAll(this, 'CheckBoxes')"  placeholder="{{ __('checkboxAll') }}">
												<label for="checkboxAll" class="custom-control-label"></label>
											</div>
										</th>
										<th>{{ __('adminWords.user_name') }}</th>
										<th>{{ __('adminWords.message') }}</th>
										<th>{{ __('adminWords.created_at') }}</th>
										<th>{{ __('adminWords.action') }}</th>
									</tr>
								</thead>
							</table>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="addNotification">
  <div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">{{ __('adminWords.add').' '.__('adminWords.notification') }}</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('adminWords.close_modal') }}">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
     
        {!! Form::open(['method' => 'POST', 'route' =>['notification.add'], 'data-reset'=>'1', 'data-modal'=>1, 'table-reload'=>'mrclsDtToShowData' ]) !!}
            <div class="modal-body">
                
                <div class="form-group{{ $errors->has('user_id') ? ' has-error' : '' }}">
					<label for="user_id">{{  __('adminWords.select').' '.__('adminWords.users') }}<sup>*</sup></label>
                    {!! Form::select('user_id[]', $userData, '', ['class' => 'form-control multipleSelectWithSearch selectUsers require', 'multiple', 'data-placeholder' => __('adminWords.choose')]) !!}
                    <small class="text-danger">{{ $errors->first('user_id') }}</small>
                </div> 
                        
                <div class="form-group{{ $errors->has('message') ? ' has-error' : '' }}">
					<label for="message">{{ __('adminWords.notification').' '.__('adminWords.message') }}<sup>*</sup></label>
                    {!! Form::textarea('message', '', ['class' => 'form-control require', 'rows'=>3]) !!}
                    <small class="text-danger">{{ $errors->first('message') }}</small>
                </div> 
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal" title="{{ __('adminWords.close') }}"> {{ __('adminWords.close') }}</button>
                    <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.save') }}">{{ __('adminWords.save') }}</button>
                </div>
            </div>
        {!! Form::close() !!}
    </div>
  </div>
</div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>     
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
