@extends('layouts.admin.main')
@section('title', __('adminWords.mail').' '.__('adminWords.setting'))
@section('rightbar-content')
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.mail').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.mail')}}">{{ __('adminWords.mail').' '.__('adminWords.setting') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>
   
<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{ __('adminWords.create').' '.__('adminWords.mail').' '.__('adminWords.setting') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                {!! Form::open(['method' => 'POST', 'route' => 'mail.update']) !!}
                    <div class="row">                    
                    <div class="col-md-6">
                        <div class="form-group{{ $errors->has('MAIL_FROM_NAME') ? ' has-error' : '' }}">
                            <label for="MAIL_FROM_NAME">{{  __('adminWords.sender_name') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_FROM_NAME', env('MAIL_FROM_NAME'), ['class' => 'form-control require', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.sender_name') ]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_FROM_NAME') }}</small>
                        </div>    
                    </div>                         
                    <div class="col-md-6">                   
                        <div class="form-group{{ $errors->has('MAIL_DRIVER') ? ' has-error' : '' }}">
                            <label for="MAIL_DRIVER">{{  __('adminWords.mail_driver') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_DRIVER', env('MAIL_DRIVER'), ['class' => 'form-control require', 'placeholder'=>__('adminWords.mail_driver_plchldr') ]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_DRIVER') }}</small>
                        </div>
                    </div>                         
                    <div class="col-md-6">  
                        <div class="form-group{{ $errors->has('MAIL_HOST') ? ' has-error' : '' }}">
                            <label for="MAIL_HOST">{{  __('adminWords.mail_host') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_HOST', env('MAIL_HOST'), ['class' => 'form-control require', 'placeholder'=>__('adminWords.mail_host_plchldr')]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_HOST') }}</small>
                        </div>
                    </div>                         
                    <div class="col-md-6">  
                        <div class="form-group{{ $errors->has('MAIL_PORT') ? ' has-error' : '' }}">
                            <label for="MAIL_PORT">{{  __('adminWords.mail_port') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_PORT', env('MAIL_PORT'), ['class' => 'form-control require', 'placeholder'=>__('adminWords.mail_port_plchldr')]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_PORT') }}</small>
                        </div>  
                    </div>                         
                    <div class="col-md-6">                                        
                        <div class="form-group{{ $errors->has('MAIL_USERNAME') ? ' has-error' : '' }}">
                            <label for="MAIL_USERNAME">{{  __('adminWords.mail_user') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_USERNAME', env('MAIL_USERNAME'), ['class' => 'form-control require', 'placeholder'=> __('adminWords.mail_name_plchldr')]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_USERNAME') }}</small>
                        </div>
                    </div>                               
                    <div class="col-md-6">                     
                        <div class="form-group{{ $errors->has('MAIL_PASSWORD') ? ' has-error' : '' }}">
                            <label for="MAIL_PASSWORD">{{  __('adminWords.mail_pass') }}<sup>*</sup></label>
                            {!! Form::text('MAIL_PASSWORD', env('MAIL_PASSWORD'), ['class' => 'form-control require', 'placeholder'=>__('adminWords.mail_pass')]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_PASSWORD') }}</small>
                        </div> 
                    </div>                         
                    <div class="col-md-6">                     
                        <div class="form-group{{ $errors->has('MAIL_ENCRYPTION') ? ' has-error' : '' }}">
                            <label for="MAIL_ENCRYPTION">{{  __('adminWords.mail_enc') }}</label>
                            {!! Form::text('MAIL_ENCRYPTION', env('MAIL_ENCRYPTION'), ['class' => 'form-control', 'placeholder'=>__('adminWords.mail_enc_plchldr')]) !!}
                            <small class="text-danger">{{ $errors->first('MAIL_ENCRYPTION') }}</small>
                        </div> 
                    </div>
                    <div class="col-md-12"> 
                        <button type="button" class="btn btn-success" data-action="submitThisForm">{{ __('adminWords.save_setting_btn') }}</button>
                        <button type="button" class="btn btn-secondary" data-toggle="modal"
                        data-target="#exampleModal"><i class="feather icon-send mr-2"></i> {{ __('Test') }}</a>
                        <div class="clear-both"></div>
                    </div>
                    </div>
                {!! Form::close() !!}
                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="exampleModalLabel">{{ __('Email Test') }}</h1>
                            <button type="button" class="btn-close" data-dismiss="modal title="{{ __('adminWords.close_modal') }}""
                                aria-label="Close"></button>
                        </div>
                        <form action="{{ route('testsend.email') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="modal-body">
                                <div class="form-group">
                                    <input class="form-control form-control-lg" type="email"
                                        name="sender_email" placeholder="{{ __('Enter Your Mail Address') }}"
                                    required>
                                    <div class="form-control-icon form-control-icon-one"><i
                                            class="flaticon-email-3"></i></div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal" title="{{ __('Test Email Send') }}">{{
                                    __('Test Email Send') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
