@extends('layouts.admin.main')
@section('title', __('adminWords.google_ad').' '.__('adminWords.setting'))
@section('rightbar-content')
<div class="breadcrumbbar googleAdSetting">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.google_ad').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.google_ad')}}">{{ __('adminWords.google_ad') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>

<div class="contentbar">  
  <div class="row">
    <div class="col-lg-12">
      
      @php if(sizeof($google_ad) > 0){ @endphp
        {!! Form::model($google_ad[0], ['method'=>'post', 'route'=>['google_ad',$google_ad[0]->id] ]) !!}
        <input type="hidden" value="{{url('changeAdsenseStatus/'.$google_ad[0]->id)}}" id="URL">
      @php } 
      else{ @endphp
        {!! Form::open(['method' => 'POST', 'route'=>['google_ad','add'], 'data-redirect'=> url('google/ad') ]) !!}
        <input type="hidden" value="{{url('changeAdsenseStatus/add')}}" id="URL">
      @php } @endphp
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.google_ad').' '.__('adminWords.setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('status', 1, (sizeof($google_ad) > 0 ? $google_ad[0]->status : null), ['id'=>'g_check', 'class' => 'custom-control-input updateSettings', 'data-id'=>"g_box", 'required-id'=>'#google_ad_script', 'data-type'=>'is_google_ad']) !!}
                    <label class="custom-control-label" for="g_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="g_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('google_ad_script') ? ' has-error' : '' }}">
                    <label for="google_ad_script">{{   __('adminWords.google_ad').' '.__('adminWords.script') }}<sup>*</sup></label>
                    {!! Form::textarea('google_ad_script', env('google_ad_script'), ['class' => 'form-control require', 'rows' => '3', 'placeholder' => __('adminWords.enter').' '.__('adminWords.google_ad').' '.__('adminWords.script')]) !!}
                    <small class="text-danger">{{ $errors->first('google_ad_script') }}</small>
                </div>  
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" data-action="submitThisForm" class="btn btn-success" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
    </div>
  </div>
</div>
@endsection 
@section('script')
  <script src="{{ asset('assets/js/mrcls-custom.js?'.time()) }}"></script>
@endsection
