@extends('layouts.admin.main')
@section('title', __('adminWords.payment').' '.__('adminWords.setting'))
@section('style')
  <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
<div class="breadcrumbbar paymentGatewaySetting">
  <div class="row align-items-center">
    <div class="col-lg-8 col-lg-8">
      <h4 class="page-title">{{ __('adminWords.payment').' '.__('adminWords.setting') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.payment')}}">{{ __('adminWords.payment').' '.__('adminWords.setting') }}</a></li>
        </ol>
        <input type="hidden" value="{{route('changeStatus')}}" id="URL">
      </div>
    </div>
  </div>          
</div>

<div class="contentbar">  
  <div class="row">
    <div class="col-lg-12">
      {!! Form::open(['method' => 'POST', 'route'=>['api.update','razor']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.razorpay_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_razorpay', 1, isset($settings['is_razorpay']) ? $settings['is_razorpay'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"razorpay_box", 'required-id'=>'#RAZORPAY_KEY, #razorsecret', 'data-type'=>'is_razorpay', 'id'=>'razorpay_check', 'data-name' => 'razorpay']) !!}
                    <label class="custom-control-label" for="razorpay_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="razorpay_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('RAZORPAY_KEY') ? ' has-error' : '' }}">
                  <label for="RAZORPAY_KEY">{{  __('adminWords.razorpay_key') }}<sup>*</sup></label>
                  {!! Form::text('RAZORPAY_KEY', (env('RAZORPAY_KEY') ? env('RAZORPAY_KEY') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('RAZORPAY_KEY') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('RAZORPAY_SECRET') ? ' has-error' : '' }}">
                  <label for="RAZORPAY_SECRET">{{ __('adminWords.razorpay_secret') }}<sup>*</sup></label>
                  <input type="password" name="RAZORPAY_SECRET" value="{{ env('RAZORPAY_SECRET') }}" id="razorsecret" class="form-control" placeholder="{{ __('Razorpay Secret')}}">
                  <span toggle="#razorsecret" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('RAZORPAY_SECRET') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
      {!! Form::open(['method' => 'POST', 'route'=>['api.update','paypal']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.paypal_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_paypal', 1, isset($settings['is_paypal']) ? $settings['is_paypal'] : null, ['class' => 'custom-control-input updateSettings','required-id'=>'#PAYPAL_CLIENT_ID, #paypalsecret, #PAYPAL_MODE', 'data-type'=>'is_paypal', 'data-id'=>"paypal_box", 'id'=>'paypal_check', 'data-name' => 'paypal']) !!}
                    <label class="custom-control-label" for="paypal_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="paypal_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('PAYPAL_CLIENT_ID') ? ' has-error' : '' }}">
                  <label for="PAYPAL_CLIENT_ID">{{ __('adminWords.paypal_id') }}<sup>*</sup></label>
                  {!! Form::text('PAYPAL_CLIENT_ID', env('PAYPAL_CLIENT_ID'), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYPAL_CLIENT_ID') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('PAYPAL_SECRET') ? ' has-error' : '' }}">
                  <label for="PAYPAL_SECRET">{{ __('adminWords.paypal_secret') }}<sup>*</sup></label>
                  <input type="password" name="PAYPAL_SECRET" value="{{ env('PAYPAL_SECRET') }}" id="paypalsecret" class="form-control" placeholder="{{ __('Paypal Secret')}}">
                  <span toggle="#paypalsecret" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('PAYPAL_SECRET') }}</small>
                </div>
                <div class="form-group{{ $errors->has('PAYPAL_MODE') ? ' has-error' : '' }}">
                  <label for="PAYPAL_MODE">{{ __('adminWords.paypal_mode') }}<sup>*</sup></label>
                  {!! Form::text('PAYPAL_MODE', env('PAYPAL_MODE'), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYPAL_MODE') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div> 
          </div>
        </div>
      {!! Form::close() !!}

      {!! Form::open(['method' => 'POST', 'route'=>['api.update','payu']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.payu_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_payu', 1, isset($settings['is_payu']) ? $settings['is_payu'] : null, ['class' => 'custom-control-input updateSettings','required-id'=>'#PAYU_METHOD, #PAYU_DEFAULT #PAYU_MERCHANT_KEY, #PAYU_MERCHANT_SALT, #PAYU_AUTH_HEADER', 'data-type'=>'is_payu', 'data-id'=>"payu_box", 'id'=>'payu_check', 'data-name' => 'payu']) !!}
                    <label class="custom-control-label" for="payu_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="payu_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('PAYU_METHOD') ? ' has-error' : '' }}">
                  <label for="PAYU_METHOD">{{ __('adminWords.payu_method') }}<sup>*</sup></label>
                  {!! Form::text('PAYU_METHOD', env('PAYU_METHOD'), ['class' => 'form-control', 'placeholder' => __('adminWords.enter').' '.__('adminWords.payu_method') ]) !!}
                  <small class="text-danger">{{ $errors->first('PAYU_METHOD') }}</small>
                  <span>{{ __('adminWords.payu_note') }}</span>
                </div>   
                <div class="form-group{{$errors->has('PAYU_DEFAULT') ? 'has-error' : ''}}">
                  <div class="custom-control custom-radio custom-control-inline">
                    {!! Form::radio('PAYU_DEFAULT', 'payumoney', (env('PAYU_DEFAULT') == 'payumoney' ? 'checked' : (env('PAYU_DEFAULT') != '' ? 'checked' : '')), ['class' => 'custom-control-input', 'id'=>'payumoney']) !!}
                    {!! Form::label('payumoney', null, ['class' => 'custom-control-label']) !!}
                  </div>
                  <div class="custom-control custom-radio custom-control-inline">
                    {!! Form::radio('PAYU_DEFAULT', 'payubiz', (env('PAYU_DEFAULT') == 'payubiz' ? 'checked' : ''), ['class' => 'custom-control-input', 'id'=>'payubiz']) !!}
                    {!! Form::label('payubiz', null, ['class' => 'custom-control-label']) !!}
                  </div>
                </div>       
                <div class="form-group{{ $errors->has('PAYU_MERCHANT_KEY') ? ' has-error' : '' }}">
                  <label for="PAYU_MERCHANT_KEY">{{  __('adminWords.merchant_key') }}<sup>*</sup></label>
                  {!! Form::text('PAYU_MERCHANT_KEY', env('PAYU_MERCHANT_KEY'), ['class' => 'form-control', 'placeholder' => __('adminWords.enter').' '.__('adminWords.merchant_key') ]) !!}
                  <small class="text-danger">{{ $errors->first('PAYU_MERCHANT_KEY') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('PAYU_MERCHANT_SALT') ? ' has-error' : '' }}">
                  <label for="PAYU_MERCHANT_SALT">{{  __('adminWords.merchant_salt') }}<sup>*</sup></label>
                  <input type="text" name="PAYU_MERCHANT_SALT" value="{{ env('PAYU_MERCHANT_SALT') }}" id="PAYU_MERCHANT_SALT" class="form-control" placeholder="{{ __('adminWords.enter').' '.__('adminWords.merchant_salt') }}">
                  <small class="text-danger">{{ $errors->first('MERCHANT_SALT') }}</small>
                </div>
                <div class="form-group{{ $errors->has('PAYU_AUTH_HEADER') ? ' has-error' : '' }}">
                  <label for="PAYU_AUTH_HEADER">{{  __('adminWords.auth_header') }}<sup>*</sup></label>
                  <input type="text" name="PAYU_AUTH_HEADER" value="{{ env('PAYU_AUTH_HEADER') }}" id="PAYU_AUTH_HEADER" class="form-control" placeholder="{{ __('adminWords.enter').' '.__('adminWords.auth_header') }}">
                  <small class="text-danger">{{ $errors->first('PAYU_AUTH_HEADER') }}</small>
                </div>

                <div class="form-group{{ $errors->has('PAY_U_MONEY_ACC') ? ' has-error' : '' }} switch-main-block">
                    <div class="row">
                      <div class="col-lg-3">
                        {!! Form::label('PAY_U_MONEY_ACC', __('adminWords.payu_money_acc')) !!}
                      </div>
                      
                      <div class="col-lg-2">
                          {!! Form::checkbox('PAY_U_MONEY_ACC', 1, (env('PAY_U_MONEY_ACC') != '' && env('PAY_U_MONEY_ACC') == 'true' ? 1 : 0), ['class' => 'js-switch-primary']) !!}
                      </div>
                    </div>
                    <div class="col-xs-12">
                      <small class="text-danger">{{ $errors->first('PAY_U_MONEY_ACC') }}</small>
                    </div>
                </div>

              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div> 
          </div>
        </div>
      {!! Form::close() !!}

      {!! Form::open(['method' => 'POST', 'route'=>['api.update','paytm']]) !!}
         <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.paytm_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_paytm', 1, isset($settings['is_paytm']) ? $settings['is_paytm'] : null, ['class' => 'custom-control-input updateSettings', 'required-id'=>'#PAYTM_ENVIRONMENT, #PAYTM_MERCHANT_ID, #PAYTM_MERCHANT_KEY, #btsecret', 'data-type'=>'is_paytm', 'data-id'=>"bt_box", 'data-name'=>'is_paytm' ,'id'=>'bt_check', 'data-name' => 'paytm']) !!}
                    <label class="custom-control-label" for="bt_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="bt_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-6">
                <div class="form-group{{ $errors->has('PAYTM_ENVIRONMENT') ? ' has-error' : '' }}">
                  <label for="PAYTM_ENVIRONMENT">{{  __('adminWords.paytm_env') }}<sup>*</sup></label>
                  {!! Form::text('PAYTM_ENVIRONMENT', env('PAYTM_ENVIRONMENT'), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYTM_ENVIRONMENT') }}</small>
                </div>
              </div>               
              <div class="col-lg-6">
                <div class="form-group{{ $errors->has('PAYTM_MERCHANT_ID') ? ' has-error' : '' }}">
                  <label for="PAYTM_MERCHANT_ID">{{  __('adminWords.paytm_id') }}<sup>*</sup></label>
                  {!! Form::text('PAYTM_MERCHANT_ID', env('PAYTM_MERCHANT_ID'), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYTM_MERCHANT_ID') }}</small>
                </div>  
              </div>               
              <div class="col-lg-6">
                <div class="form-group{{ $errors->has('PAYTM_MERCHANT_KEY') ? ' has-error' : '' }}">
                  <label for="PAYTM_MERCHANT_KEY">{{  __('adminWords.paytm_key') }}<sup>*</sup></label>
                  {!! Form::text('PAYTM_MERCHANT_KEY', env('PAYTM_MERCHANT_KEY'), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYTM_MERCHANT_KEY') }}</small>
                </div>  
              </div>               
              <div class="col-lg-6">                     
                <div class="form-group{{ $errors->has('PAYTM_MERCHANT_WEBSITE') ? ' has-error' : '' }}">
                  <label for="PAYTM_MERCHANT_WEBSITE">{{  __('adminWords.paytm_website') }}<sup>*</sup></label>
                  <input type="password" name="PAYTM_MERCHANT_WEBSITE" value="{{ env('PAYTM_MERCHANT_WEBSITE') }}" id="btsecret" class="form-control" placeholder="{{ __('Paytm Merchan Website')}}">
                  <span toggle="#btsecret" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('PAYTM_MERCHANT_WEBSITE') }}</small>
                </div>
              </div>                  
              <div class="col-lg-12"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
      {!! Form::open(['method' => 'POST', 'route'=>['api.update','stripe']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.stripe_settings') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_stripe', 1, isset($settings['is_stripe']) ? $settings['is_stripe'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"stripe_box", 'required-id'=>'#STRIPE_CLIENT_ID, #STRIPE_SECRET', 'data-type'=>'is_stripe', 'id'=>'stripe_check', 'data-name' => 'stripe']) !!}
                    <label class="custom-control-label" for="stripe_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="stripe_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('STRIPE_CLIENT_ID') ? ' has-error' : '' }}">
                  <label for="STRIPE_CLIENT_ID">{{ __('adminWords.stripe_id') }}<sup>*</sup></label>
                  {!! Form::text('STRIPE_CLIENT_ID', (env('STRIPE_CLIENT_ID') ? env('STRIPE_CLIENT_ID') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('STRIPE_CLIENT_ID') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('STRIPE_SECRET') ? ' has-error' : '' }}">
                  <label for="STRIPE_SECRET">{{ __('adminWords.stripe_secret') }}<sup>*</sup></label>
                  <input type="password" name="STRIPE_SECRET" value="{{ env('STRIPE_SECRET') }}" id="STRIPE_SECRET" class="form-control" placeholder="{{ __('Stripe Secret')}}">
                  <span toggle="#STRIPE_SECRET" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('STRIPE_SECRET') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __(' adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
      {!! Form::open(['method' => 'POST', 'route'=>['api.update','instamojo']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.instmojo_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_instamojo', 1, isset($settings['is_instamojo']) ? $settings['is_instamojo'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"instamojo_box", 'required-id'=>'#IM_API_KEY, #IM_AUTH_TOKEN, #IM_URL', 'data-type'=>'is_instamojo', 'id'=>'instamojo_check', 'data-name' => 'instamojo']) !!}
                    <label class="custom-control-label" for="instamojo_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="instamojo_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('IM_API_KEY') ? ' has-error' : '' }}">
                  <label for="IM_API_KEY">{{ __('adminWords.instamojo_key') }}<sup>*</sup></label>
                  {!! Form::text('IM_API_KEY', (env('IM_API_KEY') ? env('IM_API_KEY') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('IM_API_KEY') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('IM_AUTH_TOKEN') ? ' has-error' : '' }}">
                  <label for="IM_AUTH_TOKEN">{{ __('adminWords.instamojo_token') }}<sup>*</sup></label>
                  <input type="password" name="IM_AUTH_TOKEN" value="{{ env('IM_AUTH_TOKEN') }}" id="IM_AUTH_TOKEN" class="form-control" placeholder="{{ __('IM_AUTH_TOKEN')}}">
                  <span toggle="#IM_AUTH_TOKEN" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('IM_AUTH_TOKEN') }}</small>
                </div>
                <div class="form-group{{ $errors->has('IM_URL') ? ' has-error' : '' }}">
                  <label for="IM_URL">{{ __('adminWords.instamojo_url') }}<sup>*</sup></label>
                  <input type="text" name="IM_URL" value="{{ env('IM_URL') }}" id="IM_URL" class="form-control" data-valid="url" data-error="Invalid URL." placeholder="{{ __('IM_URL')}}">
                  <small class="text-danger">{{ $errors->first('IM_URL') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
      {!! Form::open(['method' => 'POST', 'route'=>['api.update','paystack']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.paystack_setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_paystack', 1, isset($settings['is_paystack']) ? $settings['is_paystack'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"paystack_box", 'required-id'=>'#PAYSTACK_PUBLIC_KEY, #PAYSTACK_SECRET_KEY, #PAYSTACK_PAYMENT_URL, #MERCHANT_EMAIL', 'data-type'=>'is_paystack', 'id'=>'paystack_check', 'data-name' => 'paystack']) !!}
                    <label class="custom-control-label" for="paystack_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="paystack_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('PAYSTACK_PUBLIC_KEY') ? ' has-error' : '' }}">
                  <label for="PAYSTACK_PUBLIC_KEY">{{  __('adminWords.paystack_public_key') }}<sup>*</sup></label>
                  {!! Form::text('PAYSTACK_PUBLIC_KEY', (env('PAYSTACK_PUBLIC_KEY') ? env('PAYSTACK_PUBLIC_KEY') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('PAYSTACK_PUBLIC_KEY') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('PAYSTACK_SECRET_KEY') ? ' has-error' : '' }}">
                  <label for="PAYSTACK_SECRET_KEY">{{  __('adminWords.paystack_secret') }}<sup>*</sup></label>
                  <input type="password" name="PAYSTACK_SECRET_KEY" value="{{ env('PAYSTACK_SECRET_KEY') }}" class="form-control" placeholder="{{ __('PAYSTACK_SECRET_KEY')}}">
                  <span toggle="#PAYSTACK_SECRET_KEY" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('PAYSTACK_SECRET_KEY') }}</small>
                </div>
                <div class="form-group{{ $errors->has('PAYSTACK_PAYMENT_URL') ? ' has-error' : '' }}">
                  <label for="PAYSTACK_PAYMENT_URL">{{  __('adminWords.paystack_url') }}<sup>*</sup></label>
                  <input type="text" name="PAYSTACK_PAYMENT_URL" value="{{ env('PAYSTACK_PAYMENT_URL') }}" class="form-control" data-valid="url" data-error="Invalid URL." placeholder="{{ __('PAYSTACK_PAYMENT_URL')}}">
                  <small class="text-danger">{{ $errors->first('PAYSTACK_PAYMENT_URL') }}</small>
                </div>
                <div class="form-group{{ $errors->has('MERCHANT_EMAIL') ? ' has-error' : '' }}">
                  <label for="MERCHANT_EMAIL">{{  __('adminWords.merchant_email') }}<sup>*</sup></label>
                  <input type="text" name="MERCHANT_EMAIL" value="{{ env('MERCHANT_EMAIL') }}" class="form-control" data-valid="email" data-error="Invalid email." placeholder="{{ __('MERCHANT_EMAIL')}}">
                  <small class="text-danger">{{ $errors->first('MERCHANT_EMAIL') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}

      {!! Form::open(['method' => 'POST', 'route'=>['api.update','braintree']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.braintree').' '.__('adminWords.setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_braintree', 1, isset($settings['is_braintree']) ? $settings['is_braintree'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"braintree_box", 'required-id'=>'#BRAINTREE_ENV, #BRAINTREE_MERCHANT_ID, #BRAINTREE_PUBLIC_KEY, #BRAINTREE_PRIVATE_KEY', 'data-type'=>'is_braintree', 'id'=>'braintree_check', 'data-name' => 'braintree']) !!}
                    <label class="custom-control-label" for="braintree_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="braintree_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                <div class="form-group{{ $errors->has('BRAINTREE_ENV') ? ' has-error' : '' }}">
                  <label for="BRAINTREE_ENV">{{ __('adminWords.braintree').' '.__('adminWords.env') }}<sup>*</sup></label>
                  {!! Form::text('BRAINTREE_ENV', (env('BRAINTREE_ENV') ? env('BRAINTREE_ENV') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('BRAINTREE_ENV') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('BRAINTREE_MERCHANT_ID') ? ' has-error' : '' }}">
                  <label for="BRAINTREE_MERCHANT_ID">{{ __('adminWords.braintree').' '.__('adminWords.merchant_id') }}<sup>*</sup></label>
                  {!! Form::text('BRAINTREE_MERCHANT_ID', (env('BRAINTREE_MERCHANT_ID') ? env('BRAINTREE_MERCHANT_ID') : null), ['class' => 'form-control']) !!}
                  <small class="text-danger">{{ $errors->first('BRAINTREE_MERCHANT_ID') }}</small>
                </div>                      
                <div class="form-group{{ $errors->has('BRAINTREE_PUBLIC_KEY') ? ' has-error' : '' }}">
                  <label for="BRAINTREE_PUBLIC_KEY">{{ __('adminWords.braintree').' '.__('adminWords.public_key') }}<sup>*</sup></label>
                  <input type="password" name="BRAINTREE_PUBLIC_KEY" value="{{ env('BRAINTREE_PUBLIC_KEY') }}" class="form-control" placeholder="{{ __('BRAINTREE_PUBLIC_KEY')}}">
                  <span toggle="#BRAINTREE_PUBLIC_KEY" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('BRAINTREE_PUBLIC_KEY') }}</small>
                </div>
                <div class="form-group{{ $errors->has('BRAINTREE_PRIVATE_KEY') ? ' has-error' : '' }}">
                  <label for="BRAINTREE_PRIVATE_KEY">{{ __('adminWords.braintree').' '.__('adminWords.private_key') }}<sup>*</sup></label>
                  <input type="password" name="BRAINTREE_PRIVATE_KEY" value="{{ env('BRAINTREE_PRIVATE_KEY') }}" class="form-control" placeholder="{{ __('BRAINTREE_PRIVATE_KEY')}}">
                  <span toggle="#BRAINTREE_PRIVATE_KEY" class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                  <small class="text-danger">{{ $errors->first('BRAINTREE_PRIVATE_KEY') }}</small>
                </div>
              </div>                  
              <div class="col-lg-10"> 
                <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                <div class="clear-both"></div>
              </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}


      {!! Form::open(['method' => 'POST', 'route'=>['api.update','manual_pay']]) !!}
        <div class="card m-b-30">
          <div class="card-header">
            <div class="row">
              <div class="col-lg-8">
                <h5>{{ __('adminWords.manual_pay').' '.__('adminWords.setting') }}</h5>
              </div>
              <div class="col-lg-4 text-right">
                <div class="form-group">
                  <div class="custom-switch">
                    {!! Form::checkbox('is_manual_pay', 1, isset($settings['is_manual_pay']) ? $settings['is_manual_pay'] : null, ['class' => 'custom-control-input updateSettings', 'data-id'=>"manual_box", 'required-id'=>'', 'data-type'=>'is_manual_pay', 'id'=>'manual_check', 'data-name' => 'manual_pay']) !!}
                    <label class="custom-control-label" for="manual_check"></label>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="manual_box" class="card-body">
            <div class="row">                    
              <div class="col-lg-10">
                  <div id="bank_transfer_field">
                    <div class="form-group{{ $errors->has('BANK_NAME') ? ' has-error' : '' }}">
                      <label for="BANK_NAME">{{ __('adminWords.bank_name') }}<sup>*</sup></label>
                      {!! Form::text('BANK_NAME', isset($settings['BANK_NAME']) ? $settings['BANK_NAME'] : null, ['class' => 'form-control require']) !!}
                      <small class="text-danger">{{ $errors->first('BANK_NAME') }}</small>
                    </div>                      
                    <div class="form-group{{ $errors->has('BRANCH_NAME') ? ' has-error' : '' }}">
                      <label for="BRANCH_NAME">{{ __('adminWords.branch_name') }}<sup>*</sup></label>
                      {!! Form::text('BRANCH_NAME', isset($settings['BRANCH_NAME']) ? $settings['BRANCH_NAME'] : null, ['class' => 'form-control require']) !!}
                      <small class="text-danger">{{ $errors->first('BRANCH_NAME') }}</small>
                    </div>                      
                    <div class="form-group{{ $errors->has('IFSC_CODE') ? ' has-error' : '' }}">
                      <label for="IFSC_CODE">{{ __('adminWords.ifsc_code') }}</label>
                      <input type="text" name="IFSC_CODE" value="{{ isset($settings['IFSC_CODE']) ? $settings['IFSC_CODE'] : null }}" class="form-control" id="IFSC_CODE" placeholder="{{ __('IFSC_CODE')}}">
                      <small class="text-danger">{{ $errors->first('IFSC_CODE') }}</small>
                    </div>
                    <div class="form-group{{ $errors->has('SWIFT_CODE') ? ' has-error' : '' }}">
                      <label for="SWIFT_CODE">{{ __('adminWords.swift_code') }}</label>
                      <input type="text" name="SWIFT_CODE" value="{{ isset($settings['SWIFT_CODE']) ? $settings['SWIFT_CODE'] : null }}" class="form-control" id="SWIFT_CODE" placeholder="{{ __('SWIFT_CODE')}}">
                      <small class="text-danger">{{ $errors->first('SWIFT_CODE') }}</small>
                    </div>
                    <div class="form-group{{ $errors->has('ACCOUNT_NUMBER') ? ' has-error' : '' }}">
                      <label for="ACCOUNT_NUMBER">{{ __('adminWords.acc_no') }}<sup>*</sup></label>
                      <input type="text" name="ACCOUNT_NUMBER" value="{{ isset($settings['ACCOUNT_NUMBER']) ? $settings['ACCOUNT_NUMBER'] : null }}" class="form-control require" id="ACCOUNT_NUMBER" placeholder="{{ __('ACCOUNT_NUMBER')}}">
                      <small class="text-danger">{{ $errors->first('ACCOUNT_NUMBER') }}</small>
                    </div>
                    <div class="form-group{{ $errors->has('ACCOUNT_NAME') ? ' has-error' : '' }}">
                      <label for="ACCOUNT_NAME">{{ __('adminWords.acc_name') }}<sup>*</sup></label>
                      <input type="text" name="ACCOUNT_NAME" value="{{ isset($settings['ACCOUNT_NAME']) ? $settings['ACCOUNT_NAME'] : null }}" class="form-control require" id="ACCOUNT_NAME" placeholder="{{ __('ACCOUNT_NAME')}}">
                      <small class="text-danger">{{ $errors->first('ACCOUNT_NAME') }}</small>
                    </div>
                  </div>
                </div>                  
                <div class="col-lg-10"> 
                  <button type="button" class="btn btn-success" data-action="submitThisForm" title="{{ __('adminWords.save_setting_btn') }}">{{ __('adminWords.save_setting_btn') }}</button>
                  <div class="clear-both"></div>
                </div>
            </div>
          </div>
        </div>
      {!! Form::close() !!}
    </div>
  </div>
</div>
@endsection 
@section('script')
  <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
  <script src="{{asset('assets/js/mrcls-custom.js?'.time())}}"></script>
@endsection
