@extends('layouts.admin.main')
@section('title', __('adminWords.admin').' '.__('adminWords.setting'))
@section('rightbar-content')
               
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-7 col-lg-7">
            <h4 class="page-title">{{ __('adminWords.admin').' '.__('adminWords.setting') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.setting')}}">{{ __('adminWords.admin').' '.__('adminWords.setting') }}</a></li>
                </ol>
            </div>
        </div>      
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <form action="{{ url('dashbord-setting') }}" method="POST" class="card admin_setting_form">
                <div class="table-responsive ">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>{{ __('adminWords.widget_name') }}</th>
                                <th>{{ __('adminWords.action') }}</th>
                                <th>{{ __('adminWords.max_item') }}</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td>{{ __('adminWords.latest_subs') }}</td>
                                <td>
                                    <div class="custom-switch">
                                        <input id="switch1" class="custom-control-input enableDisableSettng" {{ (!empty($settings) && isset($settings['latest_subs']) && $settings['latest_subs'] == 1 ? 'checked' : '' ) }} name="latest_subs" type="checkbox" placeholder="{{ __('checkboxAll') }}">
                                        <label class="custom-control-label" for="switch1"></label>
                                    </div>
                                </td>
                                <td class="numberOfItem {{ (!empty($settings) && isset($settings['latest_subs']) && $settings['latest_subs'] == 0 ? 'd-none' : (!empty($settings) && !isset($settings['latest_subs']) ? 'd-none' : '') ) }}">
                                    <input class="wid require" min="1" name="max_latest_subs" type="number" value="{{ (!empty($settings) && isset($settings['latest_subs']) && $settings['latest_subs'] == 1 ? $settings['max_latest_subs'] : 1 ) }}" placeholder="{{ __('Max latest Subs')}}">
                                </td>                        
                            </tr>

                            <tr>
                                <td>{{ __('frontWords.recently_added').' '.__('frontWords.track') }}</td>
                                <td>
                                    <div class="custom-switch">
                                        <input id="switch2" class="custom-control-input enableDisableSettng" {{ (!empty($settings) && isset($settings['rcnt_add_track']) && $settings['rcnt_add_track'] == 1 ? 'checked' : '' ) }}  name="rcnt_add_track" type="checkbox" placeholder="{{ __('checkboxAll') }}">
                                        <label class="custom-control-label" for="switch2"></label>
                                    </div>
                                </td>
                                <td class="numberOfItem {{ (!empty($settings) && isset($settings['rcnt_add_track']) && $settings['rcnt_add_track'] == 0 ? 'd-none' : (!empty($settings) && !isset($settings['rcnt_add_track']) ? 'd-none' : '') ) }}">
                                    <input class="wid require" min="1" name="max_rcnt_add_track" type="number" value="{{ (!empty($settings) && isset($settings['rcnt_add_track']) && $settings['rcnt_add_track'] == 1 ? $settings['max_rcnt_add_track'] : 1 ) }}"  placeholder="{{ __('adminWords.max_rcnt_add_track_') }}">
                                </td>
                            </tr>

                            <tr>
                                <td>{{ __('frontWords.recently_added').' '.__('frontWords.album') }}</td>
                                <td>
                                    <div class="custom-switch">
                                        <input id="switch3" class="custom-control-input enableDisableSettng" {{ (!empty($settings) && isset($settings['rcnt_add_album']) && $settings['rcnt_add_album'] == 1 ? 'checked' : 0 ) }} name="rcnt_add_album" type="checkbox"  placeholder="{{ __('checkboxAll') }}" >
                                        <label class="custom-control-label" for="switch3"></label>
                                    </div>
                                </td>
                    
                                <td class="numberOfItem {{ (!empty($settings) && isset($settings['rcnt_add_album']) && $settings['rcnt_add_album'] == 0 ? 'd-none' : (!empty($settings) && !isset($settings['rcnt_add_album']) ? 'd-none' : '') ) }}">
                                    <input class="wid require" min="1" name="max_rcnt_add_album" type="number" value="{{ (!empty($settings) && isset($settings['rcnt_add_album']) && $settings['rcnt_add_album'] == 1 ? $settings['max_rcnt_add_album'] : 1 ) }}"  placeholder="{{ __('adminWords.max_rcnt_add_album') }}">
                                </td>
                            </tr>

                            <tr>
                                <td>{{ __('frontWords.recent_user') }}</td>
                                <td>
                                    <div class="custom-switch">
                                        <input id="switch4" class="custom-control-input enableDisableSettng" {{ (!empty($settings) && isset($settings['rcnt_add_user']) && $settings['rcnt_add_user'] == 1 ? 'checked' : '' ) }} name="rcnt_add_user" type="checkbox" placeholder="{{ __('checkboxAll') }}" >
                                        <label class="custom-control-label" for="switch4"></label>
                                    </div>
                                </td>
                    
                                <td class="numberOfItem {{ (!empty($settings) && isset($settings['rcnt_add_user']) && $settings['rcnt_add_user'] == 0 ? 'd-none' : (!empty($settings) && !isset($settings['rcnt_add_user']) ? 'd-none' : '') ) }}">
                                    <input class="wid require" min="1" name="max_rcnt_add_user" type="number" value="{{ (!empty($settings) && isset($settings['rcnt_add_user']) && $settings['rcnt_add_user'] == 1 ? $settings['max_rcnt_add_user'] : 1 ) }}" placeholder="{{ __('adminWords.max_rcnt_add_user') }}">
                                </td>                        
                            </tr>
                        </tbody>
                    </table>
                    <button type="button" data-action="submitThisForm" class="btn btn-success" title="{{ __('adminWords.save_setting_btn') }}"> {{ __('adminWords.save_setting_btn') }}</button>                   
                </div>
            </form>
        </div>
    </div>
</div>
@endsection 
@section('script')
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection 
