@extends('layouts.admin.main')
@section('title', __('adminWords.menu'))
@section('style')
  <link href="{{asset('assets/plugins/summernote/summernote-bs4.css')}}" rel="stylesheet" type="text/css"/>
  <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('rightbar-content')
  <div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ __('adminWords.menu')}}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/menu')}}" title="{{ __('adminWords.menu')}}">{{ __('adminWords.menu')}}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">  
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('menusetting') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{ (isset($menuData)) ?__('adminWords.update').' '.__('adminWords.menu') : __('adminWords.create').' '.__('adminWords.menu')}}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="admin-form"> 
                      @if(isset($menuData) )
                        {!! Form::model($menuData, ['method'=>'post', 'files'=>true, 'id'=>'updateMenu', 'route' => ['menu.save', $menuData->id], 'data-redirect' => url('/menusetting')]) !!} 
                      @else
                        {!! Form::open(['method' => 'POST','files' => true, 'route' => ['menu.save', 'add'], 'data-reset'=>1, 'data-redirect' => url('/menusetting')]) !!}
                      @endif
                          
                          <div class="form-group{{ $errors->has('menu_heading') ? ' has-error' : '' }}">
                            <label for="menu_heading">{{ __('adminWords.menu_heading') }}<sup>*</sup></label>
                            {!! Form::text('menu_heading', null, ['class' => 'form-control require', 'required','placeholder'=>__('adminWords.enter').' '.__('adminWords.menu_heading')]) !!}
                            <small class="text-danger">{{ $errors->first('menu_heading') }}</small>
                          </div> 
                          
                          <div class="form-group{{ $errors->has('page_id') ? ' has-error' : '' }}">
                            <label for="page_id">{{  __('adminWords.select').' '.__('adminWords.page') }}<sup>*</sup></label>
                            {!! Form::select('page_id', $pages, (!empty($menuData) ? $menuData->page_id : ''), ['class' => 'form-control select2 require','required','placeholder'=>__('adminWords.select').' '.__('adminWords.page') ]) !!}
                            <small class="text-danger">{{ $errors->first('page_id') }}</small>
                          </div>

                          <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                            <div class="row">
                              <div class="col-lg-3">
                                {!! Form::label('Status', __('adminWords.status')) !!}
                              </div>
                              
                              <div class="col-lg-2">
                                  {!! Form::checkbox('status', 1, (isset($menuData) &&   $menuData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                              </div>
                            </div>
                            <div class="col-xs-12">
                              <small class="text-danger">{{ $errors->first('status') }}</small>
                            </div>
                          </div>
                         
                          <div class="form-group">      
                              @if(!isset($menuData))
                                <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset')}}</button>
                              @endif  
                              <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{isset($menuData) ? __('adminWords.update') : __('adminWords.add')}}"><i class="fa fa-check-circle"></i> {{isset($menuData) ? __('adminWords.update') : __('adminWords.add')}}</button>        
                          </div>
                          <div class="clear-both"></div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{asset('assets/plugins/summernote/summernote-bs4.min.js')}}"></script>
<script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
<script src="{{asset('assets/js/mrcls-custom.js')}}"></script>
@endsection
