<?php
namespace Modules\Setting\Http\Controllers;
use DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Carbon;
use Modules\Setting\Entities\Notification;
use App\User;
use Modules\Album\Entities\Album;
use Modules\Setting\Entities\Currency;
use Modules\Setting\Entities\GoogleAd;
use Modules\General\Entities\Pages;
use Modules\Setting\Entities\Menu;
use Modules\Setting\Entities\Settings;
use DataTables;
use Stevebauman\Purify\Facades\Purify;
use App\Notifications\UserNotification;
use Jackiedo\DotenvEditor\Facades\DotenvEditor;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;


class SettingController extends Controller
{
    public function seo(){
        return view('setting::seo');
    }

    public function seo_update(Request $request){
        $data= $request->except('_token');
        $rules = [
            'author_name' => 'required',
            'keywords' => 'required',
            'meta_desc' => 'required',
        ];
        $checkValidate = validation($data, $rules);
        if($checkValidate['status'] == 1){
            $success = 0; $msg ='';
            foreach($data as $key=>$val){
                $date = date('Y-m-d h:i:s');
                $insert = updateOrInsert(['table'=>'settings', 'data'=>[['name'=>$key],['value'=>Purify::clean($val)],['created_at'=>$date],['updated_at'=>$date] ]]);
                $success = 1;
            }
            if($success == 1){
                $resp = array('status'=>1, 'msg'=>__('adminWords.seo').' '.__('adminWords.settings').' '.__('adminWords.success_msg') );
            }else{
                $resp = array('status'=>0, 'msg'=>__('adminWords.error_msg'));
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function seo_add(Request $request){
        $rules = ['name'=> 'required', 'value' => 'required'];
        $checkValidate = validation($request->all(), $rules);
        if($checkValidate['status'] == 1){
            $insert = insert(array('table'=>'settings', 'data'=>array('name'=>$request->name, 'value'=>$request->value)));
            if($insert)
                $resp = array('status'=>1, 'msg'=> __('adminWords.settings').' '.__('adminWords.success_msg') );
            else
                $resp = array('status'=>0, 'msg'=> __('adminWords.error_msg') );
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function site(){
        return view('setting::site');
    }

    public function site_update(Request $request){      
        $rules = [
            'logo' => 'nullable|image|mimes:jpg,jpeg,png',
            'preloader' => 'nullable|image|mimes:jpg,jpeg,png,gif',
            'favicon' => 'nullable|image|mimes:jpg,jpeg,png',
            'w_email' => 'nullable|email'
        ];
        $input = $request->except('_token');
        $checkValidate = validation($input, $rules);
        if($checkValidate['status'] == 1){
            $input['is_preloader'] = (!isset($input['is_preloader']) ? 0 : 1);
            $input['is_gotop'] = (!isset($input['is_gotop']) ? 0 : 1);
            $input['right_click'] = (!isset($input['right_click']) ? 0 : 1);
            $input['inspect'] = (!isset($input['inspect']) ? 0 : 1);
            $input['wel_mail'] = (!isset($input['wel_mail']) ? 0 : 1);
           
            
            if ($file = $request->file('logo')){
                $getData = select(['table'=>'settings', 'column'=>['name','value'], 'where'=>['name'=>'logo'],'single'=>1]);
                $name = 'logo.webp';
                if(!empty($getData)){
                    delete_file_if_exist(public_path().'/images/sites/'.$getData->value);    
                }
                upload_image($file, public_path().'/images/sites/', $name, '60x60');
                $input['logo'] = str_replace(' ','',$name);
            }

            if ($file = $request->file('preloader')){
                $getData = select(['table'=>'settings', 'column'=>['name','value'], 'where'=>['name'=>'preloader'],'single'=>1]);
                
                $name = 'preloader.webp';
                if(!empty($getData)){
                    delete_file_if_exist(public_path().'/images/sites/'.$getData->value);    
                }
                upload_image($file, public_path().'/images/sites/', $name, '100x100');
                $input['preloader'] = str_replace(' ','',$name);
            }
            if ($file = $request->file('favicon')){
                $getData = select(['table'=>'settings', 'column'=>['name','value'], 'where'=>['name'=>'favicon'],'single'=>1]);
                $name = 'favicon.webp';
                if(!empty($getData)){
                    delete_file_if_exist(public_path().'/images/sites/'.$getData->value);    
                }
                upload_image($file, public_path().'/images/sites/', $name, '34x34');
                $input['favicon'] = str_replace(' ','',$name);
            }
            $success = 0;
            foreach($input as $key => $val){
                if ($key == 'w_title') {
                    // Set the APP_NAME environment variable
                    DotenvEditor::setKey('APP_NAME', $val);
                
                    // Set the APP_DEBUG environment variable based on the request input
                    $debugValue = $request->input('APP_DEBUG') ? 'true' : 'false';
                    DotenvEditor::setKey('APP_DEBUG', $debugValue);
                
                    // Save the changes to the .env file
                    DotenvEditor::save();
                }
                
                if(!isset($val)){
                    $val = '';
                }
                $insert = updateOrInsert(['table'=>'settings', 'data'=>[['name'=>$key], ['value'=>$val]]]);
                $success = 1;
            }
            
            if($success == 1){
                $resp= array('status'=>1, 'msg'=>__('adminWords.settings').' '.__('adminWords.success_msg'));
            }else{
                $resp= array('status'=>0, 'msg'=>__('adminWords.error_msg'));
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
        
    }

    public function notifications(){ 
        $userData = User::pluck('name','id')->all();
        $userData = User::where('role','!=','1')->pluck('name','id')->all();
        $data['userData'] = [];
        if(sizeof($userData) > 0){
            $data['userData'] = ['all' => 'All'];
            foreach($userData as $key=>$value){
                $data['userData'][$key] = $value;
            }
        }
        return view('setting::notification', $data); 
    }

    public function notificationData(){
        $notification = select(['column' => ['notifications.id','notifications.notifiable_id','notifications.data','notifications.created_at', 'users.name'], 'table' => 'notifications', 'order'=>['notifications.created_at','desc'], 'join' => [['users','users.id','=','notifications.notifiable_id']] ]);
        $notify = [];
        if(sizeof($notification) > 0){
            foreach($notification as $noti){
                array_push($notify, ['user_id' => $noti->notifiable_id, 'id' => $noti->id, 'message' => json_decode($noti->data)->data ,'created_at' => $noti->created_at, 'user_name' => $noti->name]);
            }
        }
        return DataTables::of($notify)
            ->editColumn('checkbox',function($notify){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$notify['id'].'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$notify['id'].'" data-user="'.$notify['user_id'].'"><label for="checkboxAll'.$notify['id'].'" class="custom-control-label"></label></div>';
            })
            ->editColumn('created_at', function($notify){
                return Carbon::parse($notify['created_at'])->diffForHumans(Carbon::now());
            })
            ->addColumn('action', function ($notify){
                return '<div class="button-list"><button type="button" data-url="'.url('notification/destroy/'.$notify['id'].'/'.$notify['user_id']).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','action'])->make(true);
    }

    public function destroyNotification($noti_id, $user_id){
        $user = User::find($user_id);
        $delete = $user->notifications()->where('id', $noti_id)->get()->first()->delete();
        if($delete){
            $resp = ['status' => 1, 'msg' => __('adminWords.notification').' '.__('adminWords.delete_success')];
        }else{
            $resp = ['status' => 0, 'msg' => __('adminWords.error_msg')];
        }
        echo json_encode($resp);
    }

    public function bulkDeleteNotification(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').' '.__('adminWords.notification').' '.__('adminWords.must_selected') );
        if($checkValidate['status'] == 1){
            $notification_id = $request->checked;
            for($i=0; $i<sizeof($notification_id); $i++){
                $user = User::find($request->user_id[$i]);
                $delete = $user->notifications()->where('id', $notification_id[$i])->get()->first()->delete();
            }            
            $resp = ['status' => 1, 'msg' => __('adminWords.notification').' '.__('adminWords.delete_success')];
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }


    public function showAddNotification(){
        $data['albumData'] = Album::pluck('album_name','id')->all();
        $data['userData'] = User::pluck('name','id')->all();
        return view('setting::index', $data);
    }

    public function addNotification(Request $request){
        $rules = [ 'user_id' => 'required', 'message' => 'required' ];
        $checkValidate = validation($request->except('_token'), $rules);
        if($checkValidate['status'] == 1){
            $data = $request->except('_token');
            $index = array_search('all',$request->user_id);
            
            if($index == 0){
                $users = User::all();
            }else if(sizeof($request->user_id) > 1){
                $userid = $request->user_id;
                $users = [];
                for($i=0; $i<sizeof($userid); $i++){
                    array_push($users, User::find($userid[$i]));
                }
            }else{
                $users = User::find($request->user_id);
            }
            
            \Notification::send($users, new UserNotification($request->message));
            $data['user_id'] = json_encode($request->user_id);
            $resp = array('status'=>1, 'msg'=>__('adminWords.notification').' '.__('adminWords.success_msg'));
        }else{
           $resp = $checkValidate;
        }
       echo json_encode($resp);
    }

    public function tax(){
        return view('setting::tax');
    }

    public function saveTax(Request $request){
        $checkValidate = validation($request->except('_token'), ['tax' => 'required']);
        if($checkValidate['status'] == 1){
            foreach($request->except('_token') as $key=>$val){
                $insert = Settings::updateOrCreate(['name'=>$key],['value'=>$val]);
                $success = 1;
            }
            $resp = ['status' => 1, 'msg' => __('adminWords.data').' '.__('adminWords.success_msg')];            
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);        
    }


    public function google_ad(){
        $data['google_ad'] = GoogleAd::all();
        return view('setting::google_ad', $data);
    }

    public function saveGoogleAd(Request $request, $id){
        $checkValidate = validation($request->except('_token'), ['google_ad_script' => 'required']);
        if($checkValidate['status'] == 1){
            $checkScript = (is_numeric($id) ? GoogleAd::find($id) : []);             
            if(!empty($checkScript)){
                $saveAd = GoogleAd::where('id', $checkScript->id)->update(['google_ad_script' => $request->google_ad_script, 'status' => 1]);
            }else{
                $saveAd = GoogleAd::create(['google_ad_script' => $request->google_ad_script, 'status' => 1]);
            }
            $resp = ['status' => 1, 'msg' => __('adminWords.google_adsense_script').' '.__('adminWords.success_msg') ];
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function changeAdsenseStatus(Request $request, $id){
        $checkValidate = validation($request->except('_token'),['status'=>'required']);
        if($checkValidate['status'] == 1){
            $checkScript = (is_numeric($id) ? GoogleAd::find($id) : []);     
            if(!empty($checkScript)){
                $saveAd = $checkScript->update(['status' => 0]);
            }
            $resp = ['status'=>1,'msg'=>__('adminWords.data').' '.__('adminWords.success_msg')];
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function common_setting(){
        return view('setting::commonSetting');
    }

    public function saveCommonSetting(Request $request, $type){
        $data= $request->except('_token');
        if($type == 'footer'){
            $rules = [ 'section_1_heading' => 'required', 'section_1_description' => 'required', 'section_2_heading' => 'required', 'section_2_description' => 'required', 'section_3_heading' => 'required', 'section_3_description' => 'required', 'section_4_heading' => 'required', 'w_address' => 'required', 'w_email' => 'required', 'w_phone' => 'required', 'facebook_url' => 'required', 'linkedin_url' => 'required', 'twitter_url' => 'required', 'google_plus_url' => 'required', 'copyrightText' => 'required' ];
        }else{
            $rules = [ 'header_title' => 'required' , 'header_description' => 'required' ];
        }
        $checkValidate = validation($data, $rules);
        if($checkValidate['status'] == 1){
            $success = 0; $msg ='';
            foreach($data as $key=>$val){
                $date = date('Y-m-d h:i:s');
                $insert = updateOrInsert(['table'=>'settings', 'data'=>[['name'=>$key],['value'=>Purify::clean($val)],['created_at'=>$date],['updated_at'=>$date] ]]);
                if($insert)
                    $success = 1;
            }
            if($success == 1){
                $resp = array('status'=>1, 'msg'=> __('adminWords.settings').' '.__('adminWords.success_msg') );
            }else{
                $resp = array('status'=>0, 'msg'=>__('adminWords.error_msg'));
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function menuSetting(){
        return view('setting::menu');
    }

    public function create_menu(){
        $data['pages'] = Pages::where('is_active', 1)->pluck('title', 'id')->all();
        return view('setting::addMenu', $data);
    }

    public function menuData(){
        $menus = select(['table'=>'menus','column'=>['menus.menu_heading', 'menus.id', 'menus.status', 'pages.title'], 'order'=>['id','desc'], 'join'=>[['pages', 'menus.page_id', '=', 'pages.id']] ]);
        $menu = [];
        if(sizeof($menus) > 0){
            foreach($menus as $menuData){
                array_push($menu, ['menu_heading' => $menuData->menu_heading, 'page_name' => $menuData->title, 'id' => $menuData->id, 'status' => $menuData->status]);
            }
        }
        return DataTables::of($menu)
        ->editColumn('checkbox', function($menu){
            return '<div class="inline custom-checkbox"><input id="checkboxAll'.$menu['id'].'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$menu['id'].'"><label for="checkboxAll'.$menu['id'].'" class="custom-control-label"></label></div>';
        })
        ->editColumn('status', function($menu){
            return '<div class="custom-switch"><input id="switch'.$menu['id'].'" class="custom-control-input changeStatus" '.($menu['status'] == 1 ? 'checked':'').' type="checkbox" data-url="'.url('update_menu_status/'.$menu['id']).'"><label class="custom-control-label" for="switch'.$menu['id'].'"></label></div>';
        })
        ->editColumn('action', function($menu){
            return '<div class="button-list"><a class="btn btn-sm btn-success-rgba blogCategoryPopup" href="'.url('edit_menu/'.$menu['id']).'" ><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('destroyMenu/'.$menu['id']).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
        })
        ->rawColumns(['checkbox','status','action'])->make(true);
    }

    public function saveMenu(Request $request, $id){
        $checkValidate = validation($request->except('_token'), ['menu_heading' => 'required', 'page_id' => 'required']);
        if($checkValidate['status'] == 1){
            $data = $request->except('_token');
            $data['status'] = (isset($data['status']) ? 1 : 0);
            if(is_numeric($id)){
                $checkMenu = Menu::where([['id','!=',$id],['menu_heading','=',$request->menu_heading]])->get();
            }else{
                $checkMenu = Menu::where('menu_heading',$request->menu_heading)->get();
            }    
            if(count($checkMenu) > 0){
                $resp = ['status'=>0, 'msg'=>__('adminWords.menu').' '.__('adminWords.already_exist')];
            }else{
                $menu = (is_numeric($id) ? Menu::find($id) : []);
                if(!empty($menu)){
                    $update = $menu->update($data);
                    $msg = __('adminWords.menu').' '.__('adminWords.updated_msg');
                }else{
                    $update = Menu::create($data);
                    $msg = __('adminWords.menu').' '.__('adminWords.success_msg');
                }
                $resp = ['status'=>1, 'msg'=>$msg];
            }
            
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function edit_menu($id){
        $data['pages'] = Pages::where('is_active', 1)->pluck('title', 'id')->all();
        $data['menuData'] = Menu::find($id);
        return view('setting::addMenu', $data);
    }

    function updateMenuStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'menus', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function destroyMenu($id){
        $resp = singleDelete([ 'table'=>'menus','column'=>['menu_heading'], 'where'=>['id'=>$id], 'msg'=> __('adminWords.menu').' '.__('adminWords.delete_success') ]);
        echo $resp;        
    }

    function bulkDeleteMenu(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').__('adminWords.menu').__('adminWords.must_selected'));
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'menus','column'=>'id',  'msg'=>__('adminWords.menu').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function adminsetting(){
        return view('setting::admin');
    }

    public function dashboardSetting(Request $request){
        $rules = [];
        $data = $request->except('_token');
        if(isset($request->latest_subs)){
            $rules['max_latest_subs'] = 'numeric|min:1';
            $data['latest_subs'] = 1;
        }else{
            $data['latest_subs'] = 0;
        }
        if(isset($request->rcnt_add_track)){
            $rules['max_rcnt_add_track'] = 'numeric|min:1';
            $data['rcnt_add_track'] = 1;
        }else{
            $data['rcnt_add_track'] = 0;
        }
        if(isset($request->rcnt_add_album)){
            $rules['max_rcnt_add_album'] = 'numeric|min:1';
            $data['rcnt_add_album'] = 1;
        }else{
            $data['rcnt_add_album'] = 0;
        }
        if(isset($request->rcnt_add_user)){
            $rules['max_rcnt_add_user'] = 'numeric|min:1';
            $data['rcnt_add_user'] = 1;
        }else{
            $data['rcnt_add_user'] = 0;
        }
        $checkValidate = validation($data, $rules);
        if($checkValidate['status'] == 1){

            $success = 0; $msg ='';

            foreach($data as $key=>$val){
                $date = date('Y-m-d h:i:s');
                $insert = updateOrInsert(['table'=>'settings', 'data'=>[['name'=>$key],['value'=>Purify::clean($val)],['created_at'=>$date],['updated_at'=>$date] ]]);
                if($insert)
                    $success = 1;
            }
            if($success == 1){
                $resp = array('status'=>1, 'msg'=> __('adminWords.settings').' '.__('adminWords.success_msg') );
            }else{
                $resp = array('status'=>0, 'msg'=>__('adminWords.error_msg'));
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }


    public function currency_setting(){
        return view('setting::currency');
    }

    public function currencyData(){
        $curr = Currency::all();
        $setting = Settings::where('name', 'default_currency_id')->first();
        $currency = [];
        if(sizeof($curr) > 0){
            foreach($curr as $cur){
                $arr = ['id' => $cur->id, 'rate' => $cur->exchange_rate, 'symbol' => $cur->symbol, 'code' => $cur->code];
                $arr['curId'] = '';
                if(!empty($setting)){
                    $arr['curId'] = $setting->value;
                }
                array_push($currency, $arr);
            }
        }
        return DataTables::of($currency)
        ->addIndexColumn() 
        ->editColumn('code', function($currency){
            return $currency['code'].' '.($currency['curId'] != '' && $currency['curId'] == $currency['id'] ? '<span class="badge badge-success">Default</span>' : '');
        })
        ->editColumn('rate', function($currency){
            return $currency['rate'] ;
        })
        ->editcolumn('default_currency', function($currency){
            return '<input type="radio" class="currency_radio makeDefaultCurr" name="default_currency" value="'.$currency['id'].'" data-name="'.$currency['code'].'" '.($currency['curId'] != '' && $currency['curId'] == $currency['id'] ? 'checked' : ($currency['code'] == 'USD' ? 'checked' : '')).'>';
        })
        
        ->addColumn('action', function ($currency) {       
                return ($currency['curId'] != '' && $currency['curId'] == $currency['id']) || $currency['code'] == 'USD' ? '' : '<div class="button-list"><button type="button" data-url="'.url('currency/destroy/'.$currency['id']).'" data-msg="'.__('adminWords.delete_curr').$currency['code'].'?" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['default_currency', 'action', 'code'])->make(true);
    }

    public function currency_detail($id){
        $getCurrency = Currency::find($id);
        if(!empty($getCurrency)){
            $resp = ['status'=>1, 'data'=>$getCurrency];
        }else
            $resp = ['status'=>0, 'msg'=>__('adminWords.error_msg')];
        echo json_encode($resp);
    }

    public function saveCurrency(Request $request){
        $validate = validation($request->except('_token'), ['currency_code' => 'required|alpha|max:3']);
        if($validate['status'] == 1){
            try{
                if(!currency()->hasCurrency('USD')){
                    Artisan::call('currency:manage add USD,' . $request->currency_code);
                }else{
                    Artisan::call('currency:manage add ' . $request->currency_code);
                }

                $output = Artisan::output();
                
                if(!strstr($output,'success')){
                    echo json_encode(['status' =>0, 'msg' => $output]); exit;
                }
                Artisan::call('currency:update -o');
                echo json_encode(['status' => 1, 'msg' => __('adminWords.currency').' '.$request->currency_code.' '.__('adminWords.added').'.']); exit;
            }catch(\Exception $e){
                echo json_encode(['status' =>0 ,'msg' => $e->getMessage()]); exit;
            }
        }else{
            echo json_encode($validate); exit;
        }
    }

    public function updateCurrency(Request $request, $code){
        $validate = validation($request->except('_token'), ['currency_code' => 'required', 'additional_fee' => 'required']);
        if($validate['status'] == 1){
            $currency = Currency::where('code','=',$code)->first();
            if(!empty($currency)){
                $updateCur = $currency->update(['exchange_rate' => $request->additional_fee]);
                if($updateCur){
                    echo json_encode(['status' =>1, 'msg' => __('adminWords.currency').' '.$currency->code.' '.__('adminWords.updated').'.']); exit;
                }else{
                    echo json_encode(['status' =>0, 'msg' => __('adminWords.error_msg')]); exit;
                }
            }else{
                echo json_encode(['status' =>0, 'msg' => __('adminWords.currency_not_found')]); exit;
            }
        }else{
            echo json_encode($validate);
        }
    }

    public function auto_update_rate(Request $request){
        if($request->ajax()){
            try{
                Artisan::call('currency:update -o');
                echo json_encode(['status'=>1, 'msg' => __('adminWords.rate').' '.__('adminWords.updated_msg'), 'swal' => 1]); exit;
            }catch(\Exception $e){
                echo json_encode(['status'=>0, 'msg' => $e->getMessage(), 'swal' => 1]); exit;
            }   
        }
    }

    public function make_default_curr(Request $request){
        $validate = validation($request->except('_token'), ['id' => 'required']);
        if($validate['status'] == 1){
            Settings::updateOrCreate(['name'=>'default_currency_id'],['value'=>$request->id]);
            $resp = ['status' => 1, 'msg' => __('adminWords.data').' '.__('adminWords.success_msg')];
        }else{
            $resp = $validate;
        }
        echo json_encode($resp);
    }

    public function destroyCurrency($id){
        $checkCurr = Currency::find($id);
        if(!empty($checkCurr)){
            currency()->delete($checkCurr->code);
            echo json_encode(['status' => 1, 'msg' => __('adminWords.currency').' '.__('adminWords.delete_success')]);
        }else{
            echo json_encode(['status' => 0, 'msg' => __('adminWords.currency_not_found')]);
        }
    }
    public function appdebug(Request $request)
    {
         $env_update = DotenvEditor::setKeys([
             'APP_DEBUG' => $request->input('APP_DEBUG') ?'true' : 'false',
         ]);
        $env_update->save();
    }

    public function mailsetting(){
        return view('setting::mail');
    }

    /**
     * Method use to save mail setting.
     */
    public function savemailsetting(Request $request)
    {
        if (env('DEMO_LOCK') === '1') {
            return back()->with('success', __('This action is disabled in demo !'));
        }
    
        try {
            $request->validate([
                'MAIL_HOST' => 'required',
                'MAIL_PORT' => 'required',
                'MAIL_FROM_ADDRESS' => 'required',
                'MAIL_USERNAME' => 'required',
                'MAIL_PASSWORD' => 'required',
            ]);
    
            $setting = Settings::firstOrNew();
            $setting->welcome_status = $request->input('welcome_status') ? 1 : 0;
            $setting->verify_status = $request->input('verify_status') ? 1 : 0;
    
            // return $setting;
    
            $setting->save();
    
            $env_update = DotenvEditor::setKeys([
                // Update .env file with new values
                'MAIL_FROM_NAME' => $request->input('MAIL_FROM_NAME'),
                'MAIL_MAILER' => $request->input('MAIL_MAILER'),
                'MAIL_HOST' => $request->input('MAIL_HOST'),
                'MAIL_PORT' => $request->input('MAIL_PORT'),
                'MAIL_FROM_ADDRESS' => $request->input('MAIL_FROM_ADDRESS'),
                'MAIL_USERNAME' => $request->input('MAIL_USERNAME'),
                'MAIL_PASSWORD' => $request->input('MAIL_PASSWORD'),
                'MAIL_ENCRYPTION' => $request->input('MAIL_ENCRYPTION'),
            ]);
    
            $env_update->save();
    
            return back()->with('success', __('Mail Settings Saved !'));
        } catch (ValidationException $e) {
            return back()->withErrors($e->errors())->withInput();
        } catch (\Exception $e) {
            return back()->with('error', __('An error occurred while saving the mail settings. Please try again.'));
        }
    }
    

    public function show(Request $request)
    {
        
       // Retrieve values from the .env file
       $mailFromName = env('MAIL_FROM_NAME');
       $mailMailer = env('MAIL_MAILER');
       $mailHost = env('MAIL_HOST');
       $mailPort = env('MAIL_PORT');
       $mailFromAddress = env('MAIL_FROM_ADDRESS');
       $mailUsername = env('MAIL_USERNAME');
       $mailPassword = env('MAIL_PASSWORD');
       $mailEncryption = env('MAIL_ENCRYPTION');
       $settings = Settings::first();
       // Pass the values to a view
       return view('setting::mail', compact(
           'mailFromName',
           'mailMailer',
           'mailHost',
           'mailPort',
           'mailFromAddress',
           'mailUsername',
           'mailPassword',
           'mailEncryption',
           'settings'
       ));
   }

   public function sendEmail(Request $request)
   {
       $testEmail = $request->input('sender_email');
       
       try {
           Mail::to($testEmail)->send(new TestMail());
           return back()->with('success', 'Email sent successfully.');
       } catch (\Exception $e) {
           // Log the error if needed
           // Log::error('Error sending email: ' . $e->getMessage());
   
           return back()->with('error', 'There was an error sending the email: ' . $e->getMessage());
       }
   }
 
}
