<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware'=>['auth']], function(){
    Route::get('/radio', 'RadioController@index')->name('radio');
    Route::post('/radioData', 'RadioController@radioData')->name('radioData');
    Route::get('/radio/create', 'RadioController@create')->name('radio.create');
    Route::get('/radio/edit/{create}', 'RadioController@edit')->name('radio.edit');
    Route::post('/radio/addEditRadio/{create}', 'RadioController@addEditRadio')->name('addEditRadio');
    Route::delete('/radio/bulk_delete', 'RadioController@bulkDeleteRadioData')->name('radio.bulk_delete');
    Route::post('/radio/destroy/{id}', 'RadioController@destroyRadio')->name('radio.destroy');
    Route::patch('/radio/status/{id}', 'RadioController@updateRadioStatus');
    
});
