@extends('layouts.admin.main')
@section('title', __('adminWords.radio'))
@section('style')
    <link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{!empty($radioData) ? __('adminWords.update').' '.__('adminWords.radio') : __('adminWords.create').' '.__('adminWords.radio')}}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.radio')}}">{{ __('adminWords.radio') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>

<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">      
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('radio') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                              
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0">{{!empty($radioData) ? __('adminWords.update').' '.__('adminWords.radio') : __('adminWords.create').' '.__('adminWords.radio')}}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="admin-form">
                
                    @if(!empty($radioData))
                      {!! Form::model($radioData, ['method'=>'post', 'files'=>true, 'route'=>['addEditRadio', $radioData->id], 'id'=>'updateArtist', 'onsubmit'=>'return false', 'data-redirect' => url('/radio')]) !!}
                    @else
                        {!! Form::open(['method' => 'POST', 'route' => ['addEditRadio','create'], 'id'=>'addUpdateRadioForm', 'enctype'=>"multipart/form-data", 'data-reset'=>"1",'table-reload'=>"mrclsDtToShowData", 'data-redirect' => url('/radio') ]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                            <div class="form-group{{ $errors->has('radio_name') ? ' has-error' : '' }}">
                                <label for="radio_name">{{ __('adminWords.radio_name') }}<sup>*</sup></label>
                                 {!! Form::text('radio_name', null, ['class' => 'form-control require', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.radio_name')]) !!}
                                <small class="text-danger">{{ $errors->first('radio_name') }}</small>
                            </div>    
                            <div class="form-group{{ $errors->has('copyright') ? ' has-error' : '' }} switch-main-block">
                                {!! Form::label('copyright', __('adminWords.copyright')) !!}
                                {!! Form::text('copyright', null, ['class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.copyright')]) !!}
                                <small class="text-danger">{{ $errors->first('copyright') }}</small>
                            </div>  
                           
                            <div class="form-group{{ $errors->has('validity') ? ' has-error' : '' }}">
                                {!! Form::label('description', __('adminWords.description')) !!}
                                {!! Form::textarea('description', null, ['class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.description'), 'rows'=>3]) !!}
                                <small class="text-danger">{{ $errors->first('description') }}</small>
                            </div>  
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group{{ $errors->has('song_list') ? ' has-error' : '' }}">
                                <label for="song_list">{{ __('adminWords.select').' '.__('adminWords.song').' '.__('adminWords.list') }}<sup>*</sup></label>
                                <select name="song_list[]" id="" class="form-control multipleSelectWithSearch require" data-placeholder="{{ __('adminWords.choose')}}"  multiple="multiple">
                                    @foreach($song_list as $song)
                                        <option value="{{$song->id}}" @if(!empty($radioData)) @foreach(json_decode($radioData->song_list) as $sid) {{ $sid == $song->id ? "selected" : "" }} @endforeach @endif >{{ $song->audio_title }}</option> 
                                    @endforeach
                                </select>
                                <small class="text-danger">{{ $errors->first('song_list') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('language_id') ? ' has-error' : '' }}">
                                {!! Form::label('language', __('adminWords.select').' '.__('adminWords.language') ) !!}
                                {!! Form::select('language_id', $language, (!empty($radioData) ? $radioData->language_id : ''), ['class' => 'form-control select2WithSearch require','placeholder' => __('adminWords.choose')]) !!}
                                <small class="text-danger">{{ $errors->first('language_id') }}</small>
                            </div> 
                            
                            <div class="form-group{{$errors->has('image') ? 'has-error' : ''}}">
                                {!! Form::label('image', __('adminWords.radio').' '.__('adminWords.image'), ['class'=>'col-lg-12']) !!}
                                <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="{{ __('adminWords.radio').' '.__('adminWords.image')}}">
                                <i class="icon fa fa-check"></i>
                                {!! Form::file('image',['class' => 'form-control hide basicImage', 'data-label'=>'radioImage', 'name'=>'image', 'data-ext'=>"['jpg','jpeg','png']", 'data-image-id'=>'radio_image', 'data-image'=>__('adminWords.image_error'),'accept'=>'image/*']) !!}
                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                </label>
                                <input type="hidden" name="image" id="image_name" value="{{(!empty($radioData) ? $radioData->image:'')}}" placeholder="{{ __('Radio Image')}}">
                                <span class="image_title" id="radioImage">{{(!empty($radioData) && $radioData->image != '' ? $radioData->image : __('adminWords.choose_image') )}}</span>
                                <small class="text-danger">{{ $errors->first('image')}}</small>
                                <input type="hidden" id="radio_image" />
                                <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 500X500 px' }} </p>
                            </div>
                            <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('status', __('adminWords.status') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('status', 1, (!empty($radioData) && $radioData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('status') }}</small>
                            </div>
                            
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group"> 
                                @if(empty($radioData))
                                    <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset')}}</button>
                                @endif  
                                <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{!empty($radioData) ? __('adminWords.update') : __('adminWords.add') }}"><i class="fa fa-check-circle"></i> {{!empty($radioData) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                            </div>
                            <div class="clear-both"></div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
    <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
