<?php

namespace Modules\Radio\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Radio\Entities\Radio;
use Modules\Audio\Entities\Audio;
use Str;
use DataTables;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Validator;
class RadioController extends Controller
{
    public function index(){
        return view('radio::index');
    }

    public function radioData(){
        $radio = select(['column'=>'*','table'=>'radios','order'=>['id','desc']]);
        return DataTables::of($radio)
            ->editColumn('checkbox',function($radio){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$radio->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$radio->id.'"><label for="checkboxAll'.$radio->id.'" class="custom-control-label"></label></div>';
            })
            ->editColumn('image', function($radio){
                if($radio->image != '' && file_exists(public_path('/images/radio/'.$radio->image)))
                    $src = asset('/images/radio/'.$radio->image);
                else
                    $src = asset('images/sites/500x500.png');
                return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
            })
            ->editColumn('created_at', function($radio){
                return Carbon::parse($radio->created_at)->diffForHumans(Carbon::now());
            })
            ->editColumn('status', function($radio){
                return '<div class="custom-switch"><input id="switch'.$radio->id.'" name="status" class="custom-control-input changeStatus" '.($radio->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('radio/status/'.$radio->id).'"><label class="custom-control-label" for="switch'.$radio->id.'"></label></div>';
            })
            ->addColumn('action', function ($radio) {
                return '<div class="button-list"><a class="btn btn-sm btn-success-rgba" href="'.url('radio/edit/'.$radio->id).'"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('radio/destroy/'.$radio->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','image','status','action'])->make(true);
    }

    public function create(){
        $data['radioData'] = [];
        $data['song_list'] = Audio::where('status', 1)->orderBy('id', 'desc')->get();
        return view('radio::addEdit', $data);
    }

    public function addEditRadio(Request $request, $id){
        $rules = [ 'radio_name' => 'required',
                    'song_list'=>'required', 
                    'language_id' => 'required',
                    'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

    ];
        $checkValidate = validation($request->except('_token'), $rules);

        if($checkValidate['status'] == 1){
            $slug = Str::slug($request->radio_name,'-');
            $where = is_numeric($id) ? [['id','!=',$id],['radio_name','=',$slug]] : [['radio_name','=',$slug]];
            $checkRadio = Radio::where($where)->first();
            if(!empty($checkRadio) > 0){
                $resp = array('status'=>0, 'msg'=> __('adminWords.radio').' '.('adminWords.already_exist') );
            }else{
                $checkRadio = is_numeric($id) ? Radio::find($id) : [];
                $data = $request->except('_token');
                $data['radio_slug'] = $slug;
                $data['song_list'] = json_encode($request->song_list);
                $data['language_id'] = $request->language_id;
               $data['status'] = isset($request->status) ? 1 : 0;
                // ========================================
                if ($file = $request->file('image')) {
                    $validator = Validator::make(
                        [
                            'image' => strip_tags($request->image),
                            'extension' => strtolower($request->image->getClientOriginalExtension()),
                        ],
                        [
                            'image' => 'required',
                            'extension' => 'required|in:jpg,png',
                        ]
                    );
                    if ($validator->fails()) {
                        return back()->withErrors( __('Invalid file !'));
                    }
                    if ($file = $request->file('image')) {
                        $name = time() . $file->getClientOriginalName();
                        $file->move('images/radio', $name);
                        $data['image'] = $name;
                    }
                }
                
                $addRadio = empty($checkRadio) ? Radio::create($data) : $checkRadio->update($data);
                $resp = ($addRadio) ? ['status'=>1, 'msg'=> __('adminWords.radio').' '.__('adminWords.success_msg')] : ['status'=>0, 'msg'=> __('adminWords.error_msg') ];
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function edit($id){
        $radio = Radio::where('id',$id)->get();
        if(sizeof($radio) > 0){
            $data['radioData'] = $radio[0];
            $data['song_list'] = Audio::where('status', 1)->orderBy('id', 'desc')->get();
            return view('radio::addEdit',$data);
        }else{
            return redirect('radio');
        }
    }
    
    public function destroyRadio($id){
        $resp = singleDelete([ 'table'=>'radios','column'=>['image','radio_name'], 'where'=>['id'=>$id], 'msg'=> __('adminWords.radio').' '.__('adminWords.delete_success'), 'isImage'=>public_path().'/images/radio/' ]);
        echo $resp;        
    }

    function bulkDeleteRadioData(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').' '.__('adminWords.radio').' '.__('adminWords.must_selected') );
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'radios','column'=>'id', 'msg'=>__('adminWords.radio').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    function updateRadioStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'radios', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

}
